/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.renderer.lwjgl.render.font;

import de.lessvoid.nifty.elements.tools.FontHelper;
import de.lessvoid.nifty.renderer.lwjgl.render.LwjglRenderFont;
import de.lessvoid.nifty.renderer.lwjgl.render.LwjglRenderImage;
import de.lessvoid.nifty.renderer.lwjgl.render.font.AngelCodeFont;
import de.lessvoid.nifty.renderer.lwjgl.render.font.CharacterInfo;
import de.lessvoid.nifty.renderer.lwjgl.render.font.ColorValueParser;
import de.lessvoid.nifty.renderer.lwjgl.render.font.Tools;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.tools.Color;
import java.util.Hashtable;
import java.util.Map;
import org.lwjgl.opengl.GL11;

public class Font {
    private AngelCodeFont font;
    private int listId;
    private LwjglRenderImage[] textures;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private float selectionBackgroundR = 0.0f;
    private float selectionBackgroundG = 1.0f;
    private float selectionBackgroundB = 0.0f;
    private float selectionBackgroundA = 1.0f;
    private float selectionR = 1.0f;
    private float selectionG = 0.0f;
    private float selectionB = 0.0f;
    private float selectionA = 1.0f;
    private Map<Character, Integer> displayListMap = new Hashtable<Character, Integer>();
    private ColorValueParser colorValueParser = new ColorValueParser();

    public Font(RenderDevice device) {
    }

    private boolean isSelection() {
        return this.selectionStart != -1 || this.selectionEnd != -1;
    }

    public final boolean init(String filename) {
        this.font = new AngelCodeFont();
        if (!this.font.load(filename)) {
            return false;
        }
        this.textures = new LwjglRenderImage[this.font.getTextures().length];
        for (int i = 0; i < this.font.getTextures().length; ++i) {
            this.textures[i] = new LwjglRenderImage(this.extractPath(filename) + this.font.getTextures()[i], true);
        }
        this.initDisplayList();
        return true;
    }

    private String extractPath(String filename) {
        int idx = filename.lastIndexOf("/");
        if (idx == -1) {
            return "";
        }
        return filename.substring(0, idx) + "/";
    }

    private void initDisplayList() {
        this.displayListMap.clear();
        this.listId = GL11.glGenLists((int)this.font.getChars().size());
        Tools.checkGLError("glGenLists");
        int i = 0;
        for (Map.Entry<Character, CharacterInfo> entry : this.font.getChars().entrySet()) {
            this.displayListMap.put(entry.getKey(), this.listId + i);
            GL11.glNewList((int)(this.listId + i), (int)4864);
            Tools.checkGLError("glNewList");
            CharacterInfo charInfo = entry.getValue();
            if (charInfo != null) {
                GL11.glBegin((int)7);
                Tools.checkGLError("glBegin");
                float u0 = (float)charInfo.getX() / (float)this.font.getWidth();
                float v0 = (float)charInfo.getY() / (float)this.font.getHeight();
                float u1 = (float)(charInfo.getX() + charInfo.getWidth()) / (float)this.font.getWidth();
                float v1 = (float)(charInfo.getY() + charInfo.getHeight()) / (float)this.font.getHeight();
                GL11.glTexCoord2f((float)u0, (float)v0);
                GL11.glVertex2f((float)charInfo.getXoffset(), (float)charInfo.getYoffset());
                GL11.glTexCoord2f((float)u0, (float)v1);
                GL11.glVertex2f((float)charInfo.getXoffset(), (float)(charInfo.getYoffset() + charInfo.getHeight()));
                GL11.glTexCoord2f((float)u1, (float)v1);
                GL11.glVertex2f((float)(charInfo.getXoffset() + charInfo.getWidth()), (float)(charInfo.getYoffset() + charInfo.getHeight()));
                GL11.glTexCoord2f((float)u1, (float)v0);
                GL11.glVertex2f((float)(charInfo.getXoffset() + charInfo.getWidth()), (float)charInfo.getYoffset());
                GL11.glEnd();
                Tools.checkGLError("glEnd");
            }
            GL11.glEndList();
            Tools.checkGLError("glEndList");
            ++i;
        }
    }

    public void drawString(int x, int y, String text) {
        this.internalRenderText(x, y, text, 1.0f, false, 1.0f);
    }

    public void drawStringWithSize(int x, int y, String text, float size) {
        this.internalRenderText(x, y, text, size, false, 1.0f);
    }

    public void renderWithSizeAndColor(int x, int y, String text, float size, float r, float g, float b, float a) {
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        this.internalRenderText(x, y, text, size, false, a);
    }

    private void internalRenderText(int xPos, int yPos, String text, float size, boolean useAlphaTexture, float alpha) {
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        int originalWidth = this.getStringWidthInternal(text, 1.0f);
        int sizedWidth = this.getStringWidthInternal(text, size);
        int x = xPos - (sizedWidth - originalWidth) / 2;
        int activeTextureIdx = -1;
        for (int i = 0; i < text.length(); ++i) {
            ColorValueParser.Result result = this.colorValueParser.isColor(text, i);
            while (result.isColor()) {
                Color color = result.getColor();
                GL11.glColor4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)alpha);
                i = result.getNextIndex();
                if (i >= text.length()) break;
                result = this.colorValueParser.isColor(text, i);
            }
            if (i >= text.length()) break;
            char currentc = text.charAt(i);
            char nextc = FontHelper.getNextCharacter((String)text, (int)i);
            CharacterInfo charInfoC = this.font.getChar(currentc);
            int kerning = 0;
            float characterWidth = 0.0f;
            if (charInfoC == null) continue;
            int texId = charInfoC.getPage();
            if (activeTextureIdx != texId) {
                activeTextureIdx = texId;
                this.textures[activeTextureIdx].bind();
            }
            kerning = LwjglRenderFont.getKerning(charInfoC, nextc);
            characterWidth = (float)charInfoC.getXadvance() * size + (float)kerning;
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)x, (float)yPos, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(this.getHeight() / 2), (float)0.0f);
            GL11.glScalef((float)size, (float)size, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)(-this.getHeight() / 2), (float)0.0f);
            boolean characterDone = false;
            if (this.isSelection() && i >= this.selectionStart && i < this.selectionEnd) {
                GL11.glPushAttrib((int)1);
                this.disableBlend();
                GL11.glDisable((int)3553);
                GL11.glColor4f((float)this.selectionBackgroundR, (float)this.selectionBackgroundG, (float)this.selectionBackgroundB, (float)this.selectionBackgroundA);
                GL11.glBegin((int)7);
                GL11.glVertex2i((int)0, (int)0);
                GL11.glVertex2i((int)((int)characterWidth), (int)0);
                GL11.glVertex2i((int)((int)characterWidth), (int)(0 + this.getHeight()));
                GL11.glVertex2i((int)0, (int)(0 + this.getHeight()));
                GL11.glEnd();
                GL11.glEnable((int)3553);
                this.enableBlend();
                GL11.glColor4f((float)this.selectionR, (float)this.selectionG, (float)this.selectionB, (float)this.selectionA);
                GL11.glCallList((int)this.displayListMap.get(Character.valueOf(currentc)));
                Tools.checkGLError("glCallList");
                GL11.glPopAttrib();
                characterDone = true;
            }
            if (!characterDone) {
                GL11.glCallList((int)this.displayListMap.get(Character.valueOf(currentc)));
                Tools.checkGLError("glCallList");
            }
            x = (int)((float)x + characterWidth);
        }
        GL11.glPopMatrix();
    }

    private void disableBlend() {
        GL11.glDisable((int)3042);
    }

    private void enableBlend() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public int getStringWidth(String text) {
        return this.getStringWidthInternal(text, 1.0f);
    }

    private int getStringWidthInternal(String text, float size) {
        ColorValueParser.Result result;
        int length = 0;
        for (int i = 0; !(i >= text.length() || (result = this.colorValueParser.isColor(text, i)).isColor() && (i = result.getNextIndex()) >= text.length()); ++i) {
            char nextCharacter;
            char currentCharacter = text.charAt(i);
            Integer w = this.getCharacterWidth(currentCharacter, nextCharacter = FontHelper.getNextCharacter((String)text, (int)i), size);
            if (w == null) continue;
            length += w.intValue();
        }
        return length;
    }

    public int getHeight() {
        return this.font.getLineHeight();
    }

    public void setSelectionStart(int selectionStart) {
        this.selectionStart = selectionStart;
    }

    public void setSelectionEnd(int selectionEnd) {
        this.selectionEnd = selectionEnd;
    }

    public void setSelectionColor(float selectionR, float selectionG, float selectionB, float selectionA) {
        this.selectionR = selectionR;
        this.selectionG = selectionG;
        this.selectionB = selectionB;
        this.selectionA = selectionA;
    }

    public void setSelectionBackgroundColor(float selectionR, float selectionG, float selectionB, float selectionA) {
        this.selectionBackgroundR = selectionR;
        this.selectionBackgroundG = selectionG;
        this.selectionBackgroundB = selectionB;
        this.selectionBackgroundA = selectionA;
    }

    public CharacterInfo getChar(char character) {
        return this.font.getChar(character);
    }

    public Integer getCharacterWidth(char currentCharacter, char nextCharacter, float size) {
        CharacterInfo currentCharacterInfo = this.font.getChar(currentCharacter);
        if (currentCharacterInfo == null) {
            return null;
        }
        return new Integer((int)((float)currentCharacterInfo.getXadvance() * size + (float)Font.getKerning(currentCharacterInfo, nextCharacter)));
    }

    public static int getKerning(CharacterInfo charInfoC, char nextc) {
        Integer kern = charInfoC.getKerning().get(Character.valueOf(nextc));
        if (kern != null) {
            return kern;
        }
        return 0;
    }
}

