/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLPbufferContext;

public class EGLPbufferDrawable
extends EGLDrawable {
    private int texFormat;
    protected static final boolean useTexture = false;

    protected EGLPbufferDrawable(EGLDrawableFactory eGLDrawableFactory, NativeSurface nativeSurface) {
        super(eGLDrawableFactory, nativeSurface);
        this.ownEGLDisplay = true;
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)this.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
        this.texFormat = 12380;
        if (DEBUG) {
            System.out.println("Pbuffer config: " + this.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration());
        }
        this.setRealized(true);
        if (DEBUG) {
            System.out.println("Created pbuffer: " + this);
        }
    }

    @Override
    protected long createSurface(long l, long l2, long l3) {
        NativeSurface nativeSurface = this.getNativeSurface();
        int[] nArray = EGLGraphicsConfiguration.CreatePBufferSurfaceAttribList(nativeSurface.getWidth(), nativeSurface.getHeight(), this.texFormat);
        long l4 = EGL.eglCreatePbufferSurface(l, l2, nArray, 0);
        if (0L == l4) {
            throw new GLException("Creation of window surface (eglCreatePbufferSurface) failed, dim " + nativeSurface.getWidth() + "x" + nativeSurface.getHeight() + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println("PBuffer setSurface result: eglSurface 0x" + Long.toHexString(l4));
        }
        ((SurfaceChangeable)nativeSurface).setSurfaceHandle(l4);
        return l4;
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new EGLPbufferContext(this, gLContext);
    }

    @Override
    protected void swapBuffersImpl() {
        if (DEBUG) {
            System.err.println("unhandled swapBuffersImpl() called for: " + this);
        }
    }
}

