/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.renderer.RenderManager;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppStateManager {
    private final ArrayList<AppState> states = new ArrayList();
    private final Application app;
    private AppState[] stateArray;

    public AppStateManager(Application app) {
        this.app = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppState[] getArray() {
        ArrayList<AppState> arrayList = this.states;
        synchronized (arrayList) {
            if (this.stateArray == null) {
                this.stateArray = this.states.toArray(new AppState[this.states.size()]);
            }
            return this.stateArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attach(AppState state) {
        ArrayList<AppState> arrayList = this.states;
        synchronized (arrayList) {
            if (!this.states.contains(state)) {
                state.stateAttached(this);
                this.states.add(state);
                this.stateArray = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detach(AppState state) {
        ArrayList<AppState> arrayList = this.states;
        synchronized (arrayList) {
            if (this.states.contains(state)) {
                state.stateDetached(this);
                this.states.remove(state);
                this.stateArray = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasState(AppState state) {
        ArrayList<AppState> arrayList = this.states;
        synchronized (arrayList) {
            return this.states.contains(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AppState> T getState(Class<T> stateClass) {
        ArrayList<AppState> arrayList = this.states;
        synchronized (arrayList) {
            int num = this.states.size();
            for (int i = 0; i < num; ++i) {
                AppState state = this.states.get(i);
                if (!stateClass.isAssignableFrom(state.getClass())) continue;
                return (T)state;
            }
        }
        return null;
    }

    public void update(float tpf) {
        AppState[] array;
        for (AppState state : array = this.getArray()) {
            if (!state.isInitialized()) {
                state.initialize(this, this.app);
            }
            if (!state.isEnabled()) continue;
            state.update(tpf);
        }
    }

    public void render(RenderManager rm) {
        AppState[] array;
        for (AppState state : array = this.getArray()) {
            if (!state.isInitialized()) {
                state.initialize(this, this.app);
            }
            if (!state.isEnabled()) continue;
            state.render(rm);
        }
    }

    public void postRender() {
        AppState[] array;
        for (AppState state : array = this.getArray()) {
            if (!state.isInitialized()) {
                state.initialize(this, this.app);
            }
            if (!state.isEnabled()) continue;
            state.postRender();
        }
    }

    public void cleanup() {
        AppState[] array;
        for (AppState state : array = this.getArray()) {
            state.cleanup();
        }
    }
}

