/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.audio.AudioNode;
import com.jme3.audio.AudioParam;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.Environment;
import com.jme3.audio.Filter;
import com.jme3.audio.Listener;
import com.jme3.audio.ListenerParam;
import com.jme3.audio.android.AndroidAudioData;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AndroidAudioRenderer
implements AudioRenderer,
SoundPool.OnLoadCompleteListener,
MediaPlayer.OnCompletionListener {
    private static final Logger logger = Logger.getLogger(AndroidAudioRenderer.class.getName());
    private static final int MAX_NUM_CHANNELS = 16;
    private SoundPool soundPool = null;
    private HashMap<AudioNode, MediaPlayer> musicPlaying = new HashMap();
    private final Vector3f listenerPosition = new Vector3f();
    private final Vector3f distanceVector = new Vector3f();
    private final AudioManager manager;
    private final Context context;
    private final AssetManager am;
    private HashMap<Integer, AudioNode> mapLoadingAudioNodes = new HashMap();
    private final AtomicBoolean lastLoadCompleted = new AtomicBoolean();
    private Listener listener;
    private boolean audioDisabled = false;

    public AndroidAudioRenderer(Activity context) {
        this.context = context;
        this.manager = (AudioManager)context.getSystemService("audio");
        context.setVolumeControlStream(3);
        this.am = context.getAssets();
    }

    @Override
    public void initialize() {
        this.soundPool = new SoundPool(16, 3, 0);
        this.soundPool.setOnLoadCompleteListener((SoundPool.OnLoadCompleteListener)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateSourceParam(AudioNode src, AudioParam param) {
        if (this.audioDisabled) {
            return;
        }
        if (src.getChannel() < 0) {
            return;
        }
        assert (src.getChannel() >= 0);
        switch (param) {
            case Position: {
                if (!src.isPositional()) {
                    return;
                }
                Vector3f pos = src.getWorldTranslation();
                return;
            }
            case Velocity: {
                if (!src.isPositional()) {
                    return;
                }
                Vector3f vel = src.getVelocity();
                return;
            }
            case MaxDistance: {
                if (src.isPositional()) return;
                return;
            }
            case RefDistance: {
                if (src.isPositional()) return;
                return;
            }
            case ReverbFilter: {
                if (src.isPositional() && src.isReverbEnabled()) return;
                return;
            }
            case ReverbEnabled: {
                if (!src.isPositional()) {
                    return;
                }
                if (!src.isReverbEnabled()) return;
                this.updateSourceParam(src, AudioParam.ReverbFilter);
                return;
            }
            case IsPositional: {
                return;
            }
            case Direction: {
                if (!src.isDirectional()) {
                    return;
                }
                Vector3f dir = src.getDirection();
                return;
            }
            case InnerAngle: {
                if (src.isDirectional()) return;
                return;
            }
            case OuterAngle: {
                if (src.isDirectional()) return;
                return;
            }
            case IsDirectional: {
                if (!src.isDirectional()) return;
                this.updateSourceParam(src, AudioParam.Direction);
                this.updateSourceParam(src, AudioParam.InnerAngle);
                this.updateSourceParam(src, AudioParam.OuterAngle);
                return;
            }
            case DryFilter: {
                Filter f;
                if (src.getDryFilter() != null && !(f = src.getDryFilter()).isUpdateNeeded()) return;
            }
            case Looping: {
                if (!src.isLooping()) return;
                return;
            }
            case Volume: {
                this.soundPool.setVolume(src.getChannel(), src.getVolume(), src.getVolume());
                return;
            }
        }
    }

    @Override
    public void updateListenerParam(Listener listener, ListenerParam param) {
        if (this.audioDisabled) {
            return;
        }
        switch (param) {
            case Position: {
                this.listenerPosition.set(listener.getLocation());
                break;
            }
            case Rotation: {
                Vector3f dir = listener.getDirection();
                Vector3f up = listener.getUp();
                break;
            }
            case Velocity: {
                Vector3f vel = listener.getVelocity();
                break;
            }
        }
    }

    @Override
    public void update(float tpf) {
        for (AudioNode src : this.musicPlaying.keySet()) {
            MediaPlayer mp = this.musicPlaying.get(src);
            this.distanceVector.set(this.listenerPosition);
            this.distanceVector.subtractLocal(src.getLocalTranslation());
            float distance = FastMath.abs(this.distanceVector.length());
            if (distance < src.getRefDistance()) {
                distance = src.getRefDistance();
            }
            if (distance > src.getMaxDistance()) {
                distance = src.getMaxDistance();
            }
            float volume = src.getRefDistance() / distance;
            AndroidAudioData audioData = (AndroidAudioData)src.getAudioData();
            if (!(FastMath.abs(audioData.getCurrentVolume() - volume) > 1.1920929E-7f)) continue;
            mp.setVolume(volume, volume);
            audioData.setCurrentVolume(volume);
        }
    }

    @Override
    public void setListener(Listener listener) {
        if (this.audioDisabled) {
            return;
        }
        if (this.listener != null) {
            this.listener.setRenderer(null);
        }
        this.listener = listener;
        this.listener.setRenderer(this);
    }

    public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
        AudioNode src = this.mapLoadingAudioNodes.get(sampleId);
        if (src.getAudioData() instanceof AndroidAudioData) {
            AndroidAudioData audioData = (AndroidAudioData)src.getAudioData();
            if (status == 0) {
                int channelIndex = soundPool.play(audioData.getSoundId(), 1.0f, 1.0f, 1, -1, 1.0f);
                src.setChannel(channelIndex);
                if (src.getChannel() > 0) {
                    src.setStatus(AudioNode.Status.Playing);
                }
            } else {
                src.setChannel(-1);
            }
        } else {
            throw new IllegalArgumentException("AudioData is not of type AndroidAudioData for AudioNode " + src.toString());
        }
    }

    @Override
    public void cleanup() {
        if (this.soundPool != null) {
            for (AudioNode src : this.mapLoadingAudioNodes.values()) {
                AndroidAudioData audioData;
                if (src.getStatus() == AudioNode.Status.Playing && src.getChannel() > 0) {
                    this.soundPool.stop(src.getChannel());
                }
                if (!(src.getAudioData() instanceof AndroidAudioData) || (audioData = (AndroidAudioData)src.getAudioData()).getSoundId() <= 0) continue;
                this.soundPool.unload(audioData.getSoundId());
            }
            this.soundPool.release();
            this.soundPool = null;
        }
        for (AudioNode src : this.musicPlaying.keySet()) {
            MediaPlayer mp = this.musicPlaying.get(src);
            mp.stop();
            mp.release();
            src.setStatus(AudioNode.Status.Stopped);
        }
        this.musicPlaying.clear();
    }

    public void onCompletion(MediaPlayer mp) {
        for (AudioNode src : this.musicPlaying.keySet()) {
            if (this.musicPlaying.get(src) != mp) continue;
            mp.seekTo(0);
            mp.stop();
            src.setStatus(AudioNode.Status.Stopped);
            break;
        }
    }

    @Override
    public void playSourceInstance(AudioNode src) {
        if (this.audioDisabled) {
            return;
        }
        int soundId = 0;
        if (src.getAudioData() instanceof AndroidAudioData) {
            AndroidAudioData audioData = (AndroidAudioData)src.getAudioData();
            if (audioData.getAssetKey() instanceof AudioKey) {
                AudioKey assetKey = (AudioKey)audioData.getAssetKey();
                if (assetKey.isStream()) {
                    MediaPlayer mp;
                    if (this.musicPlaying.containsKey(src)) {
                        mp = this.musicPlaying.get(src);
                    } else {
                        mp = new MediaPlayer();
                        mp.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
                        this.musicPlaying.put(src, mp);
                    }
                    if (!mp.isPlaying()) {
                        try {
                            AssetFileDescriptor afd = this.am.openFd(assetKey.getName());
                            mp.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                            mp.setAudioStreamType(3);
                            mp.prepare();
                            mp.setLooping(src.isLooping());
                            mp.start();
                            src.setChannel(1);
                            src.setStatus(AudioNode.Status.Playing);
                        }
                        catch (IllegalArgumentException e) {
                            logger.log(Level.SEVERE, "Failed to play " + assetKey.getName(), e);
                        }
                        catch (IllegalStateException e) {
                            logger.log(Level.SEVERE, "Failed to play " + assetKey.getName(), e);
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "Failed to play " + assetKey.getName(), e);
                        }
                    }
                } else {
                    if (audioData.isUpdateNeeded() || audioData.getSoundId() <= 0) {
                        if (audioData.getSoundId() > 0) {
                            if (src.getChannel() > 0) {
                                this.soundPool.stop(src.getChannel());
                                src.setChannel(-1);
                            }
                            this.soundPool.unload(audioData.getSoundId());
                        }
                        try {
                            soundId = this.soundPool.load(this.am.openFd(assetKey.getName()), 1);
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "Failed to load sound " + assetKey.getName(), e);
                            soundId = -1;
                        }
                        audioData.setSoundId(soundId);
                    }
                    if (audioData.getSoundId() <= 0) {
                        throw new IllegalArgumentException("Failed to load: " + assetKey.getName());
                    }
                    int channelIndex = this.soundPool.play(audioData.getSoundId(), 1.0f, 1.0f, 1, -1, 1.0f);
                    if (channelIndex == 0) {
                        this.mapLoadingAudioNodes.put(audioData.getSoundId(), src);
                    }
                    src.setChannel(channelIndex);
                    if (src.getChannel() > 0) {
                        src.setStatus(AudioNode.Status.Playing);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("AudioData is not of type AndroidAudioData for AudioNode " + src.toString());
        }
    }

    @Override
    public void playSource(AudioNode src) {
        if (this.audioDisabled) {
            return;
        }
        if (src.getStatus() == AudioNode.Status.Playing) {
            return;
        }
        if (src.getStatus() == AudioNode.Status.Stopped) {
            this.playSourceInstance(src);
        }
    }

    @Override
    public void pauseSource(AudioNode src) {
        AndroidAudioData audioData;
        if (this.audioDisabled) {
            return;
        }
        if (src.getStatus() == AudioNode.Status.Playing && src.getAudioData() instanceof AndroidAudioData && (audioData = (AndroidAudioData)src.getAudioData()).getAssetKey() instanceof AudioKey) {
            AudioKey assetKey = (AudioKey)audioData.getAssetKey();
            if (assetKey.isStream()) {
                if (this.musicPlaying.containsKey(src)) {
                    MediaPlayer mp = this.musicPlaying.get(src);
                    mp.pause();
                    src.setStatus(AudioNode.Status.Paused);
                }
            } else {
                assert (src.getChannel() != -1);
                if (src.getChannel() > 0) {
                    this.soundPool.pause(src.getChannel());
                    src.setStatus(AudioNode.Status.Paused);
                }
            }
        }
    }

    @Override
    public void stopSource(AudioNode src) {
        AndroidAudioData audioData;
        if (this.audioDisabled) {
            return;
        }
        if (src.getStatus() != AudioNode.Status.Stopped && src.getAudioData() instanceof AndroidAudioData && (audioData = (AndroidAudioData)src.getAudioData()).getAssetKey() instanceof AudioKey) {
            AudioKey assetKey = (AudioKey)audioData.getAssetKey();
            if (assetKey.isStream()) {
                if (this.musicPlaying.containsKey(src)) {
                    MediaPlayer mp = this.musicPlaying.get(src);
                    mp.stop();
                    src.setStatus(AudioNode.Status.Stopped);
                    src.setChannel(-1);
                }
            } else {
                int chan = src.getChannel();
                assert (chan != -1);
                if (src.getChannel() > 0) {
                    this.soundPool.stop(src.getChannel());
                    src.setChannel(-1);
                }
                src.setStatus(AudioNode.Status.Stopped);
                if (audioData.getSoundId() > 0) {
                    this.soundPool.unload(audioData.getSoundId());
                }
                audioData.setSoundId(-1);
            }
        }
    }

    public void updateAudioData(AndroidAudioData data) {
        throw new UnsupportedOperationException("updateAudioData");
    }

    @Override
    public void deleteAudioData(AudioData ad) {
        if (ad instanceof AndroidAudioData) {
            AndroidAudioData audioData = (AndroidAudioData)ad;
            if (audioData.getAssetKey() instanceof AudioKey) {
                AudioKey assetKey = (AudioKey)audioData.getAssetKey();
                if (assetKey.isStream()) {
                    for (AudioNode src : this.musicPlaying.keySet()) {
                        if (src.getAudioData() != ad) continue;
                        MediaPlayer mp = this.musicPlaying.get(src);
                        mp.stop();
                        mp.release();
                        this.musicPlaying.remove(src);
                        src.setStatus(AudioNode.Status.Stopped);
                        src.setChannel(-1);
                        break;
                    }
                } else {
                    if (audioData.getSoundId() > 0) {
                        this.soundPool.unload(audioData.getSoundId());
                    }
                    audioData.setSoundId(0);
                }
            }
        } else {
            throw new IllegalArgumentException("AudioData is not of type AndroidAudioData in deleteAudioData");
        }
    }

    @Override
    public void setEnvironment(Environment env) {
    }
}

