/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public class RenderState
implements Cloneable,
Savable {
    public static final RenderState DEFAULT = new RenderState();
    public static final RenderState NULL = new RenderState();
    public static final RenderState ADDITIONAL = new RenderState();
    boolean pointSprite = false;
    boolean applyPointSprite = true;
    boolean wireframe = false;
    boolean applyWireFrame = true;
    FaceCullMode cullMode = FaceCullMode.Back;
    boolean applyCullMode = true;
    boolean depthWrite = true;
    boolean applyDepthWrite = true;
    boolean depthTest = true;
    boolean applyDepthTest = true;
    boolean colorWrite = true;
    boolean applyColorWrite = true;
    BlendMode blendMode = BlendMode.Off;
    boolean applyBlendMode = true;
    boolean alphaTest = false;
    boolean applyAlphaTest = true;
    float alphaFallOff = 0.0f;
    boolean applyAlphaFallOff = true;
    float offsetFactor = 0.0f;
    float offsetUnits = 0.0f;
    boolean offsetEnabled = false;
    boolean applyPolyOffset = true;
    boolean stencilTest = false;
    boolean applyStencilTest = false;
    StencilOperation frontStencilStencilFailOperation = StencilOperation.Keep;
    StencilOperation frontStencilDepthFailOperation = StencilOperation.Keep;
    StencilOperation frontStencilDepthPassOperation = StencilOperation.Keep;
    StencilOperation backStencilStencilFailOperation = StencilOperation.Keep;
    StencilOperation backStencilDepthFailOperation = StencilOperation.Keep;
    StencilOperation backStencilDepthPassOperation = StencilOperation.Keep;
    TestFunction frontStencilFunction = TestFunction.Always;
    TestFunction backStencilFunction = TestFunction.Always;

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.pointSprite, "pointSprite", false);
        oc.write(this.wireframe, "wireframe", false);
        oc.write(this.cullMode, "cullMode", FaceCullMode.Back);
        oc.write(this.depthWrite, "depthWrite", true);
        oc.write(this.depthTest, "depthTest", true);
        oc.write(this.colorWrite, "colorWrite", true);
        oc.write(this.blendMode, "blendMode", BlendMode.Off);
        oc.write(this.alphaTest, "alphaTest", false);
        oc.write(this.alphaFallOff, "alphaFallOff", 0.0f);
        oc.write(this.offsetEnabled, "offsetEnabled", false);
        oc.write(this.offsetFactor, "offsetFactor", 0.0f);
        oc.write(this.offsetUnits, "offsetUnits", 0.0f);
        oc.write(this.stencilTest, "stencilTest", false);
        oc.write(this.frontStencilStencilFailOperation, "frontStencilStencilFailOperation", StencilOperation.Keep);
        oc.write(this.frontStencilDepthFailOperation, "frontStencilDepthFailOperation", StencilOperation.Keep);
        oc.write(this.frontStencilDepthPassOperation, "frontStencilDepthPassOperation", StencilOperation.Keep);
        oc.write(this.backStencilStencilFailOperation, "frontStencilStencilFailOperation", StencilOperation.Keep);
        oc.write(this.backStencilDepthFailOperation, "backStencilDepthFailOperation", StencilOperation.Keep);
        oc.write(this.backStencilDepthPassOperation, "backStencilDepthPassOperation", StencilOperation.Keep);
        oc.write(this.frontStencilFunction, "frontStencilFunction", TestFunction.Always);
        oc.write(this.backStencilFunction, "backStencilFunction", TestFunction.Always);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.pointSprite = ic.readBoolean("pointSprite", false);
        this.wireframe = ic.readBoolean("wireframe", false);
        this.cullMode = ic.readEnum("cullMode", FaceCullMode.class, FaceCullMode.Back);
        this.depthWrite = ic.readBoolean("depthWrite", true);
        this.depthTest = ic.readBoolean("depthTest", true);
        this.colorWrite = ic.readBoolean("colorWrite", true);
        this.blendMode = ic.readEnum("blendMode", BlendMode.class, BlendMode.Off);
        this.alphaTest = ic.readBoolean("alphaTest", false);
        this.alphaFallOff = ic.readFloat("alphaFallOff", 0.0f);
        this.offsetEnabled = ic.readBoolean("offsetEnabled", false);
        this.offsetFactor = ic.readFloat("offsetFactor", 0.0f);
        this.offsetUnits = ic.readFloat("offsetUnits", 0.0f);
        this.stencilTest = ic.readBoolean("stencilTest", false);
        this.frontStencilStencilFailOperation = ic.readEnum("frontStencilStencilFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.frontStencilDepthFailOperation = ic.readEnum("frontStencilDepthFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.frontStencilDepthPassOperation = ic.readEnum("frontStencilDepthPassOperation", StencilOperation.class, StencilOperation.Keep);
        this.backStencilStencilFailOperation = ic.readEnum("backStencilStencilFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.backStencilDepthFailOperation = ic.readEnum("backStencilDepthFailOperation", StencilOperation.class, StencilOperation.Keep);
        this.backStencilDepthPassOperation = ic.readEnum("backStencilDepthPassOperation", StencilOperation.class, StencilOperation.Keep);
        this.frontStencilFunction = ic.readEnum("frontStencilFunction", TestFunction.class, TestFunction.Always);
        this.backStencilFunction = ic.readEnum("backStencilFunction", TestFunction.class, TestFunction.Always);
    }

    public RenderState clone() {
        try {
            return (RenderState)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public void setPointSprite(boolean pointSprite) {
        this.applyPointSprite = true;
        this.pointSprite = pointSprite;
    }

    public void setAlphaFallOff(float alphaFallOff) {
        this.applyAlphaFallOff = true;
        this.alphaFallOff = alphaFallOff;
    }

    public void setAlphaTest(boolean alphaTest) {
        this.applyAlphaTest = true;
        this.alphaTest = alphaTest;
    }

    public void setColorWrite(boolean colorWrite) {
        this.applyColorWrite = true;
        this.colorWrite = colorWrite;
    }

    public void setFaceCullMode(FaceCullMode cullMode) {
        this.applyCullMode = true;
        this.cullMode = cullMode;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.applyBlendMode = true;
        this.blendMode = blendMode;
    }

    public void setDepthTest(boolean depthTest) {
        this.applyDepthTest = true;
        this.depthTest = depthTest;
    }

    public void setDepthWrite(boolean depthWrite) {
        this.applyDepthWrite = true;
        this.depthWrite = depthWrite;
    }

    public void setWireframe(boolean wireframe) {
        this.applyWireFrame = true;
        this.wireframe = wireframe;
    }

    public void setPolyOffset(float factor, float units) {
        this.applyPolyOffset = true;
        this.offsetEnabled = true;
        this.offsetFactor = factor;
        this.offsetUnits = units;
    }

    public void setStencil(boolean enabled, StencilOperation _frontStencilStencilFailOperation, StencilOperation _frontStencilDepthFailOperation, StencilOperation _frontStencilDepthPassOperation, StencilOperation _backStencilStencilFailOperation, StencilOperation _backStencilDepthFailOperation, StencilOperation _backStencilDepthPassOperation, TestFunction _frontStencilFunction, TestFunction _backStencilFunction) {
        this.stencilTest = enabled;
        this.applyStencilTest = true;
        this.frontStencilStencilFailOperation = _frontStencilStencilFailOperation;
        this.frontStencilDepthFailOperation = _frontStencilDepthFailOperation;
        this.frontStencilDepthPassOperation = _frontStencilDepthPassOperation;
        this.backStencilStencilFailOperation = _backStencilStencilFailOperation;
        this.backStencilDepthFailOperation = _backStencilDepthFailOperation;
        this.backStencilDepthPassOperation = _backStencilDepthPassOperation;
        this.frontStencilFunction = _frontStencilFunction;
        this.backStencilFunction = _backStencilFunction;
    }

    public boolean isStencilTest() {
        return this.stencilTest;
    }

    public StencilOperation getFrontStencilStencilFailOperation() {
        return this.frontStencilStencilFailOperation;
    }

    public StencilOperation getFrontStencilDepthFailOperation() {
        return this.frontStencilDepthFailOperation;
    }

    public StencilOperation getFrontStencilDepthPassOperation() {
        return this.frontStencilDepthPassOperation;
    }

    public StencilOperation getBackStencilStencilFailOperation() {
        return this.backStencilStencilFailOperation;
    }

    public StencilOperation getBackStencilDepthFailOperation() {
        return this.backStencilDepthFailOperation;
    }

    public StencilOperation getBackStencilDepthPassOperation() {
        return this.backStencilDepthPassOperation;
    }

    public TestFunction getFrontStencilFunction() {
        return this.frontStencilFunction;
    }

    public TestFunction getBackStencilFunction() {
        return this.backStencilFunction;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public boolean isPointSprite() {
        return this.pointSprite;
    }

    public boolean isAlphaTest() {
        return this.alphaTest;
    }

    public FaceCullMode getFaceCullMode() {
        return this.cullMode;
    }

    public boolean isDepthTest() {
        return this.depthTest;
    }

    public boolean isDepthWrite() {
        return this.depthWrite;
    }

    public boolean isWireframe() {
        return this.wireframe;
    }

    public boolean isColorWrite() {
        return this.colorWrite;
    }

    public float getPolyOffsetFactor() {
        return this.offsetFactor;
    }

    public float getPolyOffsetUnits() {
        return this.offsetUnits;
    }

    public boolean isPolyOffset() {
        return this.offsetEnabled;
    }

    public float getAlphaFallOff() {
        return this.alphaFallOff;
    }

    public RenderState copyMergedTo(RenderState additionalState, RenderState state) {
        if (additionalState == null) {
            return this;
        }
        state.pointSprite = additionalState.applyPointSprite ? additionalState.pointSprite : this.pointSprite;
        state.wireframe = additionalState.applyWireFrame ? additionalState.wireframe : this.wireframe;
        state.cullMode = additionalState.applyCullMode ? additionalState.cullMode : this.cullMode;
        state.depthWrite = additionalState.applyDepthWrite ? additionalState.depthWrite : this.depthWrite;
        state.depthTest = additionalState.applyDepthTest ? additionalState.depthTest : this.depthTest;
        state.colorWrite = additionalState.applyColorWrite ? additionalState.colorWrite : this.colorWrite;
        state.blendMode = additionalState.applyBlendMode ? additionalState.blendMode : this.blendMode;
        state.alphaTest = additionalState.applyAlphaTest ? additionalState.alphaTest : this.alphaTest;
        state.alphaFallOff = additionalState.applyAlphaFallOff ? additionalState.alphaFallOff : this.alphaFallOff;
        if (additionalState.applyPolyOffset) {
            state.offsetEnabled = additionalState.offsetEnabled;
            state.offsetFactor = additionalState.offsetFactor;
            state.offsetUnits = additionalState.offsetUnits;
        } else {
            state.offsetEnabled = this.offsetEnabled;
            state.offsetFactor = this.offsetFactor;
            state.offsetUnits = this.offsetUnits;
        }
        if (additionalState.applyStencilTest) {
            state.stencilTest = additionalState.stencilTest;
            state.frontStencilStencilFailOperation = additionalState.frontStencilStencilFailOperation;
            state.frontStencilDepthFailOperation = additionalState.frontStencilDepthFailOperation;
            state.frontStencilDepthPassOperation = additionalState.frontStencilDepthPassOperation;
            state.backStencilStencilFailOperation = additionalState.backStencilStencilFailOperation;
            state.backStencilDepthFailOperation = additionalState.backStencilDepthFailOperation;
            state.backStencilDepthPassOperation = additionalState.backStencilDepthPassOperation;
            state.frontStencilFunction = additionalState.frontStencilFunction;
            state.backStencilFunction = additionalState.backStencilFunction;
        } else {
            state.stencilTest = this.stencilTest;
            state.frontStencilStencilFailOperation = this.frontStencilStencilFailOperation;
            state.frontStencilDepthFailOperation = this.frontStencilDepthFailOperation;
            state.frontStencilDepthPassOperation = this.frontStencilDepthPassOperation;
            state.backStencilStencilFailOperation = this.backStencilStencilFailOperation;
            state.backStencilDepthFailOperation = this.backStencilDepthFailOperation;
            state.backStencilDepthPassOperation = this.backStencilDepthPassOperation;
            state.frontStencilFunction = this.frontStencilFunction;
            state.backStencilFunction = this.backStencilFunction;
        }
        return state;
    }

    public String toString() {
        return "RenderState[\npointSprite=" + this.pointSprite + "\napplyPointSprite=" + this.applyPointSprite + "\nwireframe=" + this.wireframe + "\napplyWireFrame=" + this.applyWireFrame + "\ncullMode=" + (Object)((Object)this.cullMode) + "\napplyCullMode=" + this.applyCullMode + "\ndepthWrite=" + this.depthWrite + "\napplyDepthWrite=" + this.applyDepthWrite + "\ndepthTest=" + this.depthTest + "\napplyDepthTest=" + this.applyDepthTest + "\ncolorWrite=" + this.colorWrite + "\napplyColorWrite=" + this.applyColorWrite + "\nblendMode=" + (Object)((Object)this.blendMode) + "\napplyBlendMode=" + this.applyBlendMode + "\nalphaTest=" + this.alphaTest + "\napplyAlphaTest=" + this.applyAlphaTest + "\nalphaFallOff=" + this.alphaFallOff + "\napplyAlphaFallOff=" + this.applyAlphaFallOff + "\noffsetEnabled=" + this.offsetEnabled + "\napplyPolyOffset=" + this.applyPolyOffset + "\noffsetFactor=" + this.offsetFactor + "\noffsetUnits=" + this.offsetUnits + "\n]";
    }

    static {
        RenderState.NULL.cullMode = FaceCullMode.Off;
        RenderState.NULL.depthTest = false;
        RenderState.ADDITIONAL.applyPointSprite = false;
        RenderState.ADDITIONAL.applyWireFrame = false;
        RenderState.ADDITIONAL.applyCullMode = false;
        RenderState.ADDITIONAL.applyDepthWrite = false;
        RenderState.ADDITIONAL.applyDepthTest = false;
        RenderState.ADDITIONAL.applyColorWrite = false;
        RenderState.ADDITIONAL.applyBlendMode = false;
        RenderState.ADDITIONAL.applyAlphaTest = false;
        RenderState.ADDITIONAL.applyAlphaFallOff = false;
        RenderState.ADDITIONAL.applyPolyOffset = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StencilOperation {
        Keep,
        Zero,
        Replace,
        Increment,
        IncrementWrap,
        Decrement,
        DecrementWrap,
        Invert;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaceCullMode {
        Off,
        Front,
        Back,
        FrontAndBack;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlendMode {
        Off,
        Additive,
        PremultAlpha,
        AlphaAdditive,
        Color,
        Alpha,
        Modulate,
        ModulateX2;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestFunction {
        Never,
        Equal,
        Less,
        LessOrEqual,
        Greater,
        GreaterOrEqual,
        NotEqual,
        Always;

    }
}

