/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.sync;

import com.jme3.math.FastMath;
import com.jme3.network.connection.Client;
import com.jme3.network.connection.Server;
import com.jme3.network.events.ConnectionAdapter;
import com.jme3.network.service.Service;
import com.jme3.network.sync.EntitySyncInfo;
import com.jme3.network.sync.SyncEntity;
import com.jme3.network.sync.SyncMessage;
import com.jme3.network.sync.SyncSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class ServerSyncService
extends ConnectionAdapter
implements Service {
    private static final ByteBuffer BUFFER = ByteBuffer.wrap(new byte[10000]);
    private float updateRate = 0.1f;
    private float packetDropRate = 0.0f;
    private long latency = 0L;
    private HashMap<Long, SyncMessage> latencyQueue;
    private final Server server;
    private final SyncSerializer serializer = new SyncSerializer();
    private final ArrayList<SyncEntity> npcs = new ArrayList();
    private final HashMap<SyncEntity, Integer> npcToId = new HashMap();
    private static int nextId = 0;
    private int heartbeat = 0;
    private float time = 0.0f;

    public ServerSyncService(Server server) {
        this.server = server;
        server.addConnectionListener(this);
    }

    public void setNetworkSimulationParams(float packetDropRate, long latency) {
        if (this.latencyQueue == null) {
            this.latencyQueue = new HashMap();
        }
        this.packetDropRate = packetDropRate;
        this.latency = latency;
    }

    private EntitySyncInfo generateInitInfo(SyncEntity entity, boolean newId) {
        int n;
        EntitySyncInfo info = new EntitySyncInfo();
        info.className = entity.getClass().getName();
        if (newId) {
            int n2 = nextId;
            n = n2;
            nextId = n2 + 1;
        } else {
            n = this.npcToId.get(entity);
        }
        info.id = n;
        info.type = 1;
        BUFFER.clear();
        this.serializer.write(entity, BUFFER, true);
        BUFFER.flip();
        info.data = new byte[BUFFER.limit()];
        BUFFER.get(info.data);
        return info;
    }

    private EntitySyncInfo generateSyncInfo(SyncEntity entity) {
        EntitySyncInfo info = new EntitySyncInfo();
        info.className = null;
        info.id = this.npcToId.get(entity);
        info.type = (byte)2;
        BUFFER.clear();
        this.serializer.write(entity, BUFFER, false);
        BUFFER.flip();
        info.data = new byte[BUFFER.limit()];
        BUFFER.get(info.data);
        return info;
    }

    private EntitySyncInfo generateDeleteInfo(SyncEntity entity) {
        EntitySyncInfo info = new EntitySyncInfo();
        info.className = null;
        info.id = this.npcToId.get(entity);
        info.type = (byte)3;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNpc(SyncEntity entity) {
        EntitySyncInfo info = this.generateInitInfo(entity, true);
        SyncMessage syncMsg = new SyncMessage();
        syncMsg.setReliable(true);
        syncMsg.heartbeat = this.heartbeat;
        syncMsg.infos = new EntitySyncInfo[]{info};
        try {
            this.server.broadcast(syncMsg);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ArrayList<SyncEntity> arrayList = this.npcs;
        synchronized (arrayList) {
            this.npcs.add(entity);
            this.npcToId.put(entity, info.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNpc(SyncEntity entity) {
        EntitySyncInfo info = this.generateDeleteInfo(entity);
        SyncMessage syncMsg = new SyncMessage();
        syncMsg.setReliable(true);
        syncMsg.heartbeat = this.heartbeat;
        syncMsg.infos = new EntitySyncInfo[]{info};
        try {
            this.server.broadcast(syncMsg);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ArrayList<SyncEntity> arrayList = this.npcs;
        synchronized (arrayList) {
            this.npcs.remove(entity);
            this.npcToId.remove(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientConnected(Client client) {
        System.out.println("Server: Client connected: " + client);
        SyncMessage msg = new SyncMessage();
        msg.setReliable(true);
        msg.heartbeat = this.heartbeat;
        EntitySyncInfo[] infos = new EntitySyncInfo[this.npcs.size()];
        msg.infos = infos;
        ArrayList<SyncEntity> arrayList = this.npcs;
        synchronized (arrayList) {
            for (int i = 0; i < this.npcs.size(); ++i) {
                EntitySyncInfo info;
                SyncEntity entity = this.npcs.get(i);
                infos[i] = info = this.generateInitInfo(entity, false);
            }
            try {
                client.send(msg);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void clientDisconnected(Client client) {
        System.out.println("Server: Client disconnected: " + client);
    }

    private void sendDelayedMessages() {
        ArrayList<Long> removeList = new ArrayList<Long>();
        for (Map.Entry<Long, SyncMessage> entry : this.latencyQueue.entrySet()) {
            if (entry.getKey() > System.currentTimeMillis()) continue;
            removeList.add(entry.getKey());
            if (this.packetDropRate > FastMath.nextRandomFloat()) continue;
            for (Client client : this.server.getConnectors()) {
                try {
                    client.send(entry.getValue());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        for (Long removeEntry : removeList) {
            this.latencyQueue.remove(removeEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(float tpf) {
        if (this.latencyQueue != null) {
            this.sendDelayedMessages();
        }
        if (this.npcs.size() == 0) {
            return;
        }
        this.time += tpf;
        if (this.time < this.updateRate) {
            return;
        }
        this.time = 0.0f;
        SyncMessage msg = new SyncMessage();
        msg.setReliable(false);
        msg.heartbeat = this.heartbeat;
        ArrayList<SyncEntity> arrayList = this.npcs;
        synchronized (arrayList) {
            EntitySyncInfo[] infos = new EntitySyncInfo[this.npcs.size()];
            msg.infos = infos;
            for (int i = 0; i < this.npcs.size(); ++i) {
                SyncEntity entity = this.npcs.get(i);
                EntitySyncInfo info = this.generateSyncInfo(entity);
                entity.onLocalUpdate();
                infos[i] = info;
            }
        }
        if (this.latencyQueue != null) {
            long latencyTime = (long)((float)this.latency + (FastMath.nextRandomFloat() - 0.5f) * (float)this.latency);
            long timeToSend = System.currentTimeMillis() + latencyTime;
            this.latencyQueue.put(timeToSend, msg);
        } else {
            for (Client client : this.server.getConnectors()) {
                try {
                    client.send(msg);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        ++this.heartbeat;
        if (this.heartbeat < 0) {
            this.heartbeat = 0;
        }
    }
}

