/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.ModelKey;
import com.jme3.light.Light;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.JmeConverter;
import com.jme3.scene.plugins.blender.animations.ArmatureHelper;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.cameras.CameraHelper;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.curves.CurvesHelper;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.lights.LightHelper;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.modifiers.ModifierHelper;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import com.jme3.scene.plugins.blender.particles.ParticlesHelper;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlenderLoader
implements AssetLoader {
    private static final Logger LOGGER = Logger.getLogger(BlenderLoader.class.getName());
    protected JmeConverter converter;
    protected DataRepository dataRepository;
    protected BlenderKey blenderKey;
    protected List<FileBlockHeader> blocks;
    protected BlenderInputStream inputStream;

    public Spatial load(AssetInfo assetInfo) throws IOException {
        try {
            this.setup(assetInfo);
            BlenderKey.LoadingResults loadingResults = this.blenderKey.prepareLoadingResults();
            BlenderKey.WorldData worldData = null;
            for (FileBlockHeader block : this.blocks) {
                switch (block.getCode()) {
                    case 1329725440: {
                        Object object = this.converter.toObject(block.getStructure(this.dataRepository));
                        if (object instanceof Node) {
                            if ((this.blenderKey.getFeaturesToLoad() & 0xB) == 0) break;
                            LOGGER.log(Level.INFO, "{0}: {1}--> {2}", new Object[]{((Node)object).getName(), ((Node)object).getLocalTranslation().toString(), ((Node)object).getParent() == null ? "null" : ((Node)object).getParent().getName()});
                            if (((Node)object).getParent() != null) break;
                            loadingResults.addObject((Node)object);
                            break;
                        }
                        if (object instanceof Camera) {
                            if ((this.blenderKey.getFeaturesToLoad() & 0x20) == 0) break;
                            loadingResults.addCamera((Camera)object);
                            break;
                        }
                        if (!(object instanceof Light) || (this.blenderKey.getFeaturesToLoad() & 0x10) == 0) break;
                        loadingResults.addLight((Light)object);
                        break;
                    }
                    case 1296105472: {
                        if (!this.blenderKey.isLoadUnlinkedAssets() || (this.blenderKey.getFeaturesToLoad() & 3) == 0) break;
                        loadingResults.addMaterial(this.converter.toMaterial(block.getStructure(this.dataRepository)));
                        break;
                    }
                    case 1396899840: {
                        if ((this.blenderKey.getFeaturesToLoad() & 0xFFFF) == 0) break;
                        loadingResults.addScene(this.converter.toScene(block.getStructure(this.dataRepository)));
                        break;
                    }
                    case 1464795136: {
                        if (!this.blenderKey.isLoadUnlinkedAssets() || worldData != null) break;
                        Structure worldStructure = block.getStructure(this.dataRepository);
                        String worldName = worldStructure.getName();
                        if (this.blenderKey.getUsedWorld() != null && !this.blenderKey.getUsedWorld().equals(worldName)) break;
                        worldData = this.converter.toWorldData(worldStructure);
                        if ((this.blenderKey.getFeaturesToLoad() & 0x10) == 0) break;
                        loadingResults.addLight(worldData.getAmbientLight());
                    }
                }
            }
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            return loadingResults;
        }
        catch (BlenderFileException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected void setup(AssetInfo assetInfo) throws BlenderFileException {
        FileBlockHeader fileBlock;
        ModelKey modelKey = (ModelKey)assetInfo.getKey();
        if (modelKey instanceof BlenderKey) {
            this.blenderKey = (BlenderKey)modelKey;
        } else {
            this.blenderKey = new BlenderKey(modelKey.getName());
            this.blenderKey.setAssetRootPath(modelKey.getFolder());
        }
        this.inputStream = new BlenderInputStream(assetInfo.openStream(), assetInfo.getManager());
        this.blocks = new ArrayList<FileBlockHeader>();
        this.dataRepository = new DataRepository();
        this.dataRepository.setAssetManager(assetInfo.getManager());
        this.dataRepository.setInputStream(this.inputStream);
        this.dataRepository.setBlenderKey(this.blenderKey);
        this.dataRepository.putHelper(ArmatureHelper.class, new ArmatureHelper(this.inputStream.getVersionNumber()));
        this.dataRepository.putHelper(TextureHelper.class, new TextureHelper(this.inputStream.getVersionNumber()));
        this.dataRepository.putHelper(MeshHelper.class, new MeshHelper(this.inputStream.getVersionNumber()));
        this.dataRepository.putHelper(ObjectHelper.class, new ObjectHelper(this.inputStream.getVersionNumber()));
        this.dataRepository.putHelper(CurvesHelper.class, new CurvesHelper(this.inputStream.getVersionNumber()));
        this.dataRepository.putHelper(LightHelper.class, new LightHelper(this.inputStream.getVersionNumber()));
        this.dataRepository.putHelper(CameraHelper.class, new CameraHelper(this.inputStream.getVersionNumber()));
        this.dataRepository.putHelper(ModifierHelper.class, new ModifierHelper(this.inputStream.getVersionNumber()));
        this.dataRepository.putHelper(MaterialHelper.class, new MaterialHelper(this.inputStream.getVersionNumber()));
        this.dataRepository.putHelper(ConstraintHelper.class, new ConstraintHelper(this.inputStream.getVersionNumber(), this.dataRepository));
        this.dataRepository.putHelper(IpoHelper.class, new IpoHelper(this.inputStream.getVersionNumber()));
        this.dataRepository.putHelper(ParticlesHelper.class, new ParticlesHelper(this.inputStream.getVersionNumber()));
        if (this.blenderKey.isFixUpAxis()) {
            ObjectHelper objectHelper = (ObjectHelper)this.dataRepository.getHelper(ObjectHelper.class);
            objectHelper.setyIsUpAxis(true);
            CurvesHelper curvesHelper = (CurvesHelper)this.dataRepository.getHelper(CurvesHelper.class);
            curvesHelper.setyIsUpAxis(true);
        }
        MaterialHelper materialHelper = (MaterialHelper)this.dataRepository.getHelper(MaterialHelper.class);
        materialHelper.setFaceCullMode(this.blenderKey.getFaceCullMode());
        FileBlockHeader sceneFileBlock = null;
        do {
            if ((fileBlock = new FileBlockHeader(this.inputStream, this.dataRepository)).isDnaBlock()) continue;
            this.blocks.add(fileBlock);
            if (fileBlock.getCode() != 1396899840 || this.blenderKey.getLayersToLoad() >= 0) continue;
            sceneFileBlock = fileBlock;
        } while (!fileBlock.isLastBlock());
        if (sceneFileBlock != null) {
            int lay = ((Number)sceneFileBlock.getStructure(this.dataRepository).getFieldValue("lay")).intValue();
            this.dataRepository.getBlenderKey().setLayersToLoad(lay);
        }
        this.converter = new JmeConverter(this.dataRepository);
    }
}

