/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.BlenderKey;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderLoader;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlenderModelLoader
extends BlenderLoader {
    private static final Logger LOGGER = Logger.getLogger(BlenderModelLoader.class.getName());

    public Spatial load(AssetInfo assetInfo) throws IOException {
        try {
            this.setup(assetInfo);
            BlenderKey.LoadingResults loadingResults = this.blenderKey.prepareLoadingResults();
            for (FileBlockHeader block : this.blocks) {
                Object object;
                if (block.getCode() != 1329725440 || !((object = this.converter.toObject(block.getStructure(this.dataRepository))) instanceof Node)) continue;
                LOGGER.log(Level.INFO, "{0}: {1}--> {2}", new Object[]{((Node)object).getName(), ((Node)object).getLocalTranslation().toString(), ((Node)object).getParent() == null ? "null" : ((Node)object).getParent().getName()});
                if (((Node)object).getParent() != null) continue;
                loadingResults.addObject((Node)object);
            }
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                LOGGER.warning(e.getLocalizedMessage());
            }
            List<Node> objects = loadingResults.getObjects();
            if (objects.size() > 0) {
                Node modelNode = new Node(this.blenderKey.getName());
                for (Node object : objects) {
                    modelNode.attachChild(object);
                }
                return modelNode;
            }
            if (objects.size() == 1) {
                return objects.get(0);
            }
        }
        catch (BlenderFileException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }
}

