/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.BoneTrack;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.curves.BezierCurve;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.List;

public class IpoHelper
extends AbstractBlenderHelper {
    public IpoHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public Ipo createIpo(Structure ipoStructure, DataRepository dataRepository) throws BlenderFileException {
        Structure curvebase = (Structure)ipoStructure.getFieldValue("curve");
        Ipo result = null;
        List<Structure> curves = curvebase.evaluateListBase(dataRepository);
        if (curves.size() > 0) {
            BezierCurve[] bezierCurves = new BezierCurve[curves.size()];
            int frame = 0;
            for (Structure curve : curves) {
                Pointer pBezTriple = (Pointer)curve.getFieldValue("bezt");
                List<Structure> bezTriples = pBezTriple.fetchData(dataRepository.getInputStream());
                int type = ((Number)curve.getFieldValue("adrcode")).intValue();
                bezierCurves[frame++] = new BezierCurve(type, bezTriples, 2);
            }
            curves.clear();
            result = new Ipo(bezierCurves);
            dataRepository.addLoadedFeatures(ipoStructure.getOldMemoryAddress(), ipoStructure.getName(), ipoStructure, result);
        }
        return result;
    }

    public Ipo createIpo(float constValue) {
        return new ConstIpo(constValue);
    }

    public boolean shouldBeLoaded(Structure structure, DataRepository dataRepository) {
        return true;
    }

    private class ConstIpo
    extends Ipo {
        private float constValue;

        public ConstIpo(float constValue) {
            super(null);
            this.constValue = constValue;
        }

        public float calculateValue(int frame) {
            return this.constValue;
        }

        public float calculateValue(int frame, int curveIndex) {
            return this.constValue;
        }

        public int getCurvesAmount() {
            return 0;
        }

        public BoneTrack calculateTrack(int boneIndex, int startFrame, int stopFrame, int fps) {
            throw new IllegalStateException("Constatnt ipo object cannot be used for calculating bone tracks!");
        }
    }
}

