/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.BoneAnimation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintLocLimit
extends Constraint {
    private static final int LIMIT_XMIN = 1;
    private static final int LIMIT_XMAX = 2;
    private static final int LIMIT_YMIN = 4;
    private static final int LIMIT_YMAX = 8;
    private static final int LIMIT_ZMIN = 16;
    private static final int LIMIT_ZMAX = 32;

    public ConstraintLocLimit(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, DataRepository dataRepository) throws BlenderFileException {
        super(constraintStructure, boneOMA, influenceIpo, dataRepository);
    }

    public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation) {
        BoneTrack boneTrack = this.getBoneTrack(skeleton, boneAnimation);
        if (boneTrack != null) {
            int flag = ((Number)this.data.getFieldValue("flag")).intValue();
            Vector3f[] translations = boneTrack.getTranslations();
            int maxFrames = translations.length;
            for (int frame = 0; frame < maxFrames; ++frame) {
                float zmax;
                float zmin;
                float ymax;
                float ymin;
                float xmax;
                float xmin;
                float influence = this.ipo.calculateValue(frame);
                if ((flag & 1) != 0 && translations[frame].x < (xmin = ((Number)this.data.getFieldValue("xmin")).floatValue())) {
                    translations[frame].x -= (translations[frame].x - xmin) * influence;
                }
                if ((flag & 2) != 0 && translations[frame].x > (xmax = ((Number)this.data.getFieldValue("xmax")).floatValue())) {
                    translations[frame].x -= (translations[frame].x - xmax) * influence;
                }
                if ((flag & 4) != 0 && translations[frame].y < (ymin = ((Number)this.data.getFieldValue("ymin")).floatValue())) {
                    translations[frame].y -= (translations[frame].y - ymin) * influence;
                }
                if ((flag & 8) != 0 && translations[frame].y > (ymax = ((Number)this.data.getFieldValue("ymax")).floatValue())) {
                    translations[frame].y -= (translations[frame].y - ymax) * influence;
                }
                if ((flag & 0x10) != 0 && translations[frame].z < (zmin = ((Number)this.data.getFieldValue("zmin")).floatValue())) {
                    translations[frame].z -= (translations[frame].z - zmin) * influence;
                }
                if ((flag & 0x20) == 0 || !(translations[frame].z > (zmax = ((Number)this.data.getFieldValue("zmax")).floatValue()))) continue;
                translations[frame].z -= (translations[frame].z - zmax) * influence;
            }
            boneTrack.setKeyframes(boneTrack.getTimes(), translations, boneTrack.getRotations(), boneTrack.getScales());
        }
    }

    public ConstraintType getType() {
        return ConstraintType.CONSTRAINT_TYPE_LOCLIMIT;
    }
}

