/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.shapes.EmitterMeshVertexShape;
import com.jme3.effect.shapes.EmitterShape;
import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.particles.ParticlesHelper;
import java.util.ArrayList;

class ParticlesModifier
extends Modifier {
    public ParticlesModifier(Structure modifier, DataRepository dataRepository) throws BlenderFileException {
        Pointer pParticleSystem = (Pointer)modifier.getFieldValue("psys");
        if (pParticleSystem.isNotNull()) {
            ParticlesHelper particlesHelper = (ParticlesHelper)dataRepository.getHelper(ParticlesHelper.class);
            Structure particleSystem = pParticleSystem.fetchData(dataRepository.getInputStream()).get(0);
            this.jmeModifierRepresentation = particlesHelper.toParticleEmitter(particleSystem, dataRepository);
        }
    }

    public Node apply(Node node, DataRepository dataRepository) {
        MaterialHelper materialHelper = (MaterialHelper)dataRepository.getHelper(MaterialHelper.class);
        ParticleEmitter emitter = (ParticleEmitter)this.jmeModifierRepresentation;
        emitter = emitter.clone();
        Integer alphaFunction = MaterialHelper.ALPHA_MASK_HYPERBOLE;
        char nameSuffix = emitter.getName().charAt(emitter.getName().length() - 1);
        if (nameSuffix == 'B' || nameSuffix == 'N') {
            alphaFunction = MaterialHelper.ALPHA_MASK_NONE;
        }
        emitter.setName(emitter.getName().substring(0, emitter.getName().length() - 1));
        EmitterShape emitterShape = emitter.getShape();
        ArrayList<Mesh> meshes = new ArrayList<Mesh>();
        for (Spatial spatial : node.getChildren()) {
            Mesh mesh;
            if (!(spatial instanceof Geometry) || (mesh = ((Geometry)spatial).getMesh()) == null) continue;
            meshes.add(mesh);
            Material material = materialHelper.getParticlesMaterial(((Geometry)spatial).getMaterial(), alphaFunction, dataRepository);
            emitter.setMaterial(material);
        }
        if (meshes.size() > 0 && emitterShape instanceof EmitterMeshVertexShape) {
            ((EmitterMeshVertexShape)emitterShape).setMeshes(meshes);
        }
        node.attachChild(emitter);
        return node;
    }

    public String getType() {
        return "ParticleSystemModifierData";
    }
}

