/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.terrain.heightmap.AbstractHeightMap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;

public class ImageBasedHeightMap
extends AbstractHeightMap {
    protected Image colorImage;
    protected float dampen = 1.0f;

    public ImageBasedHeightMap(Image colorImage) {
        this(colorImage, 1.0f);
    }

    public ImageBasedHeightMap(Image colorImage, float dampen) {
        this.colorImage = colorImage;
        this.dampen = dampen;
    }

    public boolean load() {
        return this.load(false, false);
    }

    protected float calculateHeight(float red, float green, float blue) {
        return (float)((0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue) * (double)this.dampen);
    }

    public boolean load(boolean flipX, boolean flipY) {
        int imageHeight;
        BufferedImage colorBufferedImage = ImageConverter.toBufferedImage(this.colorImage, 5);
        boolean hasAlpha = colorBufferedImage.getColorModel().hasAlpha();
        int imageWidth = colorBufferedImage.getWidth();
        if (imageWidth != (imageHeight = colorBufferedImage.getHeight())) {
            throw new RuntimeException("imageWidth: " + imageWidth + " != imageHeight: " + imageHeight);
        }
        this.size = imageWidth;
        byte[] data = (byte[])colorBufferedImage.getRaster().getDataElements(0, 0, imageWidth, imageHeight, null);
        int bytesPerPixel = 3;
        int blueBase = 0;
        if (hasAlpha) {
            bytesPerPixel = 4;
            blueBase = 1;
        }
        this.heightData = new float[imageWidth * imageHeight];
        int startW = 0;
        int endW = imageWidth - 1;
        if (flipX) {
            startW = imageWidth - 1;
            endW = 0;
        }
        int startH = imageHeight - 1;
        int endH = 0;
        if (flipY) {
            startH = 0;
            endH = imageHeight - 1;
        }
        int index = 0;
        if (flipY) {
            for (int h = 0; h < imageHeight; ++h) {
                float red;
                float green;
                float blue;
                int baseIndex;
                int w;
                if (flipX) {
                    for (w = imageWidth - 1; w >= 0; --w) {
                        baseIndex = h * imageWidth * bytesPerPixel + w * bytesPerPixel + blueBase;
                        blue = data[baseIndex] >= 0 ? (float)data[baseIndex] : (float)(256 + data[baseIndex]);
                        green = data[baseIndex + 1] >= 0 ? (float)data[baseIndex + 1] : (float)(256 + data[baseIndex + 1]);
                        red = data[baseIndex + 2] >= 0 ? (float)data[baseIndex + 2] : (float)(256 + data[baseIndex + 2]);
                        this.heightData[index++] = this.calculateHeight(red, green, blue);
                    }
                    continue;
                }
                for (w = 0; w < imageWidth; ++w) {
                    baseIndex = h * imageWidth * bytesPerPixel + w * bytesPerPixel + blueBase;
                    blue = data[baseIndex] >= 0 ? (float)data[baseIndex] : (float)(256 + data[baseIndex]);
                    green = data[baseIndex + 1] >= 0 ? (float)data[baseIndex + 1] : (float)(256 + data[baseIndex + 1]);
                    red = data[baseIndex + 2] >= 0 ? (float)data[baseIndex + 2] : (float)(256 + data[baseIndex + 2]);
                    this.heightData[index++] = this.calculateHeight(red, green, blue);
                }
            }
        } else {
            for (int h = imageHeight - 1; h >= 0; --h) {
                float red;
                float green;
                float blue;
                int baseIndex;
                int w;
                if (flipX) {
                    for (w = imageWidth - 1; w >= 0; --w) {
                        baseIndex = h * imageWidth * bytesPerPixel + w * bytesPerPixel + blueBase;
                        blue = data[baseIndex] >= 0 ? (float)data[baseIndex] : (float)(256 + data[baseIndex]);
                        green = data[baseIndex + 1] >= 0 ? (float)data[baseIndex + 1] : (float)(256 + data[baseIndex + 1]);
                        red = data[baseIndex + 2] >= 0 ? (float)data[baseIndex + 2] : (float)(256 + data[baseIndex + 2]);
                        this.heightData[index++] = this.calculateHeight(red, green, blue);
                    }
                    continue;
                }
                for (w = 0; w < imageWidth; ++w) {
                    baseIndex = h * imageWidth * bytesPerPixel + w * bytesPerPixel + blueBase;
                    blue = data[baseIndex] >= 0 ? (float)data[baseIndex] : (float)(256 + data[baseIndex]);
                    green = data[baseIndex + 1] >= 0 ? (float)data[baseIndex + 1] : (float)(256 + data[baseIndex + 1]);
                    red = data[baseIndex + 2] >= 0 ? (float)data[baseIndex + 2] : (float)(256 + data[baseIndex + 2]);
                    this.heightData[index++] = this.calculateHeight(red, green, blue);
                }
            }
        }
        return true;
    }

    protected static class ImageConverter {
        protected ImageConverter() {
        }

        public static BufferedImage toBufferedImage(Image image) {
            if (image instanceof BufferedImage) {
                return (BufferedImage)image;
            }
            ColorModel cm = ImageConverter.getColorModel(image);
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            return ImageConverter.copy(ImageConverter.createBufferedImage(cm, width, height), image);
        }

        public static BufferedImage toBufferedImage(Image image, int type) {
            if (image instanceof BufferedImage && ((BufferedImage)image).getType() == type) {
                return (BufferedImage)image;
            }
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            return ImageConverter.copy(new BufferedImage(width, height, type), image);
        }

        public static BufferedImage copy(BufferedImage target, Image source) {
            Graphics2D g = target.createGraphics();
            g.drawImage(source, 0, 0, null);
            g.dispose();
            return target;
        }

        public static ColorModel getColorModel(Image image) {
            try {
                PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
                pg.grabPixels();
                return pg.getColorModel();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unexpected interruption", e);
            }
        }

        public static BufferedImage createBufferedImage(ColorModel cm, int w, int h) {
            WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
            boolean isRasterPremultiplied = cm.isAlphaPremultiplied();
            return new BufferedImage(cm, raster, isRasterPremultiplied, null);
        }
    }
}

