/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import java.io.IOException;

public class TextureCubeMap
extends Texture {
    private Texture.WrapMode wrapS = Texture.WrapMode.EdgeClamp;
    private Texture.WrapMode wrapT = Texture.WrapMode.EdgeClamp;
    private Texture.WrapMode wrapR = Texture.WrapMode.EdgeClamp;

    public TextureCubeMap() {
    }

    public TextureCubeMap(Image img) {
        this.setImage(img);
    }

    public Texture createSimpleClone() {
        return this.createSimpleClone(new TextureCubeMap());
    }

    public Texture createSimpleClone(Texture rVal) {
        rVal.setWrap(Texture.WrapAxis.S, this.wrapS);
        rVal.setWrap(Texture.WrapAxis.T, this.wrapT);
        rVal.setWrap(Texture.WrapAxis.R, this.wrapR);
        return super.createSimpleClone(rVal);
    }

    public void setWrap(Texture.WrapAxis axis, Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        if (axis == null) {
            throw new IllegalArgumentException("axis can not be null.");
        }
        switch (axis) {
            case S: {
                this.wrapS = mode;
                break;
            }
            case T: {
                this.wrapT = mode;
                break;
            }
            case R: {
                this.wrapR = mode;
            }
        }
    }

    public void setWrap(Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        this.wrapS = mode;
        this.wrapT = mode;
        this.wrapR = mode;
    }

    public Texture.WrapMode getWrap(Texture.WrapAxis axis) {
        switch (axis) {
            case S: {
                return this.wrapS;
            }
            case T: {
                return this.wrapT;
            }
            case R: {
                return this.wrapR;
            }
        }
        throw new IllegalArgumentException("invalid WrapAxis: " + (Object)((Object)axis));
    }

    public Texture.Type getType() {
        return Texture.Type.CubeMap;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TextureCubeMap)) {
            return false;
        }
        TextureCubeMap that = (TextureCubeMap)other;
        if (this.getWrap(Texture.WrapAxis.S) != that.getWrap(Texture.WrapAxis.S)) {
            return false;
        }
        if (this.getWrap(Texture.WrapAxis.T) != that.getWrap(Texture.WrapAxis.T)) {
            return false;
        }
        if (this.getWrap(Texture.WrapAxis.R) != that.getWrap(Texture.WrapAxis.R)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 53 * hash + (this.wrapS != null ? this.wrapS.hashCode() : 0);
        hash = 53 * hash + (this.wrapT != null ? this.wrapT.hashCode() : 0);
        hash = 53 * hash + (this.wrapR != null ? this.wrapR.hashCode() : 0);
        return hash;
    }

    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.wrapS, "wrapS", Texture.WrapMode.EdgeClamp);
        capsule.write(this.wrapT, "wrapT", Texture.WrapMode.EdgeClamp);
        capsule.write(this.wrapR, "wrapR", Texture.WrapMode.EdgeClamp);
    }

    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule(this);
        this.wrapS = capsule.readEnum("wrapS", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
        this.wrapT = capsule.readEnum("wrapT", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
        this.wrapR = capsule.readEnum("wrapR", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
    }
}

