/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.android;

import java.util.Random;

public final class Fixed {
    public static final int FIXED_POINT = 16;
    public static final int ONE = 65536;
    public static final int HALF = 32768;
    public static final int QUARTER_CIRCLE = 64;
    public static final int FULL_CIRCLE_MASK = 255;
    private static final int TABLE_SHIFT = 30;
    private static final int SIN_PRECALC = 26350943;
    private static final int COS_PRECALC = 2146836866;
    private static final int[] SINE_TABLE;
    private static final int ATAN_SHIFT;
    private static final byte[] ATAN_TABLE;
    private static final int ATAN_TABLE_LEN;
    private static final int STRING_DECIMAL_PLACES = 2;
    private static final int STRING_DECIMAL_PLACES_ROUND;
    private static Random rng;

    private Fixed() {
    }

    public static int intToFixed(int n) {
        return n << 16;
    }

    public static float fixedToFloat(int i) {
        float fp = i;
        return fp /= 65536.0f;
    }

    public static int floatToFixed(float fp) {
        return (int)(fp * 65536.0f);
    }

    public static String toString(int n) {
        StringBuffer sb = new StringBuffer(16);
        sb.append((n += STRING_DECIMAL_PLACES_ROUND) >> 16);
        sb.append('.');
        n &= 0xFFFF;
        for (int i = 0; i < 2; ++i) {
            sb.append((n *= 10) / 65536 % 10);
        }
        return sb.toString();
    }

    public static int mul(int a, int b) {
        return (int)((long)a * (long)b >> 16);
    }

    public static int div(int a, int b) {
        return (int)(((long)a << 32) / (long)b >> 16);
    }

    public static int sin(int n) {
        if ((n &= 0xFF) < 128) {
            if (n < 64) {
                return SINE_TABLE[n];
            }
            return SINE_TABLE[128 - n];
        }
        if (n < 192) {
            return -SINE_TABLE[n - 128];
        }
        return -SINE_TABLE[256 - n];
    }

    public static int cos(int n) {
        if ((n &= 0xFF) < 128) {
            if (n < 64) {
                return SINE_TABLE[64 - n];
            }
            return -SINE_TABLE[n - 64];
        }
        if (n < 192) {
            return -SINE_TABLE[192 - n];
        }
        return SINE_TABLE[n - 192];
    }

    public static int tan(int n) {
        return Fixed.div(Fixed.sin(n), Fixed.cos(n));
    }

    public static int atan(int n) {
        if ((n = n + (1 << ATAN_SHIFT - 1) >> ATAN_SHIFT) < 0) {
            if (n <= -ATAN_TABLE_LEN) {
                return -63;
            }
            return -ATAN_TABLE[-n];
        }
        if (n >= ATAN_TABLE_LEN) {
            return 63;
        }
        return ATAN_TABLE[n];
    }

    public static int atan(int x, int y) {
        int n = Fixed.atan(Fixed.div(x, Fixed.abs(y) + 1));
        if (y > 0) {
            return n;
        }
        if (y < 0) {
            if (x < 0) {
                return -128 - n;
            }
            if (x > 0) {
                return 128 - n;
            }
            return 128;
        }
        if (x > 0) {
            return 64;
        }
        return -64;
    }

    public static int hyp(int x1, int y1, int x2, int y2) {
        if ((x2 -= x1) < 0) {
            x2 = -x2;
        }
        if ((y2 -= y1) < 0) {
            y2 = -y2;
        }
        return x2 + y2 - ((x2 > y2 ? y2 : x2) >> 1);
    }

    public static int sqrt(int n) {
        if (n <= 0) {
            return 0;
        }
        long sum = 0L;
        int bit = 0x40000000;
        while (bit >= 256) {
            long tmp = sum | (long)bit;
            if ((long)n >= tmp) {
                n = (int)((long)n - tmp);
                sum = tmp + (long)bit;
            }
            bit >>= 1;
            n <<= 1;
        }
        return (int)(sum >> 8);
    }

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static int sgn(int n) {
        return n < 0 ? -1 : 1;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static int clamp(int n, int min, int max) {
        return n < min ? min : (n > max ? max : n);
    }

    public static int wrap(int n, int limit) {
        return (n %= limit) < 0 ? limit + n : n;
    }

    public static int round(int n) {
        return n + 32768 >> 16;
    }

    public static int floor(int n) {
        return n >> 16;
    }

    public static int ceil(int n) {
        return n + 65535 >> 16;
    }

    public static int rand() {
        if (rng == null) {
            rng = new Random();
        }
        return rng.nextInt() >>> 16;
    }

    public static int rand(int n) {
        return Fixed.rand() * n >> 16;
    }

    static {
        int n;
        int rotl;
        int n2;
        SINE_TABLE = new int[65];
        Fixed.SINE_TABLE[0] = 0;
        Fixed.SINE_TABLE[1] = 26350943;
        for (n2 = 2; n2 < 65; ++n2) {
            Fixed.SINE_TABLE[n2] = (int)((long)SINE_TABLE[n2 - 1] * 2146836866L >> 30) - SINE_TABLE[n2 - 2];
        }
        for (n2 = 0; n2 < 65; ++n2) {
            Fixed.SINE_TABLE[n2] = SINE_TABLE[n2] + 8192 >> 14;
        }
        int tan0 = Fixed.tan(0);
        int tan1 = Fixed.tan(1);
        for (rotl = 0; rotl < 32 && (tan1 >>= 1) > (tan0 >>= 1); ++rotl) {
        }
        ATAN_SHIFT = rotl;
        int[] lut = new int[64];
        for (n = 0; n < 64; ++n) {
            lut[n] = Fixed.tan(n) >> rotl;
        }
        ATAN_TABLE_LEN = lut[63];
        ATAN_TABLE = new byte[ATAN_TABLE_LEN];
        for (n = 0; n < 63; n = (int)((byte)(n + 1))) {
            int min = lut[n];
            int max = lut[n + 1];
            for (int i = min; i < max; ++i) {
                Fixed.ATAN_TABLE[i] = n;
            }
        }
        int i = 10;
        for (int n3 = 1; n3 < 2; ++n3) {
            i *= i;
        }
        STRING_DECIMAL_PLACES_ROUND = 65536 / (2 * i);
        rng = null;
    }
}

