/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleCommandSplitter;

public class ConsoleExecuteCommandEvent
implements NiftyEvent {
    private Console console;
    private ConsoleCommandSplitter splitter = new ConsoleCommandSplitter();
    private String commandLine;
    private String command;
    private String[] arguments;

    public ConsoleExecuteCommandEvent(Console console, String commandLine) {
        this.console = console;
        if (commandLine == null || commandLine.length() == 0) {
            this.commandLine = "";
            this.command = "";
            this.arguments = new String[0];
        } else {
            this.commandLine = commandLine;
            this.processCommandLine(commandLine);
        }
    }

    public Console getConsole() {
        return this.console;
    }

    private void processCommandLine(String commandLine) {
        String[] splits = this.splitter.split(commandLine);
        this.command = splits[0];
        this.arguments = new String[splits.length - 1];
        for (int i = 1; i < splits.length; ++i) {
            this.arguments[i - 1] = splits[i];
        }
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public int getArgumentCount() {
        return this.arguments.length;
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.arguments;
    }
}

