/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.console.controller;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.console.controller.ConsoleCommandHandler;
import de.lessvoid.nifty.controls.dynamic.CustomControlCreator;
import de.lessvoid.nifty.controls.textfield.TextFieldCreator;
import de.lessvoid.nifty.controls.textfield.controller.TextFieldControl;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class ConsoleControl
implements Controller {
    private Nifty nifty;
    private Screen screen;
    private Element element;
    private int lines;
    private List<String> buffer = new ArrayList<String>();
    private static final int MAX_BUFFER_LINES = 100;
    private Collection<ConsoleCommandHandler> commandHandler = new ArrayList<ConsoleCommandHandler>();

    public void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties properties, ControllerEventListener newListener, Attributes controlDefinitionAttributes) {
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.element = newElement;
        this.lines = Integer.valueOf((String)properties.get("lines"));
        for (int i = 0; i < this.lines; ++i) {
            CustomControlCreator createConsoleLine = new CustomControlCreator("console-line-" + i, "console-line");
            createConsoleLine.create(this.nifty, this.screen, this.element);
        }
        TextFieldCreator createTextField = new TextFieldCreator("console-input");
        createTextField.setStyle("nifty-console-textfield");
        createTextField.setFocusable("false");
        createTextField.create(this.nifty, this.screen, this.element);
        this.screen.layoutLayers();
    }

    public void onStartScreen() {
    }

    public void onClick(int mouseX, int mouseY) {
    }

    public void onClickMouseMove(int mouseX, int mouseY) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        TextFieldControl textControl = (TextFieldControl)this.element.findElementByName("console-input").getControl(TextFieldControl.class);
        if (textControl.inputEvent(inputEvent)) {
            return true;
        }
        if (inputEvent == NiftyInputEvent.SubmitText) {
            String commandLine = textControl.getText();
            this.output(commandLine);
            textControl.setText("");
            this.element.setFocus();
            this.notifyCommandHandler(commandLine);
            return true;
        }
        return false;
    }

    private void notifyCommandHandler(String commandLine) {
        for (ConsoleCommandHandler handler : this.commandHandler) {
            handler.execute(commandLine);
        }
    }

    public void onFocus(boolean getFocus) {
        TextFieldControl control = (TextFieldControl)this.element.findControl("console-input", TextFieldControl.class);
        if (control != null) {
            control.onFocus(getFocus);
        }
    }

    public void output(String line) {
        if (line != null && line.length() > 0) {
            if (line.contains("\n")) {
                String[] splitLines;
                for (String l : splitLines = line.split("\n")) {
                    this.outputLine(l);
                }
            } else {
                this.outputLine(line);
            }
            this.showLines();
        }
    }

    private void outputLine(String line) {
        this.buffer.add(line);
        if (this.buffer.size() > 100) {
            this.buffer.remove(0);
        }
    }

    private void showLines() {
        if (this.buffer.isEmpty()) {
            return;
        }
        int lastLineIdx = this.buffer.size() - 1;
        for (int i = this.lines - 1; i >= 0; --i) {
            if (lastLineIdx < 0) continue;
            String line = this.buffer.get(lastLineIdx);
            Element el = this.element.findElementByName("console-line-" + i);
            if (el != null) {
                ((TextRenderer)el.getRenderer(TextRenderer.class)).changeText(line);
            }
            --lastLineIdx;
        }
    }

    public void addCommandHandler(ConsoleCommandHandler consoleCommandHandler) {
        this.commandHandler.add(consoleCommandHandler);
    }
}

