/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox.controller;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.listbox.controller.ListBoxControl;
import de.lessvoid.nifty.controls.listbox.controller.ListBoxItemController;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ListBoxPanel
implements Controller {
    private Screen screen;
    private Element element;
    private FocusHandler focusHandler;
    private int selectedItem;

    public void bind(Nifty niftyParam, Screen screenParam, Element elementParam, Properties parameter, ControllerEventListener listener, Attributes controlDefinitionAttributes) {
        this.screen = screenParam;
        this.element = elementParam;
        this.selectedItem = -1;
    }

    public void onStartScreen() {
        this.focusHandler = this.screen.getFocusHandler();
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyInputEvent.NextInputElement) {
            if (this.focusHandler != null) {
                Element nextElement = this.focusHandler.getNext(this.element);
                nextElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.PrevInputElement) {
            if (this.focusHandler != null) {
                Element prevElement = this.focusHandler.getPrev(this.element);
                prevElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.MoveCursorDown) {
            if (this.hasElements() && this.selectedItem < this.getElementCount() - 1) {
                this.changeSelection(this.selectedItem + 1);
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.MoveCursorUp && this.hasElements() && this.selectedItem > 0) {
            this.changeSelection(this.selectedItem - 1);
            return true;
        }
        return false;
    }

    public void onFocus(boolean getFocus) {
    }

    public void changeSelection(int newSelectedItemIndex) {
        this.updateSelection(newSelectedItemIndex);
    }

    public void changeSelection(Element element) {
        this.changeSelection(this.getListBoxElements().indexOf(element));
    }

    public int getSelectedItemIndex() {
        return this.selectedItem;
    }

    public Element getSelectedElement() {
        return this.getListBoxElements().get(this.selectedItem);
    }

    public int getElementCount() {
        if (this.element != null) {
            return this.getListBoxElements().size();
        }
        return 0;
    }

    public boolean hasElements() {
        return this.getElementCount() > 0;
    }

    public void linkChildsToListBoxControl(ListBoxControl listBoxControl) {
        if (!this.hasElements()) {
            return;
        }
        List<Element> elements = this.getListBoxElements();
        for (Element e : elements) {
            ListBoxItemController listBoxItem = (ListBoxItemController)e.getControl(ListBoxItemController.class);
            if (listBoxItem == null) continue;
            listBoxItem.setListBox(listBoxControl);
        }
    }

    private Element getScrollElement() {
        if (this.element != null) {
            return (Element)this.element.getElements().get(0);
        }
        return null;
    }

    private void updateSelection(int newSelectedItemIndex) {
        if (newSelectedItemIndex == -1) {
            if (this.selectedItem != -1) {
                this.deselect(this.selectedItem);
            }
        } else {
            if (this.selectedItem != -1) {
                this.deselect(this.selectedItem);
            }
            if (newSelectedItemIndex != -1) {
                this.select(newSelectedItemIndex);
            }
            this.selectedItem = newSelectedItemIndex;
        }
    }

    private void select(int newSelectedItemIndex) {
        Element scrollElement = this.getScrollElement();
        if (scrollElement != null) {
            ((Element)scrollElement.getElements().get(newSelectedItemIndex)).startEffect(EffectEventId.onCustom, null);
        }
    }

    private void deselect(int newSelectedItemIndex) {
        Element scrollElement = this.getScrollElement();
        if (scrollElement != null) {
            ((Element)scrollElement.getElements().get(newSelectedItemIndex)).stopEffect(EffectEventId.onCustom);
        }
    }

    private int getListBoxElementsCount() {
        return this.getListBoxElements().size();
    }

    public List<Element> getListBoxElements() {
        if (this.element.getElements().isEmpty()) {
            return new ArrayList<Element>();
        }
        if (((Element)this.element.getElements().get(0)).getElements().isEmpty()) {
            return new ArrayList<Element>();
        }
        return ((Element)this.element.getElements().get(0)).getElements();
    }
}

