/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.scrollpanel;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.scrollbar.controller.HorizontalScrollbarControl;
import de.lessvoid.nifty.controls.scrollbar.controller.ScrollbarControlNotify;
import de.lessvoid.nifty.controls.scrollbar.controller.VerticalScrollbarControl;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class ScrollPanel
implements Controller {
    private Nifty nifty;
    private Screen screen;
    private Element element;
    private boolean verticalScrollbar;
    private boolean horizontalScrollbar;
    private String childRootId;
    private Element childRootElement;
    private float stepSizeX;
    private float stepSizeY;
    private HorizontalScrollbarControl horizontalS;
    private VerticalScrollbarControl verticalS;

    public void bind(Nifty niftyParam, Screen screenParam, Element elementParam, Properties parameter, ControllerEventListener listener, Attributes controlDefinitionAttributes) {
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.element = elementParam;
        this.verticalScrollbar = new Boolean(parameter.getProperty("vertical", "true"));
        this.horizontalScrollbar = new Boolean(parameter.getProperty("horizontal", "true"));
        this.childRootId = controlDefinitionAttributes.get("childRootId");
        this.childRootElement = this.element.findElementByName(this.childRootId);
        this.stepSizeX = new Float(parameter.getProperty("stepSizeX", "1.0")).floatValue();
        this.stepSizeY = new Float(parameter.getProperty("stepSizeY", "1.0")).floatValue();
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void onFocus(boolean getFocus) {
    }

    public void onStartScreen() {
        this.initializeScrollPanel(this.screen, this.stepSizeX, this.stepSizeY);
    }

    public void initializeScrollPanel(Screen screen, float stepSizeX, float stepSizeY) {
        Element scrollElement;
        Element horizontal;
        Element vertical;
        this.stepSizeX = stepSizeX;
        this.stepSizeY = stepSizeY;
        if (!this.verticalScrollbar && (vertical = this.element.findElementByName("nifty-internal-vertical-scrollbar")) != null) {
            this.nifty.removeElement(screen, vertical);
        }
        if (!this.horizontalScrollbar && (horizontal = this.element.findElementByName("nifty-internal-horizonal-panel")) != null) {
            this.nifty.removeElement(screen, horizontal);
        }
        this.nifty.executeEndOfFrameElementActions();
        screen.layoutLayers();
        if (this.childRootElement != null && (scrollElement = (Element)this.childRootElement.getElements().get(0)) != null) {
            this.horizontalS = (HorizontalScrollbarControl)this.element.findControl("nifty-internal-horizontal-scrollbar", HorizontalScrollbarControl.class);
            if (this.horizontalS != null) {
                this.horizontalS.setWorldMaxValue(scrollElement.getWidth());
                this.horizontalS.setViewMaxValue(this.childRootElement.getWidth());
                this.horizontalS.setPerClickChange(stepSizeX);
                this.horizontalS.setCurrentValue(0.0f);
                this.horizontalS.setScrollBarControlNotify(new ScrollbarControlNotify(){

                    @Override
                    public void positionChanged(float currentValue) {
                        scrollElement.setConstraintX(new SizeValue(-((int)currentValue) + "px"));
                        scrollElement.getParent().layoutElements();
                    }
                });
            }
            this.verticalS = (VerticalScrollbarControl)this.element.findControl("nifty-internal-vertical-scrollbar", VerticalScrollbarControl.class);
            if (this.verticalS != null) {
                this.verticalS.setWorldMaxValue(scrollElement.getHeight());
                this.verticalS.setViewMaxValue(this.childRootElement.getHeight());
                this.verticalS.setPerClickChange(stepSizeY);
                this.verticalS.setCurrentValue(0.0f);
                this.verticalS.setScrollBarControlNotify(new ScrollbarControlNotify(){

                    @Override
                    public void positionChanged(float currentValue) {
                        scrollElement.setConstraintY(new SizeValue(-((int)currentValue) + "px"));
                        scrollElement.getParent().layoutElements();
                    }
                });
            }
            scrollElement.setConstraintX(new SizeValue("0px"));
            scrollElement.setConstraintY(new SizeValue("0px"));
        }
        screen.layoutLayers();
    }

    public void setVerticalPos(float yPos) {
        if (this.verticalS != null && this.verticalScrollbar) {
            this.verticalS.setCurrentValue(yPos);
        }
        System.out.println("set vpos to " + yPos);
    }

    public void showElementVertical(int elemCount) {
        this.showElementVertical(elemCount, VerticalAlign.center);
    }

    public void showElementVertical(int elemCount, VerticalAlign valign) {
        float newPos;
        switch (valign) {
            case top: {
                newPos = this.stepSizeY * (float)elemCount;
                break;
            }
            case center: {
                newPos = this.stepSizeY * (float)elemCount - (float)(this.element.getHeight() / 2);
                break;
            }
            case bottom: {
                newPos = this.stepSizeY * (float)elemCount - (float)this.element.getHeight();
                break;
            }
            default: {
                newPos = 0.0f;
            }
        }
        this.setVerticalPos(newPos);
    }

    public static enum VerticalAlign {
        top,
        center,
        bottom;

    }
}

