/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.textfield.controller;

import de.lessvoid.nifty.controls.textfield.controller.Clipboard;

public class TextField {
    private StringBuffer text;
    private int cursorPosition;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private boolean selecting;
    private int selectionStartIndex;
    private Clipboard clipboard;
    private int maxLength = -1;

    public TextField(String newText, Clipboard newClipboard) {
        this.initWithText(newText);
        this.clipboard = newClipboard;
        this.maxLength = -1;
    }

    public void initWithText(String newText) {
        this.text = new StringBuffer();
        if (newText != null) {
            this.text.append(newText);
        }
        this.cursorPosition = 0;
        this.selectionStart = -1;
        this.selectionEnd = -1;
        this.selecting = false;
        this.selectionStartIndex = -1;
    }

    public String getText() {
        return this.text.toString();
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void cursorLeft() {
        --this.cursorPosition;
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.selecting) {
            this.selectionFromCursorPosition();
        } else {
            this.resetSelection();
        }
    }

    public void cursorRight() {
        ++this.cursorPosition;
        if (this.cursorPosition > this.text.length()) {
            this.cursorPosition = this.text.length();
        }
        if (this.selecting) {
            this.selectionFromCursorPosition();
        } else {
            this.resetSelection();
        }
    }

    private void selectionFromCursorPosition() {
        if (this.cursorPosition > this.selectionStartIndex) {
            this.selectionStart = this.selectionStartIndex;
            this.selectionEnd = this.cursorPosition;
        } else if (this.cursorPosition == this.selectionStartIndex) {
            this.resetSelection();
        } else {
            this.selectionStart = this.cursorPosition;
            this.selectionEnd = this.selectionStartIndex;
        }
    }

    public void delete() {
        if (this.hasSelection()) {
            this.text.delete(this.selectionStart, this.selectionEnd);
            this.cursorPosition = this.selectionStart;
            this.resetSelection();
        } else {
            this.text.delete(this.cursorPosition, this.cursorPosition + 1);
        }
    }

    public boolean hasSelection() {
        return this.selectionStart != -1 && this.selectionEnd != -1;
    }

    public void toFirstPosition() {
        this.cursorPosition = 0;
        if (this.selecting) {
            this.selectionFromCursorPosition();
        } else if (this.hasSelection()) {
            this.resetSelection();
        }
    }

    public void toLastPosition() {
        this.cursorPosition = this.text.length();
        if (this.selecting) {
            this.selectionFromCursorPosition();
        } else if (this.hasSelection()) {
            this.resetSelection();
        }
    }

    public void backspace() {
        if (this.hasSelection()) {
            this.text.delete(this.selectionStart, this.selectionEnd);
            this.cursorPosition = this.selectionStart;
            this.resetSelection();
        } else if (this.cursorPosition > 0) {
            this.text.delete(this.cursorPosition - 1, this.cursorPosition);
            --this.cursorPosition;
        }
    }

    public void resetSelection() {
        this.selectionStart = -1;
        this.selectionEnd = -1;
        this.selecting = false;
    }

    public void insert(char c) {
        if (this.hasSelection()) {
            this.text.delete(this.selectionStart, this.selectionEnd);
            this.cursorPosition = this.selectionStart;
            this.resetSelection();
        }
        if (this.maxLength == -1 || this.text.length() < this.maxLength) {
            this.text.insert(this.cursorPosition, c);
            ++this.cursorPosition;
        }
    }

    public void setCursorPosition(int newIndex) {
        this.cursorPosition = newIndex < 0 ? 0 : (newIndex > this.text.length() ? this.text.length() : newIndex);
        if (this.selecting) {
            this.selectionFromCursorPosition();
        }
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void startSelecting() {
        this.selecting = true;
        this.selectionStartIndex = this.cursorPosition;
    }

    public void endSelecting() {
        this.selecting = false;
    }

    public String getSelectedText() {
        if (!this.hasSelection()) {
            return null;
        }
        return this.text.substring(this.selectionStart, this.selectionEnd);
    }

    public void cut(Character passwordChar) {
        String selectedText = this.getSelectedText();
        this.clipboard.put(this.modifyWithPasswordChar(selectedText, passwordChar));
        this.delete();
    }

    public void copy(Character passwordChar) {
        String selectedText = this.modifyWithPasswordChar(this.getSelectedText(), passwordChar);
        if (selectedText != null) {
            this.clipboard.put(selectedText);
        }
    }

    String modifyWithPasswordChar(String selectedText, Character passwordChar) {
        if (passwordChar == null) {
            return selectedText;
        }
        if (selectedText == null) {
            return null;
        }
        String result = selectedText;
        return result.replaceAll(".", new String(new char[]{passwordChar.charValue()}));
    }

    public void put() {
        String clipboardText = this.clipboard.get();
        if (clipboardText != null) {
            for (int i = 0; i < clipboardText.length(); ++i) {
                this.insert(clipboardText.charAt(i));
            }
        }
    }

    public void setMaxLength(int maxLen) {
        this.maxLength = maxLen;
        if (this.maxLength != -1 && this.text.length() > maxLen) {
            this.text = this.text.delete(maxLen, this.text.length());
            this.resetSelection();
        }
    }
}

