/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.textfield.controller;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.textfield.controller.ClipboardAWT;
import de.lessvoid.nifty.controls.textfield.controller.TextField;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.elements.tools.FontHelper;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class TextFieldControl
implements Controller {
    private static final int CURSOR_Y = 0;
    private Screen screen;
    private Element element;
    private Element textElement;
    private Element fieldElement;
    private Element cursorElement;
    private TextField textField;
    private int firstVisibleCharacterIndex;
    private int lastVisibleCharacterIndex;
    private int fieldWidth;
    private int fromClickCursorPos;
    private int toClickCursorPos;
    private FocusHandler focusHandler;
    private Character passwordChar;

    public void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties properties, ControllerEventListener newListener, Attributes controlDefinitionAttributes) {
        this.element = newElement;
        this.screen = screenParam;
        this.fromClickCursorPos = -1;
        this.toClickCursorPos = -1;
        this.textField = new TextField("", new ClipboardAWT());
        this.textField.toFirstPosition();
        this.textElement = this.element.findElementByName("textfield-text");
        this.fieldElement = this.element.findElementByName("textfield-field");
        this.cursorElement = this.element.findElementByName("textfield-cursor");
        this.passwordChar = null;
        if (properties.containsKey("passwordChar")) {
            this.passwordChar = Character.valueOf(properties.get("passwordChar").toString().charAt(0));
        }
        if (properties.containsKey("maxLength")) {
            this.setMaxLength(new Integer(properties.getProperty("maxLength")));
        }
    }

    public void onStartScreen() {
        this.focusHandler = this.screen.getFocusHandler();
        this.textField.initWithText(((TextRenderer)this.textElement.getRenderer(TextRenderer.class)).getOriginalText());
        this.fieldWidth = this.fieldElement.getWidth() - this.cursorElement.getWidth();
        TextRenderer textRenderer = (TextRenderer)this.textElement.getRenderer(TextRenderer.class);
        this.firstVisibleCharacterIndex = 0;
        this.lastVisibleCharacterIndex = FontHelper.getVisibleCharactersFromStart((RenderFont)textRenderer.getFont(), (String)this.textField.getText(), (int)this.fieldWidth, (float)1.0f);
        this.cursorElement.hide();
        this.updateCursor();
    }

    public void onClick(int mouseX, int mouseY) {
        String visibleString = this.textField.getText().substring(this.firstVisibleCharacterIndex, this.lastVisibleCharacterIndex);
        int indexFromPixel = this.getCursorPosFromMouse(mouseX, visibleString);
        if (indexFromPixel != -1) {
            this.fromClickCursorPos = this.firstVisibleCharacterIndex + indexFromPixel;
        }
        this.textField.resetSelection();
        this.textField.setCursorPosition(this.fromClickCursorPos);
        this.updateCursor();
    }

    public void onClickMouseMove(int mouseX, int mouseY) {
        String visibleString = this.textField.getText().substring(this.firstVisibleCharacterIndex, this.lastVisibleCharacterIndex);
        int indexFromPixel = this.getCursorPosFromMouse(mouseX, visibleString);
        if (indexFromPixel != -1) {
            this.toClickCursorPos = this.firstVisibleCharacterIndex + indexFromPixel;
        }
        this.textField.setCursorPosition(this.fromClickCursorPos);
        this.textField.startSelecting();
        this.textField.setCursorPosition(this.toClickCursorPos);
        this.textField.endSelecting();
        this.updateCursor();
    }

    private int getCursorPosFromMouse(int mouseX, String visibleString) {
        TextRenderer textRenderer = (TextRenderer)this.textElement.getRenderer(TextRenderer.class);
        return FontHelper.getCharacterIndexFromPixelPosition((RenderFont)textRenderer.getFont(), (String)visibleString, (int)(mouseX - this.fieldElement.getX()), (float)1.0f);
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyInputEvent.MoveCursorLeft) {
            this.textField.cursorLeft();
            this.updateCursor();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorRight) {
            this.textField.cursorRight();
            this.updateCursor();
            return true;
        }
        if (inputEvent == NiftyInputEvent.Delete) {
            this.textField.delete();
            this.updateCursor();
            return true;
        }
        if (inputEvent == NiftyInputEvent.Backspace) {
            this.textField.backspace();
            this.updateCursor();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorToLastPosition) {
            this.textField.toLastPosition();
            this.updateCursor();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorToFirstPosition) {
            this.textField.toFirstPosition();
            this.updateCursor();
            return true;
        }
        if (inputEvent == NiftyInputEvent.SelectionStart) {
            this.textField.startSelecting();
            this.updateCursor();
            return true;
        }
        if (inputEvent == NiftyInputEvent.SelectionEnd) {
            this.textField.endSelecting();
            this.updateCursor();
            return true;
        }
        if (inputEvent == NiftyInputEvent.Cut) {
            this.textField.cut(this.passwordChar);
            this.updateCursor();
            return true;
        }
        if (inputEvent == NiftyInputEvent.Copy) {
            this.textField.copy(this.passwordChar);
            this.updateCursor();
            return true;
        }
        if (inputEvent == NiftyInputEvent.Paste) {
            this.textField.put();
            this.updateCursor();
            return true;
        }
        if (inputEvent != NiftyInputEvent.SubmitText) {
            if (inputEvent == NiftyInputEvent.Character) {
                this.textField.insert(inputEvent.getCharacter());
                this.updateCursor();
                return true;
            }
            if (inputEvent == NiftyInputEvent.NextInputElement) {
                if (this.focusHandler != null) {
                    this.focusHandler.getNext(this.fieldElement).setFocus();
                    this.updateCursor();
                    return true;
                }
            } else if (inputEvent == NiftyInputEvent.PrevInputElement) {
                this.textField.endSelecting();
                if (this.focusHandler != null) {
                    this.focusHandler.getPrev(this.fieldElement).setFocus();
                    this.updateCursor();
                    return true;
                }
            }
        }
        this.updateCursor();
        return false;
    }

    private void updateCursor() {
        TextRenderer textRenderer = (TextRenderer)this.textElement.getRenderer(TextRenderer.class);
        String text = this.textField.getText();
        this.checkBounds(text, textRenderer);
        this.calcLastVisibleIndex(textRenderer);
        if (this.isPassword(this.passwordChar)) {
            int numChar = text.length();
            char[] chars = new char[numChar];
            for (int i = 0; i < numChar; ++i) {
                chars[i] = this.passwordChar.charValue();
            }
            text = new String(chars);
        }
        textRenderer.changeText(text);
        textRenderer.setSelection(this.textField.getSelectionStart(), this.textField.getSelectionEnd());
        int cursorPos = this.textField.getCursorPosition();
        this.calcFirstVisibleIndex(cursorPos);
        this.calcLastVisibleIndex(textRenderer);
        String substring2 = text.substring(0, this.firstVisibleCharacterIndex);
        int d = textRenderer.getFont().getWidth(substring2);
        textRenderer.setXoffsetHack(-d);
        String substring = text.substring(0, cursorPos);
        int textWidth = textRenderer.getFont().getWidth(substring);
        int cursorPixelPos = textWidth - d;
        this.cursorElement.setConstraintX(new SizeValue(cursorPixelPos + "px"));
        this.cursorElement.setConstraintY(new SizeValue((this.element.getHeight() - this.cursorElement.getHeight()) / 2 + 0 + "px"));
        this.cursorElement.startEffect(EffectEventId.onActive, null);
        if (this.screen != null) {
            this.screen.layoutLayers();
        }
    }

    private boolean isPassword(Character currentPasswordChar) {
        return currentPasswordChar != null;
    }

    private void calcFirstVisibleIndex(int cursorPos) {
        if (cursorPos > this.lastVisibleCharacterIndex) {
            int cursorPosDelta = cursorPos - this.lastVisibleCharacterIndex;
            this.firstVisibleCharacterIndex += cursorPosDelta;
        } else if (cursorPos < this.firstVisibleCharacterIndex) {
            int cursorPosDelta = this.firstVisibleCharacterIndex - cursorPos;
            this.firstVisibleCharacterIndex -= cursorPosDelta;
        }
    }

    private void checkBounds(String text, TextRenderer textRenderer) {
        int textLen = text.length();
        if (this.firstVisibleCharacterIndex > textLen) {
            this.lastVisibleCharacterIndex = textLen;
            this.firstVisibleCharacterIndex = FontHelper.getVisibleCharactersFromEnd((RenderFont)textRenderer.getFont(), (String)text, (int)this.fieldWidth, (float)1.0f);
        }
    }

    private void calcLastVisibleIndex(TextRenderer textRenderer) {
        String currentText = this.textField.getText();
        if (this.firstVisibleCharacterIndex < currentText.length()) {
            String textToCheck = currentText.substring(this.firstVisibleCharacterIndex);
            int lengthFitting = FontHelper.getVisibleCharactersFromStart((RenderFont)textRenderer.getFont(), (String)textToCheck, (int)this.fieldWidth, (float)1.0f);
            this.lastVisibleCharacterIndex = lengthFitting + this.firstVisibleCharacterIndex;
        } else {
            this.lastVisibleCharacterIndex = this.firstVisibleCharacterIndex;
        }
    }

    public void onFocus(boolean getFocus) {
        if (this.cursorElement != null) {
            if (getFocus) {
                this.cursorElement.show();
            } else {
                this.cursorElement.hide();
            }
            this.updateCursor();
        }
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String newText) {
        this.textField.initWithText(newText);
        this.updateCursor();
    }

    public void setMaxLength(int maxLength) {
        this.textField.setMaxLength(maxLength);
    }

    public void setCursorPosition(int position) {
        this.textField.setCursorPosition(position);
        this.updateCursor();
    }
}

