/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dropdown;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.dropdown.DropDownControl;
import de.lessvoid.nifty.controls.dropdown.DropDownListBoxSelectionChangedEventSubscriber;
import de.lessvoid.nifty.controls.listbox.ListBoxControl;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.impl.Move;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.List;
import java.util.Properties;
import org.bushe.swing.event.EventTopicSubscriber;

public class DropDownPopup<T>
extends AbstractController {
    private Nifty nifty;
    private Screen screen;
    private DropDownControl<T> dropDownControl;
    private Element popupInstance;

    public void bind(Nifty niftyParam, Screen screenParam, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        super.bind(element);
        this.nifty = niftyParam;
        this.screen = screenParam;
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void setDropDownElement(DropDownControl<T> dropDownControl, Element popupInstance) {
        this.dropDownControl = dropDownControl;
        this.popupInstance = popupInstance;
        this.linkPopupToDropDownPosition(dropDownControl);
    }

    public void onStartScreen() {
        ListBox listBox = (ListBox)this.getElement().findNiftyControl("#listBox", ListBoxControl.class);
        this.nifty.subscribe(this.screen, listBox.getId(), ListBoxSelectionChangedEvent.class, (EventTopicSubscriber)new DropDownListBoxSelectionChangedEventSubscriber(this.nifty, this.screen, listBox, this.dropDownControl, this.popupInstance));
        this.linkPopupToDropDownPosition(this.dropDownControl);
        this.dropDownControl.refresh();
    }

    private void linkPopupToDropDownPosition(DropDownControl<T> dropDownControl) {
        Element panel = this.getElement().findElementByName("#panel");
        panel.setConstraintX(new SizeValue(dropDownControl.getElement().getX() + "px"));
        panel.setConstraintWidth(new SizeValue(dropDownControl.getWidth() + "px"));
        this.getElement().layoutElements();
        ListBoxControl listBox = (ListBoxControl)this.getElement().findNiftyControl("#listBox", ListBoxControl.class);
        listBox.ensureWidthConstraints();
        panel.setConstraintHeight(new SizeValue(listBox.getHeight() + "px"));
        if (dropDownControl.getElement().getY() + listBox.getHeight() > this.nifty.getRenderEngine().getHeight()) {
            panel.setConstraintY(new SizeValue(dropDownControl.getElement().getY() - listBox.getHeight() + "px"));
            this.updateMoveEffect(listBox, 1);
        } else {
            panel.setConstraintY(new SizeValue(dropDownControl.getElement().getY() + dropDownControl.getHeight() + "px"));
            this.updateMoveEffect(listBox, -1);
        }
        this.getElement().layoutElements();
    }

    private void updateMoveEffect(ListBoxControl listBox, int direction) {
        List moveEffects = this.getElement().findElementByName("#panel").getEffects(EffectEventId.onStartScreen, Move.class);
        if (moveEffects != null && !moveEffects.isEmpty()) {
            ((Effect)moveEffects.get(0)).getParameters().setProperty("offsetY", String.valueOf(direction * listBox.getHeight()));
            ((Effect)moveEffects.get(0)).getParameters().setProperty("mode", "fromOffset");
        }
        if ((moveEffects = this.getElement().findElementByName("#panel").getEffects(EffectEventId.onEndScreen, Move.class)) != null && !moveEffects.isEmpty()) {
            ((Effect)moveEffects.get(0)).getParameters().setProperty("offsetY", String.valueOf(direction * listBox.getHeight()));
            ((Effect)moveEffects.get(0)).getParameters().setProperty("mode", "toOffset");
        }
    }

    public void close() {
        this.dropDownControl.close();
    }
}

