/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools.pulsate.provider;

import de.lessvoid.nifty.tools.pulsate.PulsatorProvider;
import java.util.Properties;

public class SinusRaisedPulsator
implements PulsatorProvider {
    private static final float HALF = 0.5f;
    private float period;
    private long startTime;
    private boolean cycle = true;

    @Override
    public void initialize(Properties parameter) {
        this.period = Float.parseFloat(parameter.getProperty("period", "1000"));
        this.cycle = Boolean.parseBoolean(parameter.getProperty("cycle", "true"));
    }

    @Override
    public float getValue(long msTime) {
        long t = msTime - this.startTime;
        if (this.cycle) {
            return this.getSinusValue(t);
        }
        if ((float)t > this.period * 0.5f) {
            return 1.0f;
        }
        return this.getSinusValue(t);
    }

    private float getSinusValue(long x) {
        return (float)((Math.sin(Math.PI * (double)x / (double)this.period - 1.5707963267948966) + 1.0) / 2.0);
    }

    @Override
    public void reset(long msTime) {
        this.startTime = msTime;
    }
}

