/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ToolkitLock;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NullToolkitLock;

public class NativeWindowFactoryImpl
extends NativeWindowFactory {
    protected static final boolean DEBUG = Debug.debug("NativeWindow");
    private static final ToolkitLock nullToolkitLock = new NullToolkitLock();
    private Constructor nativeWindowConstructor = null;

    public static ToolkitLock getNullToolkitLock() {
        return nullToolkitLock;
    }

    @Override
    protected NativeWindow getNativeWindowImpl(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) throws IllegalArgumentException {
        if (null == object) {
            throw new IllegalArgumentException("winObj is null");
        }
        if (object instanceof NativeWindow) {
            return (NativeWindow)object;
        }
        if (null == abstractGraphicsConfiguration) {
            throw new IllegalArgumentException("AbstractGraphicsConfiguration is null with a non NativeWindow object");
        }
        if (NativeWindowFactory.isAWTAvailable() && ReflectionUtil.instanceOf((Object)object, (String)"java.awt.Component")) {
            return this.getAWTNativeWindow(object, abstractGraphicsConfiguration);
        }
        throw new IllegalArgumentException("Target window object type " + object.getClass().getName() + " is unsupported; expected " + "javax.media.nativewindow.NativeWindow or " + "java.awt.Component");
    }

    private NativeWindow getAWTNativeWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        if (this.nativeWindowConstructor == null) {
            try {
                String string = NativeWindowFactoryImpl.getNativeWindowType(true);
                String string2 = null;
                if (string.equals("Windows")) {
                    string2 = "jogamp.nativewindow.jawt.windows.WindowsJAWTWindow";
                } else if (string.equals("MacOSX")) {
                    string2 = "jogamp.nativewindow.jawt.macosx.MacOSXJAWTWindow";
                } else if (string.equals("X11")) {
                    string2 = "jogamp.nativewindow.jawt.x11.X11JAWTWindow";
                } else {
                    throw new IllegalArgumentException("OS " + NativeWindowFactoryImpl.getNativeOSName(false) + " not yet supported");
                }
                this.nativeWindowConstructor = ReflectionUtil.getConstructor((String)string2, (Class[])new Class[]{Object.class, AbstractGraphicsConfiguration.class}, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (Exception exception) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(exception);
            }
        }
        try {
            return (NativeWindow)this.nativeWindowConstructor.newInstance(object, abstractGraphicsConfiguration);
        }
        catch (Exception exception) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(exception);
        }
    }
}

