/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.helpers.v249;

import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.utils.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LightHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(LightHelper.class.getName());

    public LightHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public Light toLight(Structure structure, DataRepository dataRepository) throws BlenderFileException {
        Light result = (Light)dataRepository.getLoadedFeature(structure.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (result != null) {
            return result;
        }
        int type = ((Number)structure.getFieldValue("type")).intValue();
        switch (type) {
            case 0: {
                result = new PointLight();
                float distance = ((Number)structure.getFieldValue("dist")).floatValue();
                ((PointLight)result).setRadius(distance);
                break;
            }
            case 1: {
                LOGGER.log(Level.WARNING, "'Sun' lamp is not supported in jMonkeyEngine.");
                break;
            }
            case 2: {
                LOGGER.log(Level.WARNING, "'Spot' lamp is not supported in jMonkeyEngine.");
                break;
            }
            case 3: {
                LOGGER.log(Level.WARNING, "'Hemi' lamp is not supported in jMonkeyEngine.");
                break;
            }
            case 4: {
                result = new DirectionalLight();
                break;
            }
            default: {
                throw new BlenderFileException("Unknown light source type: " + type);
            }
        }
        if (result != null) {
            float r = ((Number)structure.getFieldValue("r")).floatValue();
            float g = ((Number)structure.getFieldValue("g")).floatValue();
            float b = ((Number)structure.getFieldValue("b")).floatValue();
            result.setColor(new ColorRGBA(r, g, b, 0.0f));
        }
        return result;
    }
}

