/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.helpers.v249;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.data.FileBlockHeader;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.helpers.v249.NoiseHelper;
import com.jme3.scene.plugins.blender.utils.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.utils.BlenderInputStream;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.Pointer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.texture.plugins.DDSLoader;
import com.jme3.texture.plugins.TGALoader;
import com.jme3.util.BufferUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextureHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(TextureHelper.class.getName());
    public static final int TEX_NONE = 0;
    public static final int TEX_CLOUDS = 1;
    public static final int TEX_WOOD = 2;
    public static final int TEX_MARBLE = 3;
    public static final int TEX_MAGIC = 4;
    public static final int TEX_BLEND = 5;
    public static final int TEX_STUCCI = 6;
    public static final int TEX_NOISE = 7;
    public static final int TEX_IMAGE = 8;
    public static final int TEX_PLUGIN = 9;
    public static final int TEX_ENVMAP = 10;
    public static final int TEX_MUSGRAVE = 11;
    public static final int TEX_VORONOI = 12;
    public static final int TEX_DISTNOISE = 13;

    public TextureHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public Texture getTexture(Structure tex, DataRepository dataRepository) throws BlenderFileException {
        Texture result = null;
        int type = ((Number)tex.getFieldValue("type")).intValue();
        int width = dataRepository.getBlenderKey().getGeneratedTextureWidth();
        int height = dataRepository.getBlenderKey().getGeneratedTextureHeight();
        switch (type) {
            case 0: {
                break;
            }
            case 8: {
                Pointer pImage = (Pointer)tex.getFieldValue("ima");
                Structure image = pImage.fetchData(dataRepository.getInputStream()).get(0);
                result = this.getTextureFromImage(image, dataRepository);
                break;
            }
            case 1: {
                result = this.clouds(tex, width, height, dataRepository);
                break;
            }
            case 2: {
                result = this.wood(tex, width, height, dataRepository);
                break;
            }
            case 3: {
                result = this.marble(tex, width, height, dataRepository);
                break;
            }
            case 4: {
                result = this.magic(tex, width, height, dataRepository);
                break;
            }
            case 5: {
                result = this.blend(tex, width, height, dataRepository);
                break;
            }
            case 6: {
                result = this.stucci(tex, width, height, dataRepository);
                break;
            }
            case 7: {
                result = this.texnoise(tex, width, height, dataRepository);
                break;
            }
            case 11: {
                result = this.musgrave(tex, width, height, dataRepository);
                break;
            }
            case 12: {
                result = this.voronoi(tex, width, height, dataRepository);
                break;
            }
            case 13: {
                result = this.distnoise(tex, width, height, dataRepository);
                break;
            }
            case 9: 
            case 10: {
                LOGGER.log(Level.WARNING, "Unsupported texture type: " + type + " for texture: " + tex.getName());
                break;
            }
            default: {
                throw new BlenderFileException("Unknown texture type: " + type + " for texture: " + tex.getName());
            }
        }
        if (result != null) {
            result.setName(String.valueOf(type));
            result.setWrap(Texture.WrapMode.Repeat);
        }
        return result;
    }

    protected Texture clouds(Structure tex, int width, int height, DataRepository dataRepository) {
        NoiseHelper noiseHelper = (NoiseHelper)dataRepository.getHelper(NoiseHelper.class);
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TexResult texres = new TexResult();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        int noiseDepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        int noiseBasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        int noiseType = ((Number)tex.getFieldValue("noisetype")).intValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float bright = ((Number)tex.getFieldValue("bright")).floatValue();
        boolean isHard = noiseType != 0;
        int sType = ((Number)tex.getFieldValue("stype")).intValue();
        int bytesPerPixel = sType == 1 ? 4 : 1;
        Image.Format format = sType == 1 ? Image.Format.RGBA8 : Image.Format.Luminance8;
        int halfW = width;
        int halfH = height;
        ByteBuffer data = BufferUtils.createByteBuffer((int)((width <<= 1) * (height <<= 1) * bytesPerPixel));
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                texres.tin = noiseHelper.bliGTurbulence(noisesize, texvec[0], texvec[1], texvec[2], noiseDepth, isHard, noiseBasis);
                if (texres.nor != null) {
                    float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
                    texres.nor[0] = noiseHelper.bliGTurbulence(noisesize, texvec[0] + nabla, texvec[1], texvec[2], noiseDepth, isHard, noiseBasis);
                    texres.nor[1] = noiseHelper.bliGTurbulence(noisesize, texvec[0], texvec[1] + nabla, texvec[2], noiseDepth, isHard, noiseBasis);
                    texres.nor[2] = noiseHelper.bliGTurbulence(noisesize, texvec[0], texvec[1], texvec[2] + nabla, noiseDepth, isHard, noiseBasis);
                    noiseHelper.texNormalDerivate(tex, texres, dataRepository);
                }
                if (sType == 1) {
                    texres.tr = texres.tin;
                    texres.tg = noiseHelper.bliGTurbulence(noisesize, texvec[1], texvec[0], texvec[2], noiseDepth, isHard, noiseBasis);
                    texres.tb = noiseHelper.bliGTurbulence(noisesize, texvec[1], texvec[2], texvec[0], noiseDepth, isHard, noiseBasis);
                    noiseHelper.brightnesAndContrastRGB(tex, texres);
                    data.put((byte)(texres.tin * 255.0f));
                    data.put((byte)(texres.tg * 255.0f));
                    data.put((byte)(texres.tb * 255.0f));
                    data.put((byte)-1);
                    continue;
                }
                noiseHelper.brightnesAndContrast(texres, contrast, bright);
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(format, width, height, data));
    }

    protected Texture wood(Structure tex, int width, int height, DataRepository dataRepository) {
        NoiseHelper noiseHelper = (NoiseHelper)dataRepository.getHelper(NoiseHelper.class);
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float bright = ((Number)tex.getFieldValue("bright")).floatValue();
        float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TexResult texres = new TexResult();
        int halfW = width;
        int halfH = height;
        ByteBuffer data = BufferUtils.createByteBuffer((int)((width <<= 1) * (height <<= 1)));
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                texres.tin = noiseHelper.woodInt(tex, texvec[0], texvec[1], texvec[2], dataRepository);
                if (texres.nor != null) {
                    texres.nor[0] = noiseHelper.woodInt(tex, texvec[0] + nabla, texvec[1], texvec[2], dataRepository);
                    texres.nor[1] = noiseHelper.woodInt(tex, texvec[0], texvec[1] + nabla, texvec[2], dataRepository);
                    texres.nor[2] = noiseHelper.woodInt(tex, texvec[0], texvec[1], texvec[2] + nabla, dataRepository);
                    noiseHelper.texNormalDerivate(tex, texres, dataRepository);
                }
                noiseHelper.brightnesAndContrast(texres, contrast, bright);
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(Image.Format.Luminance8, width, height, data));
    }

    protected Texture marble(Structure tex, int width, int height, DataRepository dataRepository) {
        NoiseHelper noiseHelper = (NoiseHelper)dataRepository.getHelper(NoiseHelper.class);
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float bright = ((Number)tex.getFieldValue("bright")).floatValue();
        float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TexResult texres = new TexResult();
        int halfW = width;
        int halfH = height;
        ByteBuffer data = BufferUtils.createByteBuffer((int)((width <<= 1) * (height <<= 1)));
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                texres.tin = noiseHelper.marbleInt(tex, texvec[0], texvec[1], texvec[2], dataRepository);
                if (texres.nor != null) {
                    texres.nor[0] = noiseHelper.marbleInt(tex, texvec[0] + nabla, texvec[1], texvec[2], dataRepository);
                    texres.nor[1] = noiseHelper.marbleInt(tex, texvec[0], texvec[1] + nabla, texvec[2], dataRepository);
                    texres.nor[2] = noiseHelper.marbleInt(tex, texvec[0], texvec[1], texvec[2] + nabla, dataRepository);
                    noiseHelper.texNormalDerivate(tex, texres, dataRepository);
                }
                noiseHelper.brightnesAndContrast(texres, contrast, bright);
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(Image.Format.Luminance8, width, height, data));
    }

    protected Texture magic(Structure tex, int width, int height, DataRepository dataRepository) {
        NoiseHelper noiseHelper = (NoiseHelper)dataRepository.getHelper(NoiseHelper.class);
        int noisedepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        float turbul = ((Number)tex.getFieldValue("turbul")).floatValue() / 5.0f;
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TexResult texres = new TexResult();
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        int halfW = (width <<= 1) / 2;
        int halfH = (height <<= 1) / 2;
        ByteBuffer data = BufferUtils.createByteBuffer((int)(width * height * 3));
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                float turb = turbul;
                texvec[1] = hDelta * (float)j;
                float x = (float)Math.sin((texvec[0] + texvec[1]) * 5.0f);
                float y = (float)Math.cos((-texvec[0] + texvec[1]) * 5.0f);
                float z = -((float)Math.cos((-texvec[0] - texvec[1]) * 5.0f));
                if (noisedepth > 0) {
                    y *= turb;
                    y = -((float)Math.cos((x *= turb) - y + (z *= turb)));
                    y *= turb;
                    if (noisedepth > 1) {
                        x = (float)Math.cos(x - y - z);
                        x *= turb;
                        if (noisedepth > 2) {
                            z = (float)Math.sin(-x - y - z);
                            z *= turb;
                            if (noisedepth > 3) {
                                x = -((float)Math.cos(-x + y - z));
                                x *= turb;
                                if (noisedepth > 4) {
                                    y = -((float)Math.sin(-x + y + z));
                                    y *= turb;
                                    if (noisedepth > 5) {
                                        y = -((float)Math.cos(-x + y + z));
                                        y *= turb;
                                        if (noisedepth > 6) {
                                            x = (float)Math.cos(x + y + z);
                                            x *= turb;
                                            if (noisedepth > 7) {
                                                z = (float)Math.sin(x + y - z);
                                                z *= turb;
                                                if (noisedepth > 8) {
                                                    x = -((float)Math.cos(-x - y + z));
                                                    x *= turb;
                                                    if (noisedepth > 9) {
                                                        y = -((float)Math.sin(x - y + z));
                                                        y *= turb;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (turb != 0.0f) {
                    x /= (turb *= 2.0f);
                    y /= turb;
                    z /= turb;
                }
                texres.tr = 0.5f - x;
                texres.tg = 0.5f - y;
                texres.tb = 0.5f - z;
                noiseHelper.brightnesAndContrastRGB(tex, texres);
                data.put((byte)(texres.tr * 255.0f));
                data.put((byte)(texres.tg * 255.0f));
                data.put((byte)(texres.tb * 255.0f));
            }
        }
        return new Texture2D(new Image(Image.Format.RGB8, width, height, data));
    }

    protected Texture blend(Structure tex, int width, int height, DataRepository dataRepository) {
        NoiseHelper noiseHelper = (NoiseHelper)dataRepository.getHelper(NoiseHelper.class);
        int flag = ((Number)tex.getFieldValue("flag")).intValue();
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float brightness = ((Number)tex.getFieldValue("bright")).floatValue();
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TexResult texres = new TexResult();
        int halfW = width;
        int halfH = height;
        byte[] data = new byte[(width <<= 1) * (height <<= 1)];
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                float y;
                float x;
                texvec[1] = hDelta * (float)j;
                if ((flag & 2) != 0) {
                    x = texvec[1];
                    y = texvec[0];
                } else {
                    x = texvec[0];
                    y = texvec[1];
                }
                if (stype == 0) {
                    texres.tin = (1.0f + x) / 2.0f;
                } else if (stype == 1) {
                    texres.tin = (1.0f + x) / 2.0f;
                    texres.tin = texres.tin < 0.0f ? 0.0f : (texres.tin *= texres.tin);
                } else if (stype == 2) {
                    texres.tin = (1.0f + x) / 2.0f;
                    if (texres.tin <= 0.0f) {
                        texres.tin = 0.0f;
                    } else if (texres.tin >= 1.0f) {
                        texres.tin = 1.0f;
                    } else {
                        float t = texres.tin * texres.tin;
                        texres.tin = 3.0f * t - 2.0f * t * texres.tin;
                    }
                } else if (stype == 3) {
                    texres.tin = (2.0f + x + y) / 4.0f;
                } else if (stype == 6) {
                    texres.tin = (float)Math.atan2(y, x) / ((float)Math.PI * 2) + 0.5f;
                } else {
                    texres.tin = 1.0f - (float)Math.sqrt(x * x + y * y + texvec[2] * texvec[2]);
                    if (texres.tin < 0.0f) {
                        texres.tin = 0.0f;
                    }
                    if (stype == 5) {
                        texres.tin *= texres.tin;
                    }
                }
                noiseHelper.brightnesAndContrast(texres, contrast, brightness);
                data[(j + halfH) * width + i + halfW] = (byte)(texres.tin * 255.0f);
            }
        }
        return new Texture2D(new Image(Image.Format.Luminance8, width, height, BufferUtils.createByteBuffer((byte[])data)));
    }

    protected Texture stucci(Structure tex, int width, int height, DataRepository dataRepository) {
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        int noisetype = ((Number)tex.getFieldValue("noisetype")).intValue();
        float turbul = ((Number)tex.getFieldValue("turbul")).floatValue();
        boolean isHard = noisetype != 0;
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        NoiseHelper noiseHelper = (NoiseHelper)dataRepository.getHelper(NoiseHelper.class);
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TexResult texres = new TexResult();
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        int halfW = width;
        int halfH = height;
        ByteBuffer data = BufferUtils.createByteBuffer((int)((width <<= 1) * (height <<= 1)));
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                float b2 = noiseHelper.bliGNoise(noisesize, texvec[0], texvec[1], texvec[2], isHard, noisebasis);
                float ofs = turbul / 200.0f;
                if (stype != 0) {
                    ofs *= b2 * b2;
                }
                texres.tin = noiseHelper.bliGNoise(noisesize, texvec[0], texvec[1], texvec[2] + ofs, isHard, noisebasis);
                if (texres.nor != null) {
                    texres.nor[0] = noiseHelper.bliGNoise(noisesize, texvec[0] + ofs, texvec[1], texvec[2], isHard, noisebasis);
                    texres.nor[1] = noiseHelper.bliGNoise(noisesize, texvec[0], texvec[1] + ofs, texvec[2], isHard, noisebasis);
                    texres.nor[2] = texres.tin;
                    noiseHelper.texNormalDerivate(tex, texres, dataRepository);
                    if (stype == 2) {
                        texres.nor[0] = -texres.nor[0];
                        texres.nor[1] = -texres.nor[1];
                        texres.nor[2] = -texres.nor[2];
                    }
                }
                if (stype == 2) {
                    texres.tin = 1.0f - texres.tin;
                }
                if (texres.tin < 0.0f) {
                    texres.tin = 0.0f;
                }
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(Image.Format.Luminance8, width, height, data));
    }

    protected Texture texnoise(Structure tex, int width, int height, DataRepository dataRepository) {
        NoiseHelper noiseHelper = (NoiseHelper)dataRepository.getHelper(NoiseHelper.class);
        float div = 3.0f;
        int noisedepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float brightness = ((Number)tex.getFieldValue("bright")).floatValue();
        TexResult texres = new TexResult();
        int halfW = width;
        int halfH = height;
        ByteBuffer data = BufferUtils.createByteBuffer((int)((width <<= 1) * (height <<= 1)));
        for (int i = -halfW; i < halfW; ++i) {
            for (int j = -halfH; j < halfH; ++j) {
                int ran = FastMath.rand.nextInt();
                int val = ran & 3;
                int loop = noisedepth;
                while (loop-- != 0) {
                    val *= (ran >>= 2) & 3;
                    div *= 3.0f;
                }
                texres.tin = val;
                noiseHelper.brightnesAndContrast(texres, contrast, brightness);
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(Image.Format.Luminance8, width, height, data));
    }

    protected Texture musgrave(Structure tex, int width, int height, DataRepository dataRepository) {
        NoiseHelper noiseHelper = (NoiseHelper)dataRepository.getHelper(NoiseHelper.class);
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        TexResult texres = new TexResult();
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        int halfW = width;
        int halfH = height;
        ByteBuffer data = BufferUtils.createByteBuffer((int)((width <<= 1) * (height <<= 1)));
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i / noisesize;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j / noisesize;
                switch (stype) {
                    case 0: 
                    case 3: {
                        noiseHelper.mgMFractalOrfBmTex(tex, texvec, texres, dataRepository);
                        break;
                    }
                    case 1: 
                    case 2: {
                        noiseHelper.mgRidgedOrHybridMFTex(tex, texvec, texres, dataRepository);
                        break;
                    }
                    case 4: {
                        noiseHelper.mgHTerrainTex(tex, texvec, texres, dataRepository);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown type of musgrave texture: " + stype);
                    }
                }
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(Image.Format.Luminance8, width, height, data));
    }

    protected Texture voronoi(Structure tex, int width, int height, DataRepository dataRepository) {
        float aw4;
        float aw3;
        float aw2;
        NoiseHelper noiseHelper = (NoiseHelper)dataRepository.getHelper(NoiseHelper.class);
        float vn_w1 = ((Number)tex.getFieldValue("vn_w1")).floatValue();
        float vn_w2 = ((Number)tex.getFieldValue("vn_w2")).floatValue();
        float vn_w3 = ((Number)tex.getFieldValue("vn_w3")).floatValue();
        float vn_w4 = ((Number)tex.getFieldValue("vn_w4")).floatValue();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
        float ns_outscale = ((Number)tex.getFieldValue("ns_outscale")).floatValue();
        float vn_mexp = ((Number)tex.getFieldValue("vn_mexp")).floatValue();
        int vn_distm = ((Number)tex.getFieldValue("vn_distm")).intValue();
        int vn_coltype = ((Number)tex.getFieldValue("vn_coltype")).intValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float brightness = ((Number)tex.getFieldValue("bright")).floatValue();
        TexResult texres = new TexResult();
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        Image.Format format = vn_coltype != 0 ? Image.Format.RGBA8 : Image.Format.Luminance8;
        int halfW = width;
        int halfH = height;
        int bytesPerPixel = vn_coltype != 0 ? 4 : 1;
        width <<= 1;
        height <<= 1;
        float[] da = new float[4];
        float[] pa = new float[12];
        float[] ca = vn_coltype != 0 ? new float[3] : null;
        float aw1 = FastMath.abs((float)vn_w1);
        float sc = aw1 + (aw2 = FastMath.abs((float)vn_w2)) + (aw3 = FastMath.abs((float)vn_w3)) + (aw4 = FastMath.abs((float)vn_w4));
        if (sc != 0.0f) {
            sc = ns_outscale / sc;
        }
        ByteBuffer data = BufferUtils.createByteBuffer((int)(width * height * bytesPerPixel));
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i / noisesize;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j / noisesize;
                noiseHelper.voronoi(texvec[0], texvec[1], texvec[2], da, pa, vn_mexp, vn_distm);
                texres.tin = sc * FastMath.abs((float)(vn_w1 * da[0] + vn_w2 * da[1] + vn_w3 * da[2] + vn_w4 * da[3]));
                if (vn_coltype != 0) {
                    noiseHelper.cellNoiseV(pa[0], pa[1], pa[2], ca);
                    texres.tr = aw1 * ca[0];
                    texres.tg = aw1 * ca[1];
                    texres.tb = aw1 * ca[2];
                    noiseHelper.cellNoiseV(pa[3], pa[4], pa[5], ca);
                    texres.tr += aw2 * ca[0];
                    texres.tg += aw2 * ca[1];
                    texres.tb += aw2 * ca[2];
                    noiseHelper.cellNoiseV(pa[6], pa[7], pa[8], ca);
                    texres.tr += aw3 * ca[0];
                    texres.tg += aw3 * ca[1];
                    texres.tb += aw3 * ca[2];
                    noiseHelper.cellNoiseV(pa[9], pa[10], pa[11], ca);
                    texres.tr += aw4 * ca[0];
                    texres.tg += aw4 * ca[1];
                    texres.tb += aw4 * ca[2];
                    if (vn_coltype >= 2) {
                        float t1 = (da[1] - da[0]) * 10.0f;
                        if (t1 > 1.0f) {
                            t1 = 1.0f;
                        }
                        t1 = vn_coltype == 3 ? (t1 *= texres.tin) : (t1 *= sc);
                        texres.tr *= t1;
                        texres.tg *= t1;
                        texres.tb *= t1;
                    } else {
                        texres.tr *= sc;
                        texres.tg *= sc;
                        texres.tb *= sc;
                    }
                }
                if (texres.nor != null) {
                    float offs = nabla / noisesize;
                    noiseHelper.voronoi(texvec[0] + offs, texvec[1], texvec[2], da, pa, vn_mexp, vn_distm);
                    texres.nor[0] = sc * FastMath.abs((float)(vn_w1 * da[0] + vn_w2 * da[1] + vn_w3 * da[2] + vn_w4 * da[3]));
                    noiseHelper.voronoi(texvec[0], texvec[1] + offs, texvec[2], da, pa, vn_mexp, vn_distm);
                    texres.nor[1] = sc * FastMath.abs((float)(vn_w1 * da[0] + vn_w2 * da[1] + vn_w3 * da[2] + vn_w4 * da[3]));
                    noiseHelper.voronoi(texvec[0], texvec[1], texvec[2] + offs, da, pa, vn_mexp, vn_distm);
                    texres.nor[2] = sc * FastMath.abs((float)(vn_w1 * da[0] + vn_w2 * da[1] + vn_w3 * da[2] + vn_w4 * da[3]));
                    noiseHelper.texNormalDerivate(tex, texres, dataRepository);
                }
                if (vn_coltype != 0) {
                    noiseHelper.brightnesAndContrastRGB(tex, texres);
                    data.put((byte)(texres.tin * 255.0f));
                    data.put((byte)(texres.tg * 255.0f));
                    data.put((byte)(texres.tb * 255.0f));
                    data.put((byte)-1);
                    continue;
                }
                noiseHelper.brightnesAndContrast(texres, contrast, brightness);
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(format, width, height, data));
    }

    protected Texture distnoise(Structure tex, int width, int height, DataRepository dataRepository) {
        NoiseHelper noiseHelper = (NoiseHelper)dataRepository.getHelper(NoiseHelper.class);
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
        float distAmount = ((Number)tex.getFieldValue("dist_amount")).floatValue();
        int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        int noisebasis2 = ((Number)tex.getFieldValue("noisebasis2")).intValue();
        int vn_coltype = ((Number)tex.getFieldValue("vn_coltype")).intValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float brightness = ((Number)tex.getFieldValue("bright")).floatValue();
        TexResult texres = new TexResult();
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        int halfW = width;
        int halfH = height;
        int bytesPerPixel = vn_coltype != 0 ? 4 : 1;
        ByteBuffer data = BufferUtils.createByteBuffer((int)((width <<= 1) * (height <<= 1) * bytesPerPixel));
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i / noisesize;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j / noisesize;
                texres.tin = noiseHelper.mgVLNoise(texvec[0], texvec[1], texvec[2], distAmount, noisebasis, noisebasis2);
                if (texres.nor != null) {
                    float offs = nabla / noisesize;
                    texres.nor[0] = noiseHelper.mgVLNoise(texvec[0] + offs, texvec[1], texvec[2], distAmount, noisebasis, noisebasis2);
                    texres.nor[1] = noiseHelper.mgVLNoise(texvec[0], texvec[1] + offs, texvec[2], distAmount, noisebasis, noisebasis2);
                    texres.nor[2] = noiseHelper.mgVLNoise(texvec[0], texvec[1], texvec[2] + offs, distAmount, noisebasis, noisebasis2);
                    noiseHelper.texNormalDerivate(tex, texres, dataRepository);
                }
                noiseHelper.brightnesAndContrast(texres, contrast, brightness);
                data.put((byte)(texres.tin * 255.0f));
            }
        }
        return new Texture2D(new Image(Image.Format.Luminance8, width, height, data));
    }

    public Texture getTextureFromImage(Structure image, DataRepository dataRepository) throws BlenderFileException {
        Texture result = (Texture)dataRepository.getLoadedFeature(image.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (result == null) {
            Pointer pPackedFile = (Pointer)image.getFieldValue("packedfile");
            if (pPackedFile.isNull()) {
                LOGGER.info("Reading texture from file!");
                String imagePath = image.getFieldValue("name").toString();
                result = this.loadTextureFromFile(imagePath, dataRepository);
            } else {
                LOGGER.info("Packed texture. Reading directly from the blend file!");
                Structure packedFile = pPackedFile.fetchData(dataRepository.getInputStream()).get(0);
                Pointer pData = (Pointer)packedFile.getFieldValue("data");
                FileBlockHeader dataFileBlock = dataRepository.getFileBlock(pData.getOldMemoryAddress());
                dataRepository.getInputStream().setPosition(dataFileBlock.getBlockPosition());
                ImageLoader imageLoader = new ImageLoader();
                Image im = imageLoader.loadImage(dataRepository.getInputStream(), dataFileBlock.getBlockPosition(), false);
                if (im != null) {
                    result = new Texture2D(im);
                }
            }
            if (result != null) {
                result.setName(String.valueOf(8));
                result.setWrap(Texture.WrapMode.Repeat);
                dataRepository.addLoadedFeatures(image.getOldMemoryAddress(), image.getName(), image, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Texture loadTextureFromFile(String name, DataRepository dataRepository) {
        File textureFile;
        File textureFolder;
        File textureFile2;
        Image image = null;
        ImageLoader imageLoader = new ImageLoader();
        FileInputStream fis = null;
        ImageType[] imageTypes = ImageType.values();
        if (name.startsWith("//") && (textureFile2 = new File(name = (textureFolder = new File(dataRepository.getBlenderKey().getName()).getParentFile()).getPath() + "/." + name.substring(1))).exists() && textureFile2.isFile()) {
            for (int i = 0; i < imageTypes.length && image == null; ++i) {
                try {
                    fis = new FileInputStream(textureFile2);
                    image = imageLoader.loadImage(fis, imageTypes[i], false);
                    this.closeStream(fis);
                    continue;
                }
                catch (FileNotFoundException e) {
                    assert (false) : e;
                    continue;
                }
            }
        }
        if (image == null && (textureFile = new File(name)).exists() && textureFile.isFile()) {
            LOGGER.info("Trying with: " + name);
            try {
                for (int i = 0; i < imageTypes.length && image == null; ++i) {
                    fis = new FileInputStream(textureFile);
                    image = imageLoader.loadImage(fis, imageTypes[i], false);
                    this.closeStream(fis);
                }
            }
            catch (FileNotFoundException e) {
                assert (false) : e;
            }
            finally {
                this.closeStream(fis);
            }
        }
        if (image == null) {
            String baseName = File.separatorChar != '/' ? name.replace(File.separatorChar, '/') : name;
            int idx = baseName.lastIndexOf(47);
            while (idx != -1 && image == null) {
                String texName = baseName.substring(idx + 1);
                File textureFile3 = new File(texName);
                if (textureFile3.exists() && textureFile3.isFile()) {
                    LOGGER.info("Trying with: " + texName);
                    try {
                        for (int i = 0; i < imageTypes.length && image == null; ++i) {
                            fis = new FileInputStream(textureFile3);
                            image = imageLoader.loadImage(fis, imageTypes[i], false);
                        }
                    }
                    catch (FileNotFoundException e) {
                        assert (false) : e;
                    }
                    finally {
                        this.closeStream(fis);
                    }
                }
                if (idx > 1) {
                    idx = baseName.lastIndexOf(47, idx - 1);
                    continue;
                }
                idx = -1;
            }
        }
        return image == null ? null : new Texture2D(image);
    }

    protected void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
    }

    protected class TexResult {
        public float tin;
        public float tr;
        public float tg;
        public float tb;
        public float ta;
        public int talpha;
        public float[] nor;

        protected TexResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        AWT,
        TGA,
        DDS;

    }

    protected static class ImageLoader
    extends AWTLoader {
        private static final Logger LOGGER = Logger.getLogger(ImageLoader.class.getName());
        protected DDSLoader ddsLoader = new DDSLoader();

        protected ImageLoader() {
        }

        public Image loadImage(BlenderInputStream inputStream, int startPosition, boolean flipY) {
            inputStream.setPosition(startPosition);
            Image result = this.loadImage((InputStream)inputStream, ImageType.AWT, flipY);
            if (result == null) {
                inputStream.setPosition(startPosition);
                result = this.loadImage((InputStream)inputStream, ImageType.TGA, flipY);
            }
            if (result == null) {
                inputStream.setPosition(startPosition);
                result = this.loadImage((InputStream)inputStream, ImageType.DDS, flipY);
            }
            if (result == null) {
                LOGGER.warning("Image could not be loaded by none of available loaders!");
            }
            return result;
        }

        public Image loadImage(InputStream inputStream, ImageType imageType, boolean flipY) {
            Image result = null;
            switch (imageType) {
                case AWT: {
                    try {
                        result = this.load(inputStream, flipY);
                    }
                    catch (Exception e) {
                        LOGGER.info("Unable to load image using AWT loader!");
                    }
                    break;
                }
                case DDS: {
                    try {
                        result = this.ddsLoader.load(inputStream);
                    }
                    catch (Exception e) {
                        LOGGER.info("Unable to load image using DDS loader!");
                    }
                    break;
                }
                case TGA: {
                    try {
                        result = TGALoader.load((InputStream)inputStream, (boolean)flipY);
                    }
                    catch (Exception e) {
                        LOGGER.info("Unable to load image using TGA loader!");
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown image type: " + (Object)((Object)imageType));
                }
            }
            return result;
        }
    }
}

