/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.test.config;

import com.jme3.asset.BlenderKey;
import com.jme3.asset.ModelKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.scene.plugins.blender.test.config.AbstractConfigDialog;
import com.jme3.scene.plugins.blender.test.config.IConfigExecutable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class ConfigDialog
extends AbstractConfigDialog {
    private static final long serialVersionUID = 2863364888664674247L;
    private static final Logger LOGGER = Logger.getLogger(ConfigDialog.class.getName());
    private String baseFolderName;
    private File configFile;
    private Map<String, BlenderKeyConfiguration> configMap;
    private BlenderKeyConfiguration blenderKeyConfiguration;
    private IConfigExecutable configExecutable;

    public ConfigDialog(String baseFolderName, IConfigExecutable configExecutable) {
        File[] folders;
        if (baseFolderName == null) {
            throw new IllegalArgumentException("No test asset folder given!");
        }
        if (configExecutable == null) {
            throw new IllegalArgumentException("No config executable given!");
        }
        this.baseFolderName = baseFolderName;
        this.configExecutable = configExecutable;
        this.configMap = new HashMap<String, BlenderKeyConfiguration>();
        File baseFolder = new File(baseFolderName);
        if (!baseFolder.exists() || !baseFolder.isDirectory()) {
            throw new IllegalArgumentException("The given base folder path either does not exists or does not point to a directory!");
        }
        for (File folder : folders = baseFolder.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && file.getName().charAt(0) != '.';
            }
        })) {
            ((DefaultComboBoxModel)this.jComboBoxVersionSelection.getModel()).addElement(folder.getName());
            this.configMap.put(folder.getName(), null);
        }
        this.initListeners();
        this.jComboBoxVersionSelection.setSelectedIndex(0);
    }

    public BlenderKey getSelectedBlenderKey() {
        return this.blenderKeyConfiguration.lastUsedKey;
    }

    private File[] prepareFilesList(String testAssetsFolderName) {
        File testAssetsFolder = new File(testAssetsFolderName);
        File[] blenderFiles = testAssetsFolder.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.canRead() && file.getName().endsWith(".blend");
            }
        });
        Object[] files = testAssetsFolder.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.canRead() && file.getName().endsWith(".conf");
            }
        });
        if (files == null || files.length == 0) {
            this.blenderKeyConfiguration = new BlenderKeyConfiguration(blenderFiles.length);
        } else {
            BinaryImporter jmeImporter = new BinaryImporter();
            String instructionToUser = files.length == 1 ? "No other config file to load! No configuration set!" : "Please choose different config file!";
            do {
                this.configFile = files.length > 1 ? (File)JOptionPane.showInputDialog(null, "Choose the config file!", "Config file selection", 1, null, files, files[0]) : files[0];
                if (this.configFile == null) {
                    JOptionPane.showMessageDialog(this, "No config file selected!\nEmpty configuration will be created!", "No configuration selected", 1);
                    this.blenderKeyConfiguration = new BlenderKeyConfiguration(blenderFiles.length);
                    continue;
                }
                try {
                    Savable loadedData = jmeImporter.load(this.configFile);
                    if (loadedData instanceof BlenderKeyConfiguration) {
                        this.blenderKeyConfiguration = (BlenderKeyConfiguration)loadedData;
                        continue;
                    }
                    LOGGER.warning("Cannot load data drom the given file!");
                    JOptionPane.showMessageDialog(this, "The data stored in the config file is of invalid type!\n" + instructionToUser, "Config data error", 0);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Unable to load configuration! Reason: " + e.getLocalizedMessage(), "Loading data error", 0);
                    LOGGER.severe("Unable to load configuration");
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Unable to load configuration!", "Loading data error", 0);
                    LOGGER.log(Level.SEVERE, "Unable to load configuration due to unpredicted error!", e);
                }
            } while (this.blenderKeyConfiguration == null && files.length > 1);
        }
        if (this.configFile == null) {
            this.configFile = new File(testAssetsFolder, "test.conf");
        }
        this.jCheckBoxUseModelKey.setSelected(this.blenderKeyConfiguration.useModelKey);
        DefaultListModel defaultListModel = (DefaultListModel)this.jListBlenderFiles.getModel();
        defaultListModel.removeAllElements();
        for (int i = 0; i < blenderFiles.length; ++i) {
            defaultListModel.addElement(new AbstractConfigDialog.FileListItem(blenderFiles[i]));
        }
        return blenderFiles;
    }

    private void setBlenderKey(BlenderKey blenderKey) {
        Field[] fields;
        AbstractConfigDialog.BlenderTableModel propertiesModel = (AbstractConfigDialog.BlenderTableModel)this.jTableProperties.getModel();
        int rowCount = propertiesModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            propertiesModel.removeRow(0);
        }
        for (Field field : fields = ((Object)((Object)blenderKey)).getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if ("animations".equalsIgnoreCase(field.getName()) || (field.getModifiers() & 8) != 0) continue;
            try {
                propertiesModel.addRow(new Object[]{field.getName(), field.get((Object)blenderKey)});
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        DefaultTableModel animationsModel = (DefaultTableModel)this.jTableAnimations.getModel();
        rowCount = animationsModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            animationsModel.removeRow(0);
        }
        Map<String, Map<String, int[]>> animations = blenderKey.getAnimations();
        if (animations != null) {
            for (Map.Entry<String, Map<String, int[]>> animationEntry : animations.entrySet()) {
                for (Map.Entry<String, int[]> animDataEntry : animationEntry.getValue().entrySet()) {
                    int[] frames = animDataEntry.getValue();
                    animationsModel.addRow(new Object[]{animationEntry.getKey(), animDataEntry.getKey(), frames[0], frames[1]});
                }
            }
        }
        this.jButtonOK.setEnabled(true);
        this.jButtonOK.requestFocusInWindow();
        this.jButtonAddAnimation.setEnabled(true);
    }

    private void storeConfig(BlenderKeyConfiguration configuration) {
        if (configuration.lastUsedKey != null) {
            DefaultTableModel animationsTableModel = (DefaultTableModel)this.jTableAnimations.getModel();
            if (configuration.lastUsedKey.getAnimations() != null) {
                configuration.lastUsedKey.getAnimations().clear();
            }
            int animCounter = 0;
            for (int i = 0; i < animationsTableModel.getRowCount(); ++i) {
                String objectName = (String)animationsTableModel.getValueAt(i, 0);
                String animName = (String)animationsTableModel.getValueAt(i, 1);
                Number startFrame = (Number)animationsTableModel.getValueAt(i, 2);
                Number stopFrame = (Number)animationsTableModel.getValueAt(i, 3);
                if (objectName == null || animName == null || startFrame.intValue() > stopFrame.intValue()) continue;
                configuration.lastUsedKey.addAnimation(objectName, animName, startFrame.intValue(), stopFrame.intValue());
                ++animCounter;
            }
            if (animCounter < animationsTableModel.getRowCount()) {
                JOptionPane.showMessageDialog(this, "Some animations had errors!\nThey had not been added!", "Invalid animations definitions", 2);
            }
        }
        configuration.useModelKey = this.jCheckBoxUseModelKey.isSelected();
        configuration.logLevel = AbstractConfigDialog.JRadioButtonLevel.getSelectedLevel();
        BinaryExporter jmeExporter = new BinaryExporter();
        try {
            if (!jmeExporter.save((Savable)configuration, this.configFile)) {
                JOptionPane.showMessageDialog(this, "Unable to save the config data!", "Config save problem", 0);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error occured during config saving!\nReason: " + e.getLocalizedMessage(), "Config save problem", 0);
        }
    }

    private void initListeners() {
        this.jComboBoxVersionSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ConfigDialog.this.blenderKeyConfiguration != null) {
                    ConfigDialog.this.storeConfig(ConfigDialog.this.blenderKeyConfiguration);
                }
                File[] blenderFiles = ConfigDialog.this.prepareFilesList(ConfigDialog.this.baseFolderName + '/' + ConfigDialog.this.jComboBoxVersionSelection.getSelectedItem().toString());
                if (ConfigDialog.this.blenderKeyConfiguration.lastUsedKey != null) {
                    for (int i = 0; i < blenderFiles.length; ++i) {
                        if (!blenderFiles[i].getPath().equalsIgnoreCase(ConfigDialog.this.blenderKeyConfiguration.lastUsedKey.getName())) continue;
                        ConfigDialog.this.jListBlenderFiles.setSelectedIndex(i);
                        break;
                    }
                }
                if (ConfigDialog.this.blenderKeyConfiguration.logLevel == null) {
                    ConfigDialog.this.blenderKeyConfiguration.logLevel = Level.INFO;
                }
                AbstractConfigDialog.JRadioButtonLevel.setSelectedLevel(ConfigDialog.this.blenderKeyConfiguration.logLevel);
            }
        });
        this.jListBlenderFiles.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                BlenderKeyConfiguration config = ConfigDialog.this.blenderKeyConfiguration;
                AbstractConfigDialog.FileListItem selectedItem = (AbstractConfigDialog.FileListItem)ConfigDialog.this.jListBlenderFiles.getSelectedValue();
                String fileName = selectedItem.getFile().getName();
                config.lastUsedKey = (BlenderKey)((Object)config.blenderKeys.get(fileName));
                if (config.lastUsedKey == null) {
                    config.lastUsedKey = new BlenderKey(selectedItem.getFile().getPath());
                    config.blenderKeys.put(fileName, config.lastUsedKey);
                }
                ConfigDialog.this.setBlenderKey(ConfigDialog.this.blenderKeyConfiguration.lastUsedKey);
            }
        });
        this.jTableProperties.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                if (evt.getType() == 0) {
                    BlenderKeyConfiguration config = ConfigDialog.this.blenderKeyConfiguration;
                    int row = evt.getFirstRow();
                    String name = (String)ConfigDialog.this.jTableProperties.getModel().getValueAt(row, 0);
                    Object value = ConfigDialog.this.jTableProperties.getModel().getValueAt(row, 1);
                    try {
                        Field field = ((Object)((Object)config.lastUsedKey)).getClass().getDeclaredField(name);
                        field.setAccessible(true);
                        field.set((Object)config.lastUsedKey, value);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    catch (SecurityException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    catch (NoSuchFieldException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        });
        this.jTableAnimations.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                if (evt.getType() == 1) {
                    ConfigDialog.this.jButtonRemoveAnimation.setEnabled(true);
                } else if (evt.getType() == -1 && ConfigDialog.this.jTableAnimations.getModel().getRowCount() == 0) {
                    ConfigDialog.this.jButtonRemoveAnimation.setEnabled(false);
                }
            }
        });
        this.jButtonAddAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((DefaultTableModel)ConfigDialog.this.jTableAnimations.getModel()).addRow(new Object[]{"", "", -1, -1});
            }
        });
        this.jButtonRemoveAnimation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int row = ConfigDialog.this.jTableAnimations.getSelectedRow();
                if (row >= 0) {
                    ((DefaultTableModel)ConfigDialog.this.jTableAnimations.getModel()).removeRow(row);
                }
            }
        });
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.storeConfig(ConfigDialog.this.blenderKeyConfiguration);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ConfigDialog.this.configExecutable.execute(ConfigDialog.this.blenderKeyConfiguration.getKeyToUse(), ConfigDialog.this.blenderKeyConfiguration.logLevel);
                    }
                });
                ConfigDialog.this.dispose();
            }
        });
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.dispose();
            }
        });
    }

    public static class BlenderKeyConfiguration
    implements Savable {
        private Map<String, BlenderKey> blenderKeys;
        private BlenderKey lastUsedKey;
        private Level logLevel;
        private boolean useModelKey;

        public BlenderKeyConfiguration() {
        }

        public BlenderKeyConfiguration(int blenderFilesAmount) {
            this.blenderKeys = new HashMap<String, BlenderKey>(blenderFilesAmount);
        }

        public ModelKey getKeyToUse() {
            return this.useModelKey ? new ModelKey(this.lastUsedKey.getName()) : this.lastUsedKey;
        }

        public void write(JmeExporter ex) throws IOException {
            OutputCapsule oc = ex.getCapsule((Savable)this);
            oc.writeStringSavableMap(this.blenderKeys, "keys", null);
            oc.write((Savable)this.lastUsedKey, "last-key", null);
            oc.write(this.useModelKey, "use-model-key", false);
            oc.write(this.logLevel == null ? null : this.logLevel.getName(), "log-level", Level.INFO.getName());
        }

        public void read(JmeImporter im) throws IOException {
            InputCapsule ic = im.getCapsule((Savable)this);
            this.blenderKeys = ic.readStringSavableMap("keys", null);
            this.lastUsedKey = (BlenderKey)ic.readSavable("last-key", null);
            this.useModelKey = ic.readBoolean("use-model-key", false);
            String logLevelName = ic.readString("log-level", Level.INFO.getName());
            this.logLevel = logLevelName == null ? Level.INFO : Level.parse(logLevelName);
        }
    }
}

