/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.google.common.annotations.VisibleForTesting;
import com.jeantessier.classreader.Annotation;
import com.jeantessier.classreader.AnnotationDefault_attribute;
import com.jeantessier.classreader.AnnotationElementValue;
import com.jeantessier.classreader.ArrayElementValue;
import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.BitFormat;
import com.jeantessier.classreader.BooleanConstantElementValue;
import com.jeantessier.classreader.ByteConstantElementValue;
import com.jeantessier.classreader.CharConstantElementValue;
import com.jeantessier.classreader.ClassElementValue;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.ConstantElementValue;
import com.jeantessier.classreader.ConstantPool;
import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.ConstantValue_attribute;
import com.jeantessier.classreader.Custom_attribute;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.DescriptorHelper;
import com.jeantessier.classreader.DoubleConstantElementValue;
import com.jeantessier.classreader.Double_info;
import com.jeantessier.classreader.ElementValuePair;
import com.jeantessier.classreader.EnclosingMethod_attribute;
import com.jeantessier.classreader.EnumElementValue;
import com.jeantessier.classreader.ExceptionHandler;
import com.jeantessier.classreader.Exceptions_attribute;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.FloatConstantElementValue;
import com.jeantessier.classreader.Float_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.InnerClasses_attribute;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.IntegerConstantElementValue;
import com.jeantessier.classreader.Integer_info;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.LineNumber;
import com.jeantessier.classreader.LineNumberTable_attribute;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.LocalVariableTable_attribute;
import com.jeantessier.classreader.LocalVariableType;
import com.jeantessier.classreader.LocalVariableTypeTable_attribute;
import com.jeantessier.classreader.LongConstantElementValue;
import com.jeantessier.classreader.Long_info;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.NameAndType_info;
import com.jeantessier.classreader.Parameter;
import com.jeantessier.classreader.Printer;
import com.jeantessier.classreader.RuntimeAnnotations_attribute;
import com.jeantessier.classreader.RuntimeInvisibleAnnotations_attribute;
import com.jeantessier.classreader.RuntimeInvisibleParameterAnnotations_attribute;
import com.jeantessier.classreader.RuntimeParameterAnnotations_attribute;
import com.jeantessier.classreader.RuntimeVisibleAnnotations_attribute;
import com.jeantessier.classreader.RuntimeVisibleParameterAnnotations_attribute;
import com.jeantessier.classreader.ShortConstantElementValue;
import com.jeantessier.classreader.Signature_attribute;
import com.jeantessier.classreader.SourceFile_attribute;
import com.jeantessier.classreader.StringConstantElementValue;
import com.jeantessier.classreader.String_info;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.text.Hex;
import java.io.PrintWriter;
import java.util.Collection;

public class XMLPrinter
extends Printer {
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final String DEFAULT_DTD_PREFIX = "http://depfind.sourceforge.net/dtd";
    private static final BitFormat format = new BitFormat(16);
    private boolean top = true;

    public XMLPrinter(PrintWriter out) {
        this(out, DEFAULT_ENCODING, DEFAULT_DTD_PREFIX);
    }

    public XMLPrinter(PrintWriter out, String encoding, String dtdPrefix) {
        super(out);
        this.appendHeader(encoding, dtdPrefix);
    }

    private void appendHeader(String encoding, String dtdPrefix) {
        this.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\" ?>").eol();
        this.eol();
        this.append("<!DOCTYPE classfiles SYSTEM \"").append(dtdPrefix).append("/classfile.dtd\">").eol();
        this.eol();
    }

    @Override
    public void visitClassfiles(Collection<Classfile> classfiles) {
        this.indent().append("<classfiles>").eol();
        this.raiseIndent();
        super.visitClassfiles(classfiles);
        this.lowerIndent();
        this.indent().append("</classfiles>").eol();
    }

    @Override
    public void visitClassfile(Classfile classfile) {
        this.indent().append("<classfile magic-number=\"0x").append(Integer.toHexString(classfile.getMagicNumber()).toUpperCase()).append("\" minor-version=\"").append(classfile.getMinorVersion()).append("\" major-version=\"").append(classfile.getMajorVersion()).append("\" access-flag=\"").append(format.format(classfile.getAccessFlag())).append("\">").eol();
        this.raiseIndent();
        this.top = true;
        classfile.getConstantPool().accept(this);
        this.top = false;
        if (classfile.isPublic()) {
            this.indent().append("<public/>").eol();
        }
        if (classfile.isFinal()) {
            this.indent().append("<final/>").eol();
        }
        if (classfile.isSuper()) {
            this.indent().append("<super/>").eol();
        }
        if (classfile.isInterface()) {
            this.indent().append("<is-interface/>").eol();
        }
        if (classfile.isAbstract()) {
            this.indent().append("<abstract/>").eol();
        }
        if (classfile.isSynthetic()) {
            this.indent().append("<synthetic/>").eol();
        }
        if (classfile.isAnnotation()) {
            this.indent().append("<is-annotation/>").eol();
        }
        if (classfile.isEnum()) {
            this.indent().append("<enum/>").eol();
        }
        this.indent();
        this.append("<this-class>");
        classfile.getRawClass().accept(this);
        this.append("</this-class>").eol();
        this.indent();
        this.append("<superclass>");
        if (classfile.getSuperclassIndex() != 0) {
            classfile.getRawSuperclass().accept(this);
        }
        this.append("</superclass>").eol();
        if (!classfile.getAllInterfaces().isEmpty()) {
            this.indent().append("<interfaces>").eol();
            this.raiseIndent();
            for (Class_info class_info : classfile.getAllInterfaces()) {
                this.indent();
                this.append("<interface>");
                class_info.accept(this);
                this.append("</interface>").eol();
            }
            this.lowerIndent();
            this.indent().append("</interfaces>").eol();
        }
        if (!classfile.getAllFields().isEmpty()) {
            this.indent().append("<fields>").eol();
            this.raiseIndent();
            for (Field_info field_info : classfile.getAllFields()) {
                field_info.accept(this);
            }
            this.lowerIndent();
            this.indent().append("</fields>").eol();
        }
        if (!classfile.getAllMethods().isEmpty()) {
            this.indent().append("<methods>").eol();
            this.raiseIndent();
            for (Method_info method_info : classfile.getAllMethods()) {
                method_info.accept(this);
            }
            this.lowerIndent();
            this.indent().append("</methods>").eol();
        }
        if (!classfile.getAttributes().isEmpty()) {
            this.indent().append("<attributes>").eol();
            this.raiseIndent();
            for (Attribute_info attribute_info : classfile.getAttributes()) {
                attribute_info.accept(this);
            }
            this.lowerIndent();
            this.indent().append("</attributes>").eol();
        }
        this.lowerIndent();
        this.indent().append("</classfile>").eol();
    }

    @Override
    public void visitConstantPool(ConstantPool constantPool) {
        this.resetCount();
        this.indent().append("<constant-pool>").eol();
        this.raiseIndent();
        for (ConstantPoolEntry entry : constantPool) {
            if (entry != null) {
                entry.accept(this);
            }
            this.incrementCount();
        }
        this.lowerIndent();
        this.indent().append("</constant-pool>").eol();
    }

    @Override
    public void visitClass_info(Class_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<class index=\"").append(this.currentCount()).append("\">");
            this.append(entry.getName());
            this.append("</class>").eol();
            this.top = true;
        } else {
            this.append(entry.getName());
        }
    }

    @Override
    public void visitFieldRef_info(FieldRef_info entry) {
        Class_info c = entry.getRawClass();
        NameAndType_info nat = entry.getRawNameAndType();
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<field-ref-info index=\"").append(this.currentCount()).append("\">");
            this.append("<class>");
            c.accept(this);
            this.append("</class>");
            this.append("<type>");
            nat.getRawType().accept(this);
            this.append("</type>");
            this.append("<name>");
            nat.getRawName().accept(this);
            this.append("</name>");
            this.append("</field-ref-info>").eol();
            this.top = true;
        } else {
            this.append(DescriptorHelper.getType(nat.getType()));
            this.append(" ");
            this.append(entry.getFullSignature());
        }
    }

    @Override
    public void visitMethodRef_info(MethodRef_info entry) {
        Class_info c = entry.getRawClass();
        NameAndType_info nat = entry.getRawNameAndType();
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<method-ref-info index=\"").append(this.currentCount()).append("\">");
            this.append("<class>");
            c.accept(this);
            this.append("</class>");
            this.append("<name>");
            nat.getRawName().accept(this);
            this.append("</name>");
            this.append("<type>");
            nat.getRawType().accept(this);
            this.append("</type>");
            this.append("</method-ref-info>").eol();
            this.top = true;
        } else {
            if (!entry.isConstructor() && !entry.isStaticInitializer()) {
                this.append(DescriptorHelper.getReturnType(nat.getType())).append(" ");
            }
            this.append(entry.getFullSignature());
        }
    }

    @Override
    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
        Class_info c = entry.getRawClass();
        NameAndType_info nat = entry.getRawNameAndType();
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<interface-method-ref-info index=\"").append(this.currentCount()).append("\">");
            this.append("<class>");
            c.accept(this);
            this.append("</class>");
            this.append("<name>");
            nat.getRawName().accept(this);
            this.append("</name>");
            this.append("<type>");
            nat.getRawType().accept(this);
            this.append("</type>");
            this.append("</interface-method-ref-info>").eol();
            this.top = true;
        } else {
            this.append(DescriptorHelper.getReturnType(nat.getType()));
            this.append(" ");
            this.append(entry.getFullSignature());
        }
    }

    @Override
    public void visitString_info(String_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<string-info index=\"").append(this.currentCount()).append("\">");
            entry.getRawValue().accept(this);
            this.append("</string-info>").eol();
            this.top = true;
        } else {
            entry.getRawValue().accept(this);
        }
    }

    @Override
    public void visitInteger_info(Integer_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<integer-info index=\"").append(this.currentCount()).append("\">");
            this.append(entry.getValue());
            this.append("</integer-info>").eol();
            this.top = true;
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitFloat_info(Float_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<float-info index=\"").append(this.currentCount()).append("\">");
            this.append(entry.getValue());
            this.append("</float-info>").eol();
            this.top = true;
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitLong_info(Long_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<long-info index=\"").append(this.currentCount()).append("\">");
            this.append(entry.getValue());
            this.append("</long-info>").eol();
            this.top = true;
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitDouble_info(Double_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<double-info index=\"").append(this.currentCount()).append("\">");
            this.append(entry.getValue());
            this.append("</double-info>").eol();
            this.top = true;
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitNameAndType_info(NameAndType_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<name-and-type-info index=\"").append(this.currentCount()).append("\">");
            this.append("<name>");
            entry.getRawName().accept(this);
            this.append("</name>");
            this.append("<type>");
            entry.getRawType().accept(this);
            this.append("</type>");
            this.append("</name-and-type-info>").eol();
            this.top = true;
        } else {
            entry.getRawName().accept(this);
            this.append(" ");
            entry.getRawType().accept(this);
        }
    }

    @Override
    public void visitUTF8_info(UTF8_info entry) {
        if (this.top) {
            this.top = false;
            this.indent().append("<utf8-info index=\"").append(this.currentCount()).append("\">");
            this.append(this.escapeXMLCharacters(entry.getValue()));
            this.append("</utf8-info>").eol();
            this.top = true;
        } else {
            this.append(this.escapeXMLCharacters(entry.getValue()));
        }
    }

    @Override
    public void visitField_info(Field_info entry) {
        this.indent().append("<field-info access-flag=\"").append(format.format(entry.getAccessFlag())).append("\">").eol();
        this.raiseIndent();
        if (entry.isPublic()) {
            this.indent().append("<public/>").eol();
        }
        if (entry.isProtected()) {
            this.indent().append("<protected/>").eol();
        }
        if (entry.isPrivate()) {
            this.indent().append("<private/>").eol();
        }
        if (entry.isStatic()) {
            this.indent().append("<static/>").eol();
        }
        if (entry.isFinal()) {
            this.indent().append("<final/>").eol();
        }
        if (entry.isVolatile()) {
            this.indent().append("<volatile/>").eol();
        }
        if (entry.isTransient()) {
            this.indent().append("<transient/>").eol();
        }
        if (entry.isSynthetic()) {
            this.indent().append("<synthetic/>").eol();
        }
        if (entry.isEnum()) {
            this.indent().append("<enum/>").eol();
        }
        this.indent();
        this.append("<name>");
        entry.getRawName().accept(this);
        this.append("</name>").eol();
        this.indent().append("<type>").append(entry.getType()).append("</type>").eol();
        if (!entry.getAttributes().isEmpty()) {
            this.indent().append("<attributes>").eol();
            this.raiseIndent();
            super.visitField_info(entry);
            this.lowerIndent();
            this.indent().append("</attributes>").eol();
        }
        this.lowerIndent();
        this.indent().append("</field-info>").eol();
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        this.indent().append("<method-info access-flag=\"").append(format.format(entry.getAccessFlag())).append("\">").eol();
        this.raiseIndent();
        if (entry.isPublic()) {
            this.indent().append("<public/>").eol();
        }
        if (entry.isProtected()) {
            this.indent().append("<protected/>").eol();
        }
        if (entry.isPrivate()) {
            this.indent().append("<private/>").eol();
        }
        if (entry.isStatic()) {
            this.indent().append("<static/>").eol();
        }
        if (entry.isFinal()) {
            this.indent().append("<final/>").eol();
        }
        if (entry.isSynchronized()) {
            this.indent().append("<synchronized/>").eol();
        }
        if (entry.isBridge()) {
            this.indent().append("<bridge/>").eol();
        }
        if (entry.isVarargs()) {
            this.indent().append("<varargs/>").eol();
        }
        if (entry.isNative()) {
            this.indent().append("<native/>").eol();
        }
        if (entry.isAbstract()) {
            this.indent().append("<abstract/>").eol();
        }
        if (entry.isStrict()) {
            this.indent().append("<strict/>").eol();
        }
        if (entry.isSynthetic()) {
            this.indent().append("<synthetic/>").eol();
        }
        this.indent();
        this.append("<name>");
        entry.getRawName().accept(this);
        this.append("</name>").eol();
        if (!entry.getName().equals("<init>") && !entry.getName().equals("<clinit>")) {
            this.indent().append("<return-type>").append(entry.getReturnType() != null ? entry.getReturnType() : "void").append("</return-type>").eol();
        }
        this.indent().append("<signature>").append(entry.getSignature()).append("</signature>").eol();
        if (!entry.getAttributes().isEmpty()) {
            this.indent().append("<attributes>").eol();
            this.raiseIndent();
            super.visitMethod_info(entry);
            this.lowerIndent();
            this.indent().append("</attributes>").eol();
        }
        this.lowerIndent();
        this.indent().append("</method-info>").eol();
    }

    @Override
    public void visitConstantValue_attribute(ConstantValue_attribute attribute) {
        this.indent().append("<constant-value-attribute>");
        attribute.getRawValue().accept(this);
        this.append("</constant-value-attribute>").eol();
    }

    @Override
    public void visitCode_attribute(Code_attribute attribute) {
        this.indent().append("<code-attribute>").eol();
        this.raiseIndent();
        this.indent().append("<length>").append(attribute.getCode().length).append("</length>").eol();
        this.indent().append("<instructions>").eol();
        this.raiseIndent();
        for (Instruction instruction : attribute) {
            instruction.accept(this);
        }
        this.lowerIndent();
        this.indent().append("</instructions>").eol();
        if (!attribute.getExceptionHandlers().isEmpty()) {
            this.indent().append("<exception-handlers>").eol();
            this.raiseIndent();
            for (ExceptionHandler exceptionHandler : attribute.getExceptionHandlers()) {
                exceptionHandler.accept(this);
            }
            this.lowerIndent();
            this.indent().append("</exception-handlers>").eol();
        }
        if (!attribute.getAttributes().isEmpty()) {
            this.indent().append("<attributes>").eol();
            this.raiseIndent();
            for (Attribute_info attribute_info : attribute.getAttributes()) {
                attribute_info.accept(this);
            }
            this.lowerIndent();
            this.indent().append("</attributes>").eol();
        }
        this.lowerIndent();
        this.indent().append("</code-attribute>").eol();
    }

    @Override
    public void visitExceptions_attribute(Exceptions_attribute attribute) {
        this.indent().append("<exceptions-attribute>").eol();
        this.raiseIndent();
        for (Class_info class_info : attribute.getExceptions()) {
            this.indent();
            this.append("<exception>");
            class_info.accept(this);
            this.append("</exception>").eol();
        }
        this.lowerIndent();
        this.indent().append("</exceptions-attribute>").eol();
    }

    @Override
    public void visitInnerClasses_attribute(InnerClasses_attribute attribute) {
        this.indent().append("<inner-classes-attribute>").eol();
        this.raiseIndent();
        super.visitInnerClasses_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</inner-classes-attribute>").eol();
    }

    @Override
    public void visitEnclosingMethod_attribute(EnclosingMethod_attribute attribute) {
        this.indent().append("<enclosing-method-attribute>").eol();
        this.raiseIndent();
        this.indent().append("<class>");
        attribute.getRawClassInfo().accept(this);
        this.append("</class>").eol();
        this.indent().append("<method>");
        if (attribute.getMethodIndex() != 0) {
            NameAndType_info nat = attribute.getRawMethod();
            this.append(DescriptorHelper.getReturnType(nat.getType())).append(" ").append(nat.getName()).append(DescriptorHelper.getSignature(nat.getType()));
        }
        this.append("</method>").eol();
        this.lowerIndent();
        this.indent().append("</enclosing-method-attribute>").eol();
    }

    @Override
    public void visitSynthetic_attribute(Synthetic_attribute attribute) {
        this.indent().append("<synthetic-attribute/>").eol();
    }

    @Override
    public void visitSignature_attribute(Signature_attribute attribute) {
        this.indent().append("<signature-attribute>");
        attribute.getRawSignature().accept(this);
        this.append("</signature-attribute>").eol();
    }

    @Override
    public void visitSourceFile_attribute(SourceFile_attribute attribute) {
        this.indent().append("<source-file-attribute>").append(attribute.getSourceFile()).append("</source-file-attribute>").eol();
    }

    @Override
    public void visitLineNumberTable_attribute(LineNumberTable_attribute attribute) {
        this.indent().append("<line-number-table-attribute>").eol();
        this.raiseIndent();
        super.visitLineNumberTable_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</line-number-table-attribute>").eol();
    }

    @Override
    public void visitLocalVariableTable_attribute(LocalVariableTable_attribute attribute) {
        this.indent().append("<local-variable-table-attribute>").eol();
        this.raiseIndent();
        super.visitLocalVariableTable_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</local-variable-table-attribute>").eol();
    }

    @Override
    public void visitLocalVariableTypeTable_attribute(LocalVariableTypeTable_attribute attribute) {
        this.indent().append("<local-variable-type-table-attribute>").eol();
        this.raiseIndent();
        super.visitLocalVariableTypeTable_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</local-variable-type-table-attribute>").eol();
    }

    @Override
    public void visitDeprecated_attribute(Deprecated_attribute attribute) {
        this.indent().append("<deprecated-attribute/>").eol();
    }

    @Override
    public void visitRuntimeVisibleAnnotations_attribute(RuntimeVisibleAnnotations_attribute attribute) {
        this.indent().append("<runtime-visible-annotations-attribute>").eol();
        this.raiseIndent();
        super.visitRuntimeVisibleAnnotations_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</runtime-visible-annotations-attribute>").eol();
    }

    @Override
    public void visitRuntimeInvisibleAnnotations_attribute(RuntimeInvisibleAnnotations_attribute attribute) {
        this.indent().append("<runtime-invisible-annotations-attribute>").eol();
        this.raiseIndent();
        super.visitRuntimeInvisibleAnnotations_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</runtime-invisible-annotations-attribute>").eol();
    }

    @Override
    protected void visitRuntimeAnnotations_attribute(RuntimeAnnotations_attribute attribute) {
        this.indent().append("<annotations>").eol();
        this.raiseIndent();
        super.visitRuntimeAnnotations_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</annotations>").eol();
    }

    @Override
    public void visitRuntimeVisibleParameterAnnotations_attribute(RuntimeVisibleParameterAnnotations_attribute attribute) {
        this.indent().append("<runtime-visible-parameter-annotations-attribute>").eol();
        this.raiseIndent();
        super.visitRuntimeVisibleParameterAnnotations_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</runtime-visible-parameter-annotations-attribute>").eol();
    }

    @Override
    public void visitRuntimeInvisibleParameterAnnotations_attribute(RuntimeInvisibleParameterAnnotations_attribute attribute) {
        this.indent().append("<runtime-invisible-parameter-annotations-attribute>").eol();
        this.raiseIndent();
        super.visitRuntimeInvisibleParameterAnnotations_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</runtime-invisible-parameter-annotations-attribute>").eol();
    }

    @Override
    protected void visitRuntimeParameterAnnotations_attribute(RuntimeParameterAnnotations_attribute attribute) {
        this.indent().append("<parameter-annotations>").eol();
        this.raiseIndent();
        super.visitRuntimeParameterAnnotations_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</parameter-annotations>").eol();
    }

    @Override
    public void visitAnnotationDefault_attribute(AnnotationDefault_attribute attribute) {
        this.indent().append("<annotation-default-attribute>").eol();
        this.raiseIndent();
        super.visitAnnotationDefault_attribute(attribute);
        this.lowerIndent();
        this.indent().append("</annotation-default-attribute>").eol();
    }

    @Override
    public void visitCustom_attribute(Custom_attribute attribute) {
        this.indent().append("<custom-attribute name=\"").append(this.escapeXMLCharacters(attribute.getName())).append("\">").append(Hex.toString(attribute.getInfo())).append("</custom-attribute>").eol();
    }

    @Override
    public void visitInstruction(Instruction instruction) {
        this.indent();
        this.append("<instruction pc=\"").append(instruction.getStart()).append("\" length=\"").append(instruction.getLength()).append("\"");
        switch (instruction.getOpcode()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.append(" value=\"").append(instruction.getValue()).append("\">");
                this.append(instruction);
                break;
            }
            case 16: 
            case 17: {
                this.append(" value=\"").append(instruction.getValue()).append("\">");
                this.append(instruction).append(" ").append(instruction.getValue());
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                this.append(" index=\"").append(instruction.getIndex()).append("\">");
                this.append(instruction);
                this.append(" ");
                instruction.getIndexedConstantPoolEntry().accept(this);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 169: {
                this.append(" index=\"").append(instruction.getIndex()).append("\">");
                this.append(instruction);
                this.appendLocalVariable(instruction.getIndexedLocalVariable());
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                this.append(" offset=\"").append(instruction.getOffset()).append("\">");
                this.append(instruction).append(" ").append(instruction.getStart() + instruction.getOffset());
                break;
            }
            case 132: {
                this.append(" index=\"").append(instruction.getIndex()).append("\" value=\"").append(instruction.getValue()).append("\">");
                this.append(instruction);
                this.appendLocalVariable(instruction.getIndexedLocalVariable());
                break;
            }
            case 196: {
                if (instruction.getByte(1) == 132) {
                    this.append(" index=\"").append(instruction.getIndex()).append("\" value=\"").append(instruction.getValue()).append("\">");
                } else {
                    this.append(" index=\"").append(instruction.getIndex()).append("\">");
                }
                this.append(instruction);
                this.appendLocalVariable(instruction.getIndexedLocalVariable());
                break;
            }
            default: {
                this.append(">");
                this.append(instruction);
            }
        }
        this.append("</instruction>").eol();
    }

    @Override
    public void visitExceptionHandler(ExceptionHandler helper) {
        this.indent();
        this.append("<exception-handler>");
        this.append("<start-pc>").append(helper.getStartPC()).append("</start-pc>");
        this.append("<end-pc>").append(helper.getEndPC()).append("</end-pc>");
        this.append("<handler-pc>").append(helper.getHandlerPC()).append("</handler-pc>");
        this.append("<catch-type>");
        if (helper.getCatchTypeIndex() != 0) {
            helper.getRawCatchType().accept(this);
        }
        this.append("</catch-type>");
        this.append("</exception-handler>").eol();
    }

    @Override
    public void visitInnerClass(InnerClass helper) {
        this.indent().append("<inner-class access-flag=\"").append(format.format(helper.getAccessFlag())).append("\">").eol();
        this.raiseIndent();
        if (helper.isPublic()) {
            this.indent().append("<public/>").eol();
        }
        if (helper.isProtected()) {
            this.indent().append("<protected/>").eol();
        }
        if (helper.isPrivate()) {
            this.indent().append("<private/>").eol();
        }
        if (helper.isStatic()) {
            this.indent().append("<static/>").eol();
        }
        if (helper.isFinal()) {
            this.indent().append("<final/>").eol();
        }
        if (helper.isInterface()) {
            this.indent().append("<is-interface/>").eol();
        }
        if (helper.isAbstract()) {
            this.indent().append("<abstract/>").eol();
        }
        if (helper.isSynthetic()) {
            this.indent().append("<synthetic/>").eol();
        }
        if (helper.isAnnotation()) {
            this.indent().append("<is-annotation/>").eol();
        }
        if (helper.isEnum()) {
            this.indent().append("<enum/>").eol();
        }
        this.indent();
        this.append("<inner-class-info>");
        if (helper.getInnerClassInfoIndex() != 0) {
            helper.getRawInnerClassInfo().accept(this);
        }
        this.append("</inner-class-info>").eol();
        this.indent();
        this.append("<outer-class-info>");
        if (helper.getOuterClassInfoIndex() != 0) {
            helper.getRawOuterClassInfo().accept(this);
        }
        this.append("</outer-class-info>").eol();
        this.indent();
        this.append("<inner-name>");
        if (helper.getInnerNameIndex() != 0) {
            helper.getRawInnerName().accept(this);
        }
        this.append("</inner-name>").eol();
        this.lowerIndent();
        this.indent().append("</inner-class>").eol();
    }

    @Override
    public void visitLineNumber(LineNumber helper) {
        this.indent();
        this.append("<line-number>");
        this.append("<start-pc>").append(helper.getStartPC()).append("</start-pc>");
        this.append("<line>").append(helper.getLineNumber()).append("</line>");
        this.append("</line-number>").eol();
    }

    @Override
    public void visitLocalVariable(LocalVariable helper) {
        this.indent();
        this.append("<local-variable pc=\"").append(helper.getStartPC()).append("\" length=\"").append(helper.getLength()).append("\" index=\"").append(helper.getIndex()).append("\">");
        this.append("<name>");
        helper.getRawName().accept(this);
        this.append("</name>");
        this.append("<type>").append(DescriptorHelper.getType(helper.getDescriptor())).append("</type>");
        this.append("</local-variable>").eol();
    }

    @Override
    public void visitLocalVariableType(LocalVariableType helper) {
        this.indent();
        this.append("<local-variable-type pc=\"").append(helper.getStartPC()).append("\" length=\"").append(helper.getLength()).append("\" index=\"").append(helper.getIndex()).append("\">");
        this.append("<name>");
        helper.getRawName().accept(this);
        this.append("</name>");
        this.append("<signature>");
        helper.getRawSignature().accept(this);
        this.append("</signature>");
        this.append("</local-variable-type>").eol();
    }

    @Override
    public void visitParameter(Parameter helper) {
        this.indent().append("<parameter>").eol();
        this.raiseIndent();
        this.indent().append("<annotations>").eol();
        this.raiseIndent();
        super.visitParameter(helper);
        this.lowerIndent();
        this.indent().append("</annotations>").eol();
        this.lowerIndent();
        this.indent().append("</parameter>").eol();
    }

    @Override
    public void visitAnnotation(Annotation helper) {
        this.indent().append("<annotation>").eol();
        this.raiseIndent();
        this.indent().append("<type>").append(helper.getType()).append("</type>").eol();
        this.indent().append("<element-value-pairs>").eol();
        this.raiseIndent();
        super.visitAnnotation(helper);
        this.lowerIndent();
        this.indent().append("</element-value-pairs>").eol();
        this.lowerIndent();
        this.indent().append("</annotation>").eol();
    }

    @Override
    public void visitElementValuePair(ElementValuePair helper) {
        this.indent().append("<element-value-pair>").eol();
        this.raiseIndent();
        this.indent().append("<element-name>").append(helper.getElementName()).append("</element-name>").eol();
        super.visitElementValuePair(helper);
        this.lowerIndent();
        this.indent().append("</element-value-pair>").eol();
    }

    @Override
    public void visitByteConstantElementValue(ByteConstantElementValue helper) {
        this.visitConstantElementValue(helper, "byte");
    }

    @Override
    public void visitCharConstantElementValue(CharConstantElementValue helper) {
        this.visitConstantElementValue(helper, "char");
    }

    @Override
    public void visitDoubleConstantElementValue(DoubleConstantElementValue helper) {
        this.visitConstantElementValue(helper, "double");
    }

    @Override
    public void visitFloatConstantElementValue(FloatConstantElementValue helper) {
        this.visitConstantElementValue(helper, "float");
    }

    @Override
    public void visitIntegerConstantElementValue(IntegerConstantElementValue helper) {
        this.visitConstantElementValue(helper, "integer");
    }

    @Override
    public void visitLongConstantElementValue(LongConstantElementValue helper) {
        this.visitConstantElementValue(helper, "long");
    }

    @Override
    public void visitShortConstantElementValue(ShortConstantElementValue helper) {
        this.visitConstantElementValue(helper, "short");
    }

    @Override
    public void visitBooleanConstantElementValue(BooleanConstantElementValue helper) {
        this.visitConstantElementValue(helper, "boolean");
    }

    @Override
    public void visitStringConstantElementValue(StringConstantElementValue helper) {
        this.visitConstantElementValue(helper, "string");
    }

    private void visitConstantElementValue(ConstantElementValue helper, String type) {
        this.indent();
        this.append("<").append(type).append("-element-value tag=\"").append(helper.getTag()).append("\">");
        helper.getRawConstValue().accept(this);
        this.append("</").append(type).append("-element-value>").eol();
    }

    @Override
    public void visitEnumElementValue(EnumElementValue helper) {
        this.indent();
        this.append("<enum-element-value tag=\"").append(helper.getTag()).append("\">");
        this.append(helper.getTypeName()).append(".").append(helper.getConstName());
        this.append("</enum-element-value>").eol();
    }

    @Override
    public void visitClassElementValue(ClassElementValue helper) {
        this.indent();
        this.append("<class-element-value tag=\"").append(helper.getTag()).append("\">");
        this.append(helper.getClassInfo());
        this.append("</class-element-value>").eol();
    }

    @Override
    public void visitAnnotationElementValue(AnnotationElementValue helper) {
        this.indent().append("<annotation-element-value tag=\"").append(helper.getTag()).append("\">").eol();
        this.raiseIndent();
        super.visitAnnotationElementValue(helper);
        this.lowerIndent();
        this.indent().append("</annotation-element-value>").eol();
    }

    @Override
    public void visitArrayElementValue(ArrayElementValue helper) {
        this.indent().append("<array-element-value tag=\"").append(helper.getTag()).append("\">").eol();
        this.raiseIndent();
        super.visitArrayElementValue(helper);
        this.lowerIndent();
        this.indent().append("</array-element-value>").eol();
    }

    private void appendLocalVariable(LocalVariable localVariable) {
        if (localVariable != null) {
            this.append(" ");
            this.append(DescriptorHelper.getType(localVariable.getDescriptor())).append(" ").append(localVariable.getName());
        }
    }

    @VisibleForTesting
    String escapeXMLCharacters(String text) {
        StringBuilder result = new StringBuilder();
        boolean containsControlCharacters = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                result.append("&amp;");
                continue;
            }
            if (c == '<') {
                result.append("&lt;");
                continue;
            }
            if (c == '>') {
                result.append("&gt;");
                continue;
            }
            if (Character.isISOControl(c) || c > '\u009f') {
                containsControlCharacters = true;
                result.append("&#x");
                result.append(Integer.toString(c, 16).toUpperCase());
                result.append(";");
                continue;
            }
            result.append(c);
        }
        if (containsControlCharacters) {
            return "<![CDATA[" + result.toString() + "]]>";
        }
        return result.toString();
    }
}

