/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.TraversalStrategy;
import com.jeantessier.dependency.VisitorBase;

public class LinkMinimizer
extends VisitorBase {
    public LinkMinimizer() {
        this.getStrategy().setPreOutboundTraversal(false);
        this.getStrategy().setPreInboundTraversal(false);
        this.getStrategy().setPostOutboundTraversal(false);
        this.getStrategy().setPostInboundTraversal(false);
    }

    public LinkMinimizer(TraversalStrategy strategy) {
        super(strategy);
        this.getStrategy().setPreOutboundTraversal(false);
        this.getStrategy().setPreInboundTraversal(false);
        this.getStrategy().setPostOutboundTraversal(false);
        this.getStrategy().setPostInboundTraversal(false);
    }

    @Override
    protected void postprocessPackageNode(PackageNode node) {
        this.traverseOutbound(node.getOutboundDependencies());
        super.postprocessPackageNode(node);
    }

    @Override
    protected void postprocessClassNode(ClassNode node) {
        for (Node target : this.getStrategy().order(node.getOutboundDependencies())) {
            node.getPackageNode().removeDependency(target);
            target.acceptOutbound(this);
            this.pushNode(node.getPackageNode());
            target.acceptOutbound(this);
            this.popNode();
        }
        super.postprocessClassNode(node);
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
        this.getCurrentNode().removeDependency(node.getPackageNode());
    }

    @Override
    protected void postprocessFeatureNode(FeatureNode node) {
        for (Node target : this.getStrategy().order(node.getOutboundDependencies())) {
            node.getClassNode().removeDependency(target);
            node.getClassNode().getPackageNode().removeDependency(target);
            target.acceptOutbound(this);
            this.pushNode(node.getClassNode());
            target.acceptOutbound(this);
            this.popNode();
            this.pushNode(node.getClassNode().getPackageNode());
            target.acceptOutbound(this);
            this.popNode();
        }
        super.postprocessFeatureNode(node);
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
        this.getCurrentNode().removeDependency(node.getClassNode());
        this.getCurrentNode().removeDependency(node.getClassNode().getPackageNode());
    }
}

