/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.text.Hex;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassDump {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println(ClassDump.class.getName() + ":");
            ClassDump.dumpClass(ClassDump.class);
        } else {
            for (String arg : args) {
                System.out.println(arg + ":");
                ClassDump.dumpClass(arg);
            }
        }
    }

    public static void dumpClass(String classname) throws ClassNotFoundException {
        ClassDump.dumpClass(Class.forName(classname));
    }

    public static void dumpClass(Class c) {
        String resource = c.getSimpleName() + ".class";
        System.out.println(resource + " -> " + c.getResource(resource));
        ClassDump.dumpClass(c.getResourceAsStream(resource));
    }

    public static void dumpClass(InputStream in) {
        ClassDump.dumpClass(new DataInputStream(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpClass(DataInput in) {
        int count = 0;
        try {
            try {
                while (true) {
                    byte b = in.readByte();
                    Hex.print(System.out, b);
                    if (++count % 4 == 0) {
                        System.out.print(' ');
                    }
                    if (count % 32 != 0) continue;
                    System.out.println();
                    count = 0;
                }
            }
            catch (IOException iOException) {
                System.out.println();
            }
        }
        catch (Throwable throwable) {
            System.out.println();
            throw throwable;
        }
    }
}

