/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependencyfinder.cli.Command;
import com.jeantessier.diff.APIDifferenceStrategy;
import com.jeantessier.diff.CodeDifferenceStrategy;
import com.jeantessier.diff.DifferenceStrategy;
import com.jeantessier.diff.DifferencesFactory;
import com.jeantessier.diff.IncompatibleDifferenceStrategy;
import com.jeantessier.diff.ListBasedDifferenceStrategy;
import com.jeantessier.diff.NoDifferenceStrategy;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.log4j.Logger;

public abstract class DiffCommand
extends Command {
    public static final String API_STRATEGY = "api";
    public static final String INCOMPATIBLE_STRATEGY = "incompatible";
    public static final String DEFAULT_LEVEL = "api";

    @Override
    protected void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("Defaults is text output to the console.");
        out.println();
    }

    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd", "    ");
        this.getCommandLine().addSingleValueSwitch("name");
        this.getCommandLine().addMultipleValuesSwitch("old", true);
        this.getCommandLine().addSingleValueSwitch("old-label");
        this.getCommandLine().addMultipleValuesSwitch("new", true);
        this.getCommandLine().addSingleValueSwitch("new-label");
        this.getCommandLine().addSingleValueSwitch("filter");
        this.getCommandLine().addToggleSwitch("code");
        this.getCommandLine().addSingleValueSwitch("level", "api");
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        if (!this.getCommandLine().isPresent("old-label")) {
            this.getCommandLine().getSwitch("old-label").setValue(this.getCommandLine().getMultipleSwitch("old").toString());
        }
        if (!this.getCommandLine().isPresent("new-label")) {
            this.getCommandLine().getSwitch("new-label").setValue(this.getCommandLine().getMultipleSwitch("new").toString());
        }
        return exceptions;
    }

    protected DifferencesFactory getDifferencesFactory() throws IOException {
        DifferenceStrategy baseStrategy = this.getBaseStrategy(this.getCommandLine().getToggleSwitch("code"));
        DifferenceStrategy strategy = this.getStrategy(this.getCommandLine().getSingleSwitch("level"), baseStrategy);
        if (this.getCommandLine().isPresent("filter")) {
            strategy = new ListBasedDifferenceStrategy(strategy, this.getCommandLine().getSingleSwitch("filter"));
        }
        return new DifferencesFactory(strategy);
    }

    private DifferenceStrategy getBaseStrategy(boolean useCode) {
        DifferenceStrategy result = useCode ? new CodeDifferenceStrategy() : new NoDifferenceStrategy();
        return result;
    }

    private DifferenceStrategy getStrategy(String level, DifferenceStrategy baseStrategy) {
        DifferenceStrategy result;
        if ("api".equals(level)) {
            result = new APIDifferenceStrategy(baseStrategy);
        } else if (INCOMPATIBLE_STRATEGY.equals(level)) {
            result = new IncompatibleDifferenceStrategy(baseStrategy);
        } else {
            try {
                try {
                    Constructor<?> constructor = Class.forName(level).getConstructor(DifferenceStrategy.class);
                    result = (DifferenceStrategy)constructor.newInstance(baseStrategy);
                }
                catch (NoSuchMethodException ex) {
                    result = (DifferenceStrategy)Class.forName(level).newInstance();
                }
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unknown level \"" + level + "\", using default level \"" + "api" + "\""), (Throwable)ex);
                result = this.getDefaultStrategy(baseStrategy);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unknown level \"" + level + "\", using default level \"" + "api" + "\""), (Throwable)ex);
                result = this.getDefaultStrategy(baseStrategy);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unknown level \"" + level + "\", using default level \"" + "api" + "\""), (Throwable)ex);
                result = this.getDefaultStrategy(baseStrategy);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unknown level \"" + level + "\", using default level \"" + "api" + "\""), (Throwable)ex);
                result = this.getDefaultStrategy(baseStrategy);
            }
            catch (ClassCastException ex) {
                Logger.getLogger(this.getClass()).error((Object)("Unknown level \"" + level + "\", using default level \"" + "api" + "\""), (Throwable)ex);
                result = this.getDefaultStrategy(baseStrategy);
            }
        }
        return result;
    }

    private DifferenceStrategy getDefaultStrategy(DifferenceStrategy strategy) {
        return new APIDifferenceStrategy(strategy);
    }
}

