/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.ClassNameHelper;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.DescriptorHelper;
import com.jeantessier.classreader.ExceptionHandler;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.LineNumber;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.VisitorBase;
import com.jeantessier.metrics.BasicMeasurements;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.MetricsEvent;
import com.jeantessier.metrics.MetricsFactory;
import com.jeantessier.metrics.MetricsListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class MetricsGatherer
extends VisitorBase {
    private static final Perl5Util perl = new Perl5Util();
    private MetricsFactory factory;
    private Collection<String> scope = null;
    private Collection<String> filter = null;
    private Metrics currentProject;
    private Metrics currentGroup;
    private Metrics currentClass;
    private Metrics currentMethod;
    private int sloc;
    private boolean isSynthetic;
    private HashSet<MetricsListener> metricsListeners = new HashSet();

    public MetricsGatherer(MetricsFactory factory) {
        this.factory = factory;
        this.setCurrentProject(this.getMetricsFactory().createProjectMetrics());
    }

    public MetricsFactory getMetricsFactory() {
        return this.factory;
    }

    public void setScopeIncludes(Collection<String> scope) {
        this.scope = scope;
    }

    public void setFilterIncludes(Collection<String> filter) {
        this.filter = filter;
    }

    private Metrics getCurrentProject() {
        return this.currentProject;
    }

    void setCurrentProject(Metrics currentProject) {
        this.currentProject = currentProject;
    }

    private Metrics getCurrentGroup() {
        return this.currentGroup;
    }

    void setCurrentGroup(Metrics currentGroup) {
        this.currentGroup = currentGroup;
    }

    private Metrics getCurrentClass() {
        return this.currentClass;
    }

    void setCurrentClass(Metrics currentClass) {
        this.currentClass = currentClass;
    }

    private Metrics getCurrentMethod() {
        return this.currentMethod;
    }

    void setCurrentMethod(Metrics currentMethod) {
        this.currentMethod = currentMethod;
    }

    @Override
    public void visitClassfiles(Collection<Classfile> classfiles) {
        this.fireBeginSession(classfiles.size());
        super.visitClassfiles(classfiles);
        this.fireEndSession();
    }

    @Override
    public void visitClassfile(Classfile classfile) {
        String className = classfile.getClassName();
        Logger.getLogger(this.getClass()).debug((Object)"VisitClassfile():");
        Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + className + "\""));
        this.fireBeginClass(classfile);
        this.setCurrentMethod(null);
        this.setCurrentClass(this.getMetricsFactory().createClassMetrics(className));
        this.setCurrentGroup(this.getCurrentClass().getParent());
        this.setCurrentProject(this.getCurrentGroup().getParent());
        this.getMetricsFactory().includeClassMetrics(this.getCurrentClass());
        this.getCurrentProject().addToMeasurement(BasicMeasurements.PACKAGES, (Object)this.getCurrentGroup().getName());
        if (classfile.isPublic()) {
            this.getCurrentProject().addToMeasurement(BasicMeasurements.PUBLIC_CLASSES, (Object)className);
            this.getCurrentGroup().addToMeasurement(BasicMeasurements.PUBLIC_CLASSES, (Object)className);
        } else {
            this.getCurrentProject().addToMeasurement(BasicMeasurements.PACKAGE_CLASSES, (Object)className);
            this.getCurrentGroup().addToMeasurement(BasicMeasurements.PACKAGE_CLASSES, (Object)className);
        }
        if (classfile.isFinal()) {
            this.getCurrentProject().addToMeasurement(BasicMeasurements.FINAL_CLASSES, (Object)className);
            this.getCurrentGroup().addToMeasurement(BasicMeasurements.FINAL_CLASSES, (Object)className);
        }
        if (classfile.isSuper()) {
            this.getCurrentProject().addToMeasurement(BasicMeasurements.SUPER_CLASSES, (Object)className);
            this.getCurrentGroup().addToMeasurement(BasicMeasurements.SUPER_CLASSES, (Object)className);
        }
        if (classfile.isInterface()) {
            this.getCurrentProject().addToMeasurement(BasicMeasurements.INTERFACES, (Object)className);
            this.getCurrentGroup().addToMeasurement(BasicMeasurements.INTERFACES, (Object)className);
        }
        if (classfile.isAbstract()) {
            this.getCurrentProject().addToMeasurement(BasicMeasurements.ABSTRACT_CLASSES, (Object)className);
            this.getCurrentGroup().addToMeasurement(BasicMeasurements.ABSTRACT_CLASSES, (Object)className);
        }
        if (classfile.isSynthetic()) {
            this.getCurrentProject().addToMeasurement(BasicMeasurements.SYNTHETIC_CLASSES, (Object)className);
            this.getCurrentGroup().addToMeasurement(BasicMeasurements.SYNTHETIC_CLASSES, (Object)className);
        }
        if (classfile.getSuperclassIndex() != 0) {
            classfile.getRawSuperclass().accept(this);
            this.getMetricsFactory().createClassMetrics(classfile.getSuperclassName()).addToMeasurement(BasicMeasurements.SUBCLASSES);
            Classfile superclass = classfile.getLoader().getClassfile(classfile.getSuperclassName());
            if (superclass != null) {
                this.getCurrentClass().addToMeasurement(BasicMeasurements.DEPTH_OF_INHERITANCE, this.computeDepthOfInheritance(superclass));
            }
        }
        for (Class_info class_info : classfile.getAllInterfaces()) {
            class_info.accept(this);
        }
        for (Field_info field_info : classfile.getAllFields()) {
            field_info.accept(this);
        }
        for (Method_info method_info : classfile.getAllMethods()) {
            method_info.accept(this);
        }
        this.sloc = 1;
        for (Attribute_info attribute_info : classfile.getAttributes()) {
            attribute_info.accept(this);
        }
        if (!classfile.isSynthetic()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.CLASS_SLOC, this.sloc);
        }
        this.fireEndClass(classfile, this.getCurrentClass());
    }

    @Override
    public void visitClass_info(Class_info entry) {
        Logger.getLogger(this.getClass()).debug((Object)"VisitClass_info():");
        Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getName() + "\""));
        if (entry.getName().startsWith("[")) {
            this.addClassDependencies(this.processDescriptor(entry.getName()));
        } else {
            this.addClassDependency(entry.getName());
        }
    }

    @Override
    public void visitFieldRef_info(FieldRef_info entry) {
        Logger.getLogger(this.getClass()).debug((Object)"VisitFieldRef_info():");
        Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + entry.getClassName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getRawNameAndType().getName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    type = \"" + entry.getRawNameAndType().getType() + "\""));
        entry.getRawClass().accept(this);
        this.addClassDependencies(this.processDescriptor(entry.getRawNameAndType().getType()));
    }

    @Override
    public void visitMethodRef_info(MethodRef_info entry) {
        Logger.getLogger(this.getClass()).debug((Object)"VisitMethodRef_info():");
        Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + entry.getClassName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getRawNameAndType().getName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    type = \"" + entry.getRawNameAndType().getType() + "\""));
        this.addMethodDependency(entry.getFullSignature());
        this.addClassDependencies(this.processDescriptor(entry.getRawNameAndType().getType()));
    }

    @Override
    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
        Logger.getLogger(this.getClass()).debug((Object)"VisitInterfaceMethodRef_info():");
        Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + entry.getClassName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getRawNameAndType().getName() + "\""));
        Logger.getLogger(this.getClass()).debug((Object)("    type = \"" + entry.getRawNameAndType().getType() + "\""));
        this.addMethodDependency(entry.getFullSignature());
        this.addClassDependencies(this.processDescriptor(entry.getRawNameAndType().getType()));
    }

    @Override
    public void visitField_info(Field_info entry) {
        String fullName = entry.getFullName();
        this.getCurrentClass().addToMeasurement(BasicMeasurements.ATTRIBUTES, (Object)fullName);
        Logger.getLogger(this.getClass()).debug((Object)("VisitField_info(" + entry.getFullSignature() + ")"));
        Logger.getLogger(this.getClass()).debug((Object)("Current class: " + this.getCurrentClass().getName()));
        Logger.getLogger(this.getClass()).debug((Object)("Access flag: " + entry.getAccessFlag()));
        Logger.getLogger(this.getClass()).debug((Object)("Public: " + entry.isPublic()));
        Logger.getLogger(this.getClass()).debug((Object)("Private: " + entry.isPrivate()));
        Logger.getLogger(this.getClass()).debug((Object)("Protected: " + entry.isProtected()));
        Logger.getLogger(this.getClass()).debug((Object)("Static: " + entry.isStatic()));
        if (entry.isPublic()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.PUBLIC_ATTRIBUTES, (Object)fullName);
        } else if (entry.isPrivate()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.PRIVATE_ATTRIBUTES, (Object)fullName);
        } else if (entry.isProtected()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.PROTECTED_ATTRIBUTES, (Object)fullName);
        } else {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.PACKAGE_ATTRIBUTES, (Object)fullName);
        }
        if (entry.isStatic()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.STATIC_ATTRIBUTES, (Object)fullName);
        }
        if (entry.isFinal()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.FINAL_ATTRIBUTES, (Object)fullName);
        }
        if (entry.isVolatile()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.VOLATILE_ATTRIBUTES, (Object)fullName);
        }
        if (entry.isTransient()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.TRANSIENT_ATTRIBUTES, (Object)fullName);
        }
        this.sloc = 1;
        this.isSynthetic = entry.isSynthetic();
        super.visitField_info(entry);
        if (!this.isSynthetic) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.CLASS_SLOC, this.sloc);
        }
        this.addClassDependencies(this.processDescriptor(entry.getDescriptor()));
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        this.fireBeginMethod(entry);
        String fullSignature = entry.getFullSignature();
        this.setCurrentMethod(this.getMetricsFactory().createMethodMetrics(fullSignature));
        this.getMetricsFactory().includeMethodMetrics(this.getCurrentMethod());
        Logger.getLogger(this.getClass()).debug((Object)("VisitMethod_info(" + fullSignature + ")"));
        Logger.getLogger(this.getClass()).debug((Object)("Current class: " + this.getCurrentClass().getName()));
        Logger.getLogger(this.getClass()).debug((Object)("Access flag: " + entry.getAccessFlag()));
        Logger.getLogger(this.getClass()).debug((Object)("Public: " + entry.isPublic()));
        Logger.getLogger(this.getClass()).debug((Object)("Private: " + entry.isPrivate()));
        Logger.getLogger(this.getClass()).debug((Object)("Protected: " + entry.isProtected()));
        Logger.getLogger(this.getClass()).debug((Object)("Static: " + entry.isStatic()));
        this.sloc = 0;
        this.isSynthetic = entry.isSynthetic();
        if (entry.isPublic()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.PUBLIC_METHODS, (Object)fullSignature);
        } else if (entry.isPrivate()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.PRIVATE_METHODS, (Object)fullSignature);
        } else if (entry.isProtected()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.PROTECTED_METHODS, (Object)fullSignature);
        } else {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.PACKAGE_METHODS, (Object)fullSignature);
        }
        if (entry.isStatic()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.STATIC_METHODS, (Object)fullSignature);
        }
        if (entry.isFinal()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.FINAL_METHODS, (Object)fullSignature);
        }
        if (entry.isSynchronized()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.SYNCHRONIZED_METHODS, (Object)fullSignature);
        }
        if (entry.isNative()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.NATIVE_METHODS, (Object)fullSignature);
        }
        if (entry.isAbstract()) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.ABSTRACT_METHODS, (Object)fullSignature);
            this.sloc = 1;
        }
        this.getCurrentMethod().addToMeasurement(BasicMeasurements.PARAMETERS, DescriptorHelper.getParameterCount(entry.getDescriptor()));
        super.visitMethod_info(entry);
        if (!this.isSynthetic) {
            this.getCurrentMethod().addToMeasurement(BasicMeasurements.SLOC, this.sloc);
        }
        this.addClassDependencies(this.processDescriptor(entry.getDescriptor()));
        this.fireEndMethod(entry, this.getCurrentMethod());
    }

    @Override
    public void visitSynthetic_attribute(Synthetic_attribute attribute) {
        Visitable owner = attribute.getOwner();
        this.isSynthetic = true;
        if (owner instanceof Field_info) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.SYNTHETIC_ATTRIBUTES, (Object)((Field_info)owner).getFullName());
        } else if (owner instanceof Method_info) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.SYNTHETIC_METHODS, (Object)((Method_info)owner).getFullSignature());
        } else {
            Logger.getLogger(this.getClass()).warn((Object)("Synthetic attribute on unknown Visitable: " + owner.getClass().getName()));
        }
    }

    @Override
    public void visitDeprecated_attribute(Deprecated_attribute attribute) {
        Visitable owner = attribute.getOwner();
        if (owner instanceof Classfile) {
            String className = ((Classfile)owner).getClassName();
            this.getCurrentProject().addToMeasurement(BasicMeasurements.DEPRECATED_CLASSES, (Object)className);
            this.getCurrentGroup().addToMeasurement(BasicMeasurements.DEPRECATED_CLASSES, (Object)className);
        } else if (owner instanceof Field_info) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.DEPRECATED_ATTRIBUTES, (Object)((Field_info)owner).getFullName());
        } else if (owner instanceof Method_info) {
            this.getCurrentClass().addToMeasurement(BasicMeasurements.DEPRECATED_METHODS, (Object)((Method_info)owner).getFullSignature());
        } else {
            Logger.getLogger(this.getClass()).warn((Object)("Deprecated attribute on unknown Visitable: " + owner.getClass().getName()));
        }
    }

    @Override
    public void visitInstruction(Instruction helper) {
        super.visitInstruction(helper);
        switch (helper.getOpcode()) {
            case 18: 
            case 19: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                helper.getIndexedConstantPoolEntry().accept(this);
                break;
            }
        }
    }

    @Override
    public void visitExceptionHandler(ExceptionHandler helper) {
        if (helper.getCatchTypeIndex() != 0) {
            helper.getRawCatchType().accept(this);
        }
    }

    @Override
    public void visitInnerClass(InnerClass helper) {
        if (this.isInnerClassOfCurrentClass(helper)) {
            String innerClassName = helper.getInnerClassInfo();
            this.getCurrentProject().addToMeasurement(BasicMeasurements.INNER_CLASSES, (Object)innerClassName);
            this.getCurrentGroup().addToMeasurement(BasicMeasurements.INNER_CLASSES, (Object)innerClassName);
            this.getCurrentClass().addToMeasurement(BasicMeasurements.INNER_CLASSES, (Object)innerClassName);
            if (helper.isPublic()) {
                this.getCurrentProject().addToMeasurement(BasicMeasurements.PUBLIC_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentGroup().addToMeasurement(BasicMeasurements.PUBLIC_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentClass().addToMeasurement(BasicMeasurements.PUBLIC_INNER_CLASSES, (Object)innerClassName);
            } else if (helper.isPrivate()) {
                this.getCurrentProject().addToMeasurement(BasicMeasurements.PRIVATE_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentGroup().addToMeasurement(BasicMeasurements.PRIVATE_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentClass().addToMeasurement(BasicMeasurements.PRIVATE_INNER_CLASSES, (Object)innerClassName);
            } else if (helper.isProtected()) {
                this.getCurrentProject().addToMeasurement(BasicMeasurements.PROTECTED_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentGroup().addToMeasurement(BasicMeasurements.PROTECTED_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentClass().addToMeasurement(BasicMeasurements.PROTECTED_INNER_CLASSES, (Object)innerClassName);
            } else {
                this.getCurrentProject().addToMeasurement(BasicMeasurements.PACKAGE_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentGroup().addToMeasurement(BasicMeasurements.PACKAGE_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentClass().addToMeasurement(BasicMeasurements.PACKAGE_INNER_CLASSES, (Object)innerClassName);
            }
            if (helper.isStatic()) {
                this.getCurrentProject().addToMeasurement(BasicMeasurements.STATIC_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentGroup().addToMeasurement(BasicMeasurements.STATIC_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentClass().addToMeasurement(BasicMeasurements.STATIC_INNER_CLASSES, (Object)innerClassName);
            }
            if (helper.isFinal()) {
                this.getCurrentProject().addToMeasurement(BasicMeasurements.FINAL_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentGroup().addToMeasurement(BasicMeasurements.FINAL_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentClass().addToMeasurement(BasicMeasurements.FINAL_INNER_CLASSES, (Object)innerClassName);
            }
            if (helper.isAbstract()) {
                this.getCurrentProject().addToMeasurement(BasicMeasurements.ABSTRACT_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentGroup().addToMeasurement(BasicMeasurements.ABSTRACT_INNER_CLASSES, (Object)innerClassName);
                this.getCurrentClass().addToMeasurement(BasicMeasurements.ABSTRACT_INNER_CLASSES, (Object)innerClassName);
            }
        }
    }

    boolean isInnerClassOfCurrentClass(InnerClass helper) {
        boolean result = helper.getOuterClassInfo().equals("") ? perl.match("/^" + this.getCurrentClass().getName() + "\\$\\d+$/", helper.getInnerClassInfo()) : helper.getOuterClassInfo().equals(this.getCurrentClass().getName());
        return result;
    }

    @Override
    public void visitLineNumber(LineNumber helper) {
        ++this.sloc;
    }

    @Override
    public void visitLocalVariable(LocalVariable helper) {
        this.getCurrentMethod().addToMeasurement(BasicMeasurements.LOCAL_VARIABLES, (Object)helper.getName());
        this.addClassDependencies(this.processDescriptor(helper.getDescriptor()));
    }

    private int computeDepthOfInheritance(Classfile classfile) {
        int result = 1;
        if (classfile != null && classfile.getSuperclassIndex() != 0) {
            Classfile superclass = classfile.getLoader().getClassfile(classfile.getSuperclassName());
            result += this.computeDepthOfInheritance(superclass);
        }
        return result;
    }

    private Collection<String> processDescriptor(String str) {
        int startPos;
        LinkedList<String> result = new LinkedList<String>();
        Logger.getLogger(this.getClass()).debug((Object)("ProcessDescriptor: " + str));
        int currentPos = 0;
        while ((startPos = str.indexOf(76, currentPos)) != -1) {
            int endPos = str.indexOf(59, startPos);
            if (endPos != -1) {
                String classname = ClassNameHelper.path2ClassName(str.substring(startPos + 1, endPos));
                result.add(classname);
                currentPos = endPos + 1;
                continue;
            }
            currentPos = startPos + 1;
        }
        Logger.getLogger(this.getClass()).debug((Object)("ProcessDescriptor: " + result));
        return result;
    }

    private void addClassDependencies(Collection<String> classnames) {
        for (String classname : classnames) {
            this.addClassDependency(classname);
        }
    }

    private void addClassDependency(String name) {
        Logger.getLogger(this.getClass()).debug((Object)("AddClassDependency(\"" + name + "\") ..."));
        if (!this.getCurrentClass().getName().equals(name) && this.isInFilter(name)) {
            Metrics other = this.getMetricsFactory().createClassMetrics(name);
            if (this.getCurrentMethod() != null && this.isInScope(this.getCurrentMethod().getName())) {
                Logger.getLogger(this.getClass()).debug((Object)("AddClassDependency " + this.getCurrentMethod().getName() + " -> " + name + " ..."));
                if (this.getCurrentClass().getParent().equals(other.getParent())) {
                    Logger.getLogger(this.getClass()).debug((Object)"Intra-Package ...");
                    this.getCurrentMethod().addToMeasurement(BasicMeasurements.OUTBOUND_INTRA_PACKAGE_CLASS_DEPENDENCIES, (Object)other.getName());
                    other.addToMeasurement(BasicMeasurements.INBOUND_INTRA_PACKAGE_METHOD_DEPENDENCIES, (Object)this.getCurrentMethod().getName());
                } else {
                    Logger.getLogger(this.getClass()).debug((Object)"Extra-Package ...");
                    this.getCurrentMethod().addToMeasurement(BasicMeasurements.OUTBOUND_EXTRA_PACKAGE_CLASS_DEPENDENCIES, (Object)other.getName());
                    other.addToMeasurement(BasicMeasurements.INBOUND_EXTRA_PACKAGE_METHOD_DEPENDENCIES, (Object)this.getCurrentMethod().getName());
                }
            } else if (this.isInScope(this.getCurrentClass().getName())) {
                Logger.getLogger(this.getClass()).debug((Object)("AddClassDependency " + this.getCurrentClass().getName() + " -> " + name + " ..."));
                if (this.getCurrentClass().getParent().equals(other.getParent())) {
                    Logger.getLogger(this.getClass()).debug((Object)"Intra-Package ...");
                    this.getCurrentClass().addToMeasurement(BasicMeasurements.OUTBOUND_INTRA_PACKAGE_DEPENDENCIES, (Object)other.getName());
                    other.addToMeasurement(BasicMeasurements.INBOUND_INTRA_PACKAGE_DEPENDENCIES, (Object)this.getCurrentClass().getName());
                } else {
                    Logger.getLogger(this.getClass()).debug((Object)"Extra-Package ...");
                    this.getCurrentClass().addToMeasurement(BasicMeasurements.OUTBOUND_EXTRA_PACKAGE_DEPENDENCIES, (Object)other.getName());
                    other.addToMeasurement(BasicMeasurements.INBOUND_EXTRA_PACKAGE_DEPENDENCIES, (Object)this.getCurrentClass().getName());
                }
            }
        }
    }

    private void addMethodDependency(String name) {
        Logger.getLogger(this.getClass()).debug((Object)("AddMethodDependency " + this.getCurrentMethod().getName() + " -> " + name + " ..."));
        if (!this.getCurrentMethod().getName().equals(name) && this.isInScope(this.getCurrentMethod().getName()) && this.isInFilter(name)) {
            Metrics other = this.getMetricsFactory().createMethodMetrics(name);
            if (this.getCurrentClass().equals(other.getParent())) {
                Logger.getLogger(this.getClass()).debug((Object)"Intra-Class ...");
                this.getCurrentMethod().addToMeasurement(BasicMeasurements.OUTBOUND_INTRA_CLASS_FEATURE_DEPENDENCIES, (Object)other.getName());
                other.addToMeasurement(BasicMeasurements.INBOUND_INTRA_CLASS_METHOD_DEPENDENCIES, (Object)this.getCurrentMethod().getName());
            } else if (this.getCurrentGroup().equals(other.getParent().getParent())) {
                Logger.getLogger(this.getClass()).debug((Object)"Intra-Package ...");
                this.getCurrentMethod().addToMeasurement(BasicMeasurements.OUTBOUND_INTRA_PACKAGE_FEATURE_DEPENDENCIES, (Object)other.getName());
                other.addToMeasurement(BasicMeasurements.INBOUND_INTRA_PACKAGE_METHOD_DEPENDENCIES, (Object)this.getCurrentMethod().getName());
            } else {
                Logger.getLogger(this.getClass()).debug((Object)"Extra-Package ...");
                this.getCurrentMethod().addToMeasurement(BasicMeasurements.OUTBOUND_EXTRA_PACKAGE_FEATURE_DEPENDENCIES, (Object)other.getName());
                other.addToMeasurement(BasicMeasurements.INBOUND_EXTRA_PACKAGE_METHOD_DEPENDENCIES, (Object)this.getCurrentMethod().getName());
            }
        }
    }

    private boolean isInScope(String name) {
        boolean result = true;
        if (this.scope != null) {
            result = this.scope.contains(name);
        }
        return result;
    }

    private boolean isInFilter(String name) {
        boolean result = true;
        if (this.filter != null) {
            result = this.filter.contains(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetricsListener(MetricsListener listener) {
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            this.metricsListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetricsListener(MetricsListener listener) {
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            this.metricsListeners.remove(listener);
        }
    }

    protected void fireBeginSession(int size) {
        MetricsEvent event = new MetricsEvent((Object)this, size);
        for (MetricsListener listener : this.cloneListeners()) {
            listener.beginSession(event);
        }
    }

    protected void fireBeginClass(Classfile classfile) {
        MetricsEvent event = new MetricsEvent((Object)this, classfile);
        for (MetricsListener listener : this.cloneListeners()) {
            listener.beginClass(event);
        }
    }

    protected void fireBeginMethod(Method_info method) {
        MetricsEvent event = new MetricsEvent((Object)this, method);
        for (MetricsListener listener : this.cloneListeners()) {
            listener.beginMethod(event);
        }
    }

    protected void fireEndMethod(Method_info method, Metrics metrics) {
        MetricsEvent event = new MetricsEvent((Object)this, method, metrics);
        for (MetricsListener listener : this.cloneListeners()) {
            listener.endMethod(event);
        }
    }

    protected void fireEndClass(Classfile classfile, Metrics metrics) {
        MetricsEvent event = new MetricsEvent((Object)this, classfile, metrics);
        for (MetricsListener listener : this.cloneListeners()) {
            listener.endClass(event);
        }
    }

    protected void fireEndSession() {
        MetricsEvent event = new MetricsEvent(this);
        for (MetricsListener listener : this.cloneListeners()) {
            listener.endSession(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<MetricsListener> cloneListeners() {
        Collection result;
        HashSet<MetricsListener> hashSet = this.metricsListeners;
        synchronized (hashSet) {
            result = (Collection)this.metricsListeners.clone();
        }
        return result;
    }
}

