/*
 * Copyright (c) 2010-2014, Kazuhiko Kobayashi
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

package projectkyoto.mmd.file;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author Kazuhiko Kobayashi
 */
public class XColorRGB implements Serializable{
    private float red;
    private float green;
    private float blue;

    public XColorRGB() {
    }

    public XColorRGB(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }
    public float getBlue() {
        return blue;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public float getGreen() {
        return green;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public float getRed() {
        return red;
    }

    public void setRed(float red) {
        this.red = red;
    }
    public XColorRGB(DataInputStreamLittleEndian is) throws IOException{
        red = is.readFloat();
        green = is.readFloat();
        blue = is.readFloat();
    }
    public void writeToStream(DataOutput os) throws IOException {
        os.writeFloat(red);
        os.writeFloat(green);
        os.writeFloat(blue);
    }
    @Override
    public String toString() {
        return "{red = "+red
                +" green = "+green
                +" blue = "+green
                +"}";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final XColorRGB other = (XColorRGB) obj;
        if (Float.floatToIntBits(this.red) != Float.floatToIntBits(other.red)) {
            return false;
        }
        if (Float.floatToIntBits(this.green) != Float.floatToIntBits(other.green)) {
            return false;
        }
        if (Float.floatToIntBits(this.blue) != Float.floatToIntBits(other.blue)) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Float.floatToIntBits(this.red);
        hash = 41 * hash + Float.floatToIntBits(this.green);
        hash = 41 * hash + Float.floatToIntBits(this.blue);
        return hash;
    }
}
