/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.jme3.gde.angelfont;

import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public final class AngelFontVisualPanel2 extends JPanel {

    String fontName = "";
    int fontSize = 16;
    int imageSize = 256;
    int style = Font.PLAIN;

    /** Creates new form AngelFontVisualPanel2 */
    public AngelFontVisualPanel2() {
        initComponents();
        jComboBox1.removeAllItems();
        jComboBox1.addItem("PLAIN");
        jComboBox1.addItem("ITALIC");
        jComboBox1.addItem("BOLD");
    }

    @Override
    public String getName() {
        return "Configure Font";
    }

    public void setFont(String name) {
        this.fontName = name;
        updateFont();
    }

    private void updateFont() {
        jLabel3.setIcon(new ImageIcon(FontCreator.buildFont(fontName, imageSize, fontSize, style, true).getImage()));
        jLabel3.repaint();
        jPanel1.repaint();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jToolBar1 = new javax.swing.JToolBar();
        jComboBox1 = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jSpinner1 = new javax.swing.JSpinner();
        jLabel2 = new javax.swing.JLabel();
        jSpinner2 = new javax.swing.JSpinner();

        jPanel1.setBackground(new java.awt.Color(0, 0, 0));
        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.LINE_AXIS));

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(AngelFontVisualPanel2.class, "AngelFontVisualPanel2.jLabel3.text")); // NOI18N
        jPanel1.add(jLabel3);

        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });
        jToolBar1.add(jComboBox1);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(AngelFontVisualPanel2.class, "AngelFontVisualPanel2.jLabel1.text")); // NOI18N
        jToolBar1.add(jLabel1);

        jSpinner1.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(16), Integer.valueOf(1), null, Integer.valueOf(1)));
        jSpinner1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                updateFontSize(evt);
            }
        });
        jToolBar1.add(jSpinner1);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(AngelFontVisualPanel2.class, "AngelFontVisualPanel2.jLabel2.text")); // NOI18N
        jToolBar1.add(jLabel2);

        jSpinner2.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(256), Integer.valueOf(64), null, Integer.valueOf(1)));
        jSpinner2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                updateImageSize(evt);
            }
        });
        jToolBar1.add(jSpinner2);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 441, Short.MAX_VALUE)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 441, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 307, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void updateFontSize(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_updateFontSize
        fontSize = (Integer) jSpinner1.getValue();
        updateFont();
    }//GEN-LAST:event_updateFontSize

    private void updateImageSize(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_updateImageSize
        imageSize = (Integer) jSpinner2.getValue();
        updateFont();
    }//GEN-LAST:event_updateImageSize

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        if ("PLAIN".equals(jComboBox1.getSelectedItem())) {
            style = Font.PLAIN;
        } else if ("BOLD".equals(jComboBox1.getSelectedItem())) {
            style = Font.BOLD;
        } else if ("ITALIC".equals(jComboBox1.getSelectedItem())) {
            style = Font.ITALIC;
        }
        updateFont();
    }//GEN-LAST:event_jComboBox1ActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSpinner jSpinner1;
    private javax.swing.JSpinner jSpinner2;
    private javax.swing.JToolBar jToolBar1;
    // End of variables declaration//GEN-END:variables
}
