/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dragndrop.controller;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyMethodInvoker;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.NiftyInputControl;
import de.lessvoid.nifty.controls.dragndrop.controller.DraggableControl;
import de.lessvoid.nifty.controls.dragndrop.controller.DropFilter;
import de.lessvoid.nifty.controls.dragndrop.controller.DropNotify;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public class DroppableControl
implements Controller {
    private Nifty nifty;
    private Screen screen;
    private List<DropNotify> notifies = new CopyOnWriteArrayList<DropNotify>();
    private List<DropFilter> filters = new CopyOnWriteArrayList<DropFilter>();
    private Element droppable;
    private DraggableControl draggable;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, ControllerEventListener listener, Attributes controlDefinitionAttributes) {
        this.nifty = nifty;
        this.screen = screen;
        this.droppable = element;
        this.addOnDropMethodNotify(controlDefinitionAttributes.get("onDrop"));
    }

    private void addOnDropMethodNotify(String methodName) {
        if (methodName != null) {
            this.addNotify(new OnDropMethodNotify(methodName));
        }
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void onFocus(boolean getFocus) {
    }

    public void onStartScreen() {
        this.draggable = this.findDraggableChild(this.droppable);
        if (this.draggable != null) {
            this.drop(this.draggable, this.reactivate(this.draggable.getElement()), false);
        }
    }

    private EndNotify reactivate(final Element element) {
        return new EndNotify(){

            public void perform() {
                element.reactivate();
            }
        };
    }

    private DraggableControl findDraggableChild(Element element) {
        for (Element child : element.getElements()) {
            if (this.isDraggable(child)) {
                return (DraggableControl)child.getControl(DraggableControl.class);
            }
            DraggableControl draggable = this.findDraggableChild(child);
            if (draggable == null) continue;
            return draggable;
        }
        return null;
    }

    private boolean isDraggable(Element element) {
        NiftyInputControl control = element.getAttachedInputControl();
        if (control != null) {
            return control.getController() instanceof DraggableControl;
        }
        return false;
    }

    protected void drop(DraggableControl droppedDraggable, EndNotify endNotify) {
        this.drop(droppedDraggable, endNotify, true);
    }

    private void drop(DraggableControl droppedDraggable, EndNotify endNotify, boolean notifyObservers) {
        this.draggable = droppedDraggable;
        this.draggable.getElement().setConstraintX(new SizeValue("0px"));
        this.draggable.getElement().setConstraintY(new SizeValue("0px"));
        this.draggable.getElement().markForMove(this.droppable, endNotify);
        DroppableControl source = droppedDraggable.getDroppable();
        droppedDraggable.setDroppable(this);
        if (notifyObservers) {
            this.notifyObservers(source, droppedDraggable);
        }
    }

    public DraggableControl getDraggable() {
        return this.draggable;
    }

    public void addNotify(DropNotify notify) {
        this.notifies.add(notify);
    }

    public void removeNotify(DropNotify notify) {
        this.notifies.remove(notify);
    }

    public void removeAllNotifies() {
        this.notifies.clear();
    }

    private void notifyObservers(DroppableControl source, DraggableControl droppedDraggable) {
        for (DropNotify notify : this.notifies) {
            notify.dropped(source, droppedDraggable, this);
        }
    }

    public void addFilter(DropFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(DropFilter filter) {
        this.filters.remove(filter);
    }

    public void removeAllFilters() {
        this.filters.clear();
    }

    protected boolean accept(DroppableControl source, DraggableControl draggable) {
        for (DropFilter filter : this.filters) {
            if (filter.accept(source, draggable, this)) continue;
            return false;
        }
        return true;
    }

    public Element getElement() {
        return this.droppable;
    }

    private class OnDropMethodNotify
    implements DropNotify {
        private String methodName;

        public OnDropMethodNotify(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void dropped(DroppableControl source, DraggableControl draggable, DroppableControl target) {
            NiftyMethodInvoker methodInvoker = new NiftyMethodInvoker(DroppableControl.this.nifty, this.methodName, new Object[]{DroppableControl.this.screen.getScreenController()});
            methodInvoker.invoke(new Object[]{source, draggable, target});
        }
    }
}

