/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox.controller;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.dynamic.LabelCreator;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectAttributes;
import de.lessvoid.nifty.controls.listbox.controller.ListBoxItemController;
import de.lessvoid.nifty.controls.listbox.controller.ListBoxPanel;
import de.lessvoid.nifty.controls.scrollbar.controller.HorizontalScrollbarControl;
import de.lessvoid.nifty.controls.scrollbar.controller.ScrollbarControlNotify;
import de.lessvoid.nifty.controls.scrollbar.controller.VerticalScrollbarControl;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ListBoxControl
implements Controller {
    private Nifty nifty;
    private Screen screen;
    private Element element;
    private boolean verticalScrollbar;
    private boolean horizontalScrollbar;
    private String childRootId;
    private Element childRootElement;
    private Properties parameter;
    private float stepSizeX;
    private float stepSizeY;
    private List<SelectionListener> listeners = new ArrayList<SelectionListener>();

    public void bind(Nifty niftyParam, Screen screenParam, Element elementParam, Properties parameterParam, ControllerEventListener listener, Attributes controlDefinitionAttributes) {
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.element = elementParam;
        this.parameter = parameterParam;
        this.verticalScrollbar = new Boolean(this.parameter.getProperty("vertical", "true"));
        this.horizontalScrollbar = new Boolean(this.parameter.getProperty("horizontal", "true"));
        this.childRootId = controlDefinitionAttributes.get("childRootId");
        this.childRootElement = this.element.findElementByName(this.childRootId);
        ListBoxPanel listBoxPanel = this.getListBoxPanel();
        listBoxPanel.linkChildsToListBoxControl(this);
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void onFocus(boolean getFocus) {
    }

    public void onStartScreen() {
        this.stepSizeX = new Float(this.parameter.getProperty("stepSizeX", "1.0")).floatValue();
        ListBoxPanel listBoxPanel = this.getListBoxPanel();
        List<Element> listBoxElements = listBoxPanel.getListBoxElements();
        this.stepSizeY = listBoxElements.isEmpty() ? new Float(this.parameter.getProperty("stepSizeY", "1.0")).floatValue() : new Float(this.parameter.getProperty("stepSizeY", String.valueOf(listBoxElements.get(0).getHeight()))).floatValue();
        this.initializeScrollPanel(this.screen, this.stepSizeX, this.stepSizeY);
    }

    public void initializeScrollPanel(Screen screen, float stepSizeX, float stepSizeY) {
        Element scrollElement;
        Element horizontal;
        Element vertical;
        this.stepSizeX = stepSizeX;
        this.stepSizeY = stepSizeY;
        if (!this.verticalScrollbar && (vertical = this.element.findElementByName("nifty-internal-vertical-scrollbar")) != null) {
            this.nifty.removeElement(screen, vertical);
        }
        if (!this.horizontalScrollbar && (horizontal = this.element.findElementByName("nifty-internal-horizonal-panel")) != null) {
            this.nifty.removeElement(screen, horizontal);
        }
        this.nifty.executeEndOfFrameElementActions();
        screen.layoutLayers();
        if (this.childRootElement != null && !this.childRootElement.getElements().isEmpty() && (scrollElement = (Element)this.childRootElement.getElements().get(0)) != null) {
            VerticalScrollbarControl verticalS;
            HorizontalScrollbarControl horizontalS = (HorizontalScrollbarControl)this.element.findControl("nifty-internal-horizontal-scrollbar", HorizontalScrollbarControl.class);
            if (horizontalS != null) {
                horizontalS.setWorldMaxValue(scrollElement.getWidth());
                horizontalS.setViewMaxValue(this.childRootElement.getWidth());
                horizontalS.setPerClickChange(stepSizeX);
                horizontalS.setScrollBarControlNotify(new ScrollbarControlNotify(){

                    @Override
                    public void positionChanged(float currentValue) {
                        scrollElement.setConstraintX(new SizeValue(-((int)currentValue) + "px"));
                        scrollElement.getParent().layoutElements();
                    }
                });
            }
            if ((verticalS = (VerticalScrollbarControl)this.element.findControl("nifty-internal-vertical-scrollbar", VerticalScrollbarControl.class)) != null) {
                verticalS.setWorldMaxValue(scrollElement.getHeight());
                verticalS.setViewMaxValue(this.childRootElement.getHeight());
                verticalS.setPerClickChange(stepSizeY);
                verticalS.setScrollBarControlNotify(new ScrollbarControlNotify(){

                    @Override
                    public void positionChanged(float currentValue) {
                        scrollElement.setConstraintY(new SizeValue(-((int)currentValue) + "px"));
                        scrollElement.getParent().layoutElements();
                    }
                });
            }
            scrollElement.setConstraintX(new SizeValue("0px"));
            scrollElement.setConstraintY(new SizeValue("0px"));
        }
        screen.layoutLayers();
    }

    public void changeSelection(int newSelectedItemIndex) {
        ListBoxPanel listBoxPanel = this.getListBoxPanel();
        listBoxPanel.changeSelection(newSelectedItemIndex);
        this.fireOnSelectionChanged(this.getSelectedItemIndex());
    }

    public void changeSelection(Element element) {
        ListBoxPanel listBoxPanel = this.getListBoxPanel();
        listBoxPanel.changeSelection(element);
        this.fireOnSelectionChanged(this.getSelectedItemIndex());
    }

    public int getSelectedItemIndex() {
        ListBoxPanel listBoxPanel = this.getListBoxPanel();
        return listBoxPanel.getSelectedItemIndex();
    }

    public Element getSelectedElement() {
        ListBoxPanel listBoxPanel = this.getListBoxPanel();
        return listBoxPanel.getSelectedElement();
    }

    public void setFocus() {
        this.childRootElement.setFocus();
    }

    private ListBoxPanel getListBoxPanel() {
        return (ListBoxPanel)this.childRootElement.getControl(ListBoxPanel.class);
    }

    public void addItem(String text) {
        LabelCreator createLabel = new LabelCreator(text);
        createLabel.setStyle("nifty-listbox-item");
        ControlEffectAttributes effectParam = new ControlEffectAttributes();
        effectParam.setName("updateScrollpanelPositionToDisplayElement");
        effectParam.setAttribute("target", this.element.getId());
        effectParam.setAttribute("oneShot", "true");
        createLabel.addEffectsOnCustom(effectParam);
        Element listBoxDataParent = this.screen.findElementByName(this.element.getId() + "Data");
        Element newLabel = createLabel.create(this.nifty, this.screen, listBoxDataParent);
        this.connectElement(newLabel);
    }

    public void addElement(Element element) {
        this.connectElement(element);
    }

    private void connectElement(Element newLabel) {
        ListBoxControl listBox = (ListBoxControl)this.screen.findControl(this.element.getId(), ListBoxControl.class);
        ListBoxItemController newLabelController = (ListBoxItemController)newLabel.getControl(ListBoxItemController.class);
        newLabelController.setListBox(listBox);
    }

    public Element getElement() {
        return this.element;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    void fireOnSelectionChanged(int i) {
        for (SelectionListener listener : this.listeners) {
            listener.onSelectionChanged(this, i);
        }
    }

    public static interface SelectionListener {
        public void onSelectionChanged(ListBoxControl var1, int var2);
    }
}

