/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.window.controller;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.dragndrop.controller.DraggableControl;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class WindowControl
implements Controller {
    private DraggableControl draggableControl = new DraggableControl();
    private Element element;
    private boolean removeCloseButton;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, ControllerEventListener listener, Attributes controlDefinitionAttributes) {
        this.draggableControl.bind(nifty, screen, element, parameter, listener, controlDefinitionAttributes);
        this.element = element;
        this.removeCloseButton = !controlDefinitionAttributes.getAsBoolean("closeable", true);
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return this.draggableControl.inputEvent(inputEvent);
    }

    public void onFocus(boolean getFocus) {
        this.draggableControl.onFocus(getFocus);
    }

    public void onStartScreen() {
        this.draggableControl.onStartScreen();
        if (this.removeCloseButton) {
            this.getCloseButton().markForRemoval();
            this.removeCloseButton = false;
        }
    }

    public void dragStart(int mouseX, int mouseY) {
        this.draggableControl.dragStart(mouseX, mouseY);
    }

    public void drag(int mouseX, int mouseY) {
        this.draggableControl.drag(mouseX, mouseY);
    }

    public void dragStop() {
        this.draggableControl.dragStop();
    }

    public void closeWindow() {
        this.element.markForRemoval();
    }

    public String getTitle() {
        return ((TextRenderer)this.getTitleElement().getRenderer(TextRenderer.class)).getOriginalText();
    }

    public void setTitle(String title) {
        ((TextRenderer)this.getTitleElement().getRenderer(TextRenderer.class)).setText(title);
    }

    private Element getTitleElement() {
        return this.element.findElementByName("window-title");
    }

    private Element getCloseButton() {
        return this.element.findElementByName("window-close-button");
    }

    public Element getContent() {
        return this.element.findElementByName("window-content");
    }
}

