/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.sound.openal;

import de.lessvoid.nifty.sound.openal.slick.Audio;
import de.lessvoid.nifty.sound.openal.slick.SoundStore;
import java.net.URL;
import java.util.logging.Logger;

public class Sound {
    private Logger log;
    private Audio sound;
    static /* synthetic */ Class class$0;

    public Sound(URL url) throws Exception {
        block10: {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.lessvoid.nifty.sound.openal.Sound");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.log = Logger.getLogger(clazz.getName());
            SoundStore.get().init();
            String ref = url.getFile();
            try {
                if (ref.toLowerCase().endsWith(".ogg")) {
                    this.sound = SoundStore.get().getOgg(url.openStream());
                    break block10;
                }
                if (ref.toLowerCase().endsWith(".wav")) {
                    this.sound = SoundStore.get().getWAV(url.openStream());
                    break block10;
                }
                if (ref.toLowerCase().endsWith(".aif")) {
                    this.sound = SoundStore.get().getAIF(url.openStream());
                    break block10;
                }
                if (ref.toLowerCase().endsWith(".xm") || ref.toLowerCase().endsWith(".mod")) {
                    this.sound = SoundStore.get().getMOD(url.openStream());
                    break block10;
                }
                throw new Exception("Only .xm, .mod, .aif, .wav and .ogg are currently supported.");
            }
            catch (Exception e) {
                this.log.warning(e.toString());
                throw new Exception("Failed to load sound: " + ref);
            }
        }
    }

    public Sound(String ref) throws Exception {
        block10: {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.lessvoid.nifty.sound.openal.Sound");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.log = Logger.getLogger(clazz.getName());
            SoundStore.get().init();
            try {
                if (ref.toLowerCase().endsWith(".ogg")) {
                    this.sound = SoundStore.get().getOgg(ref);
                    break block10;
                }
                if (ref.toLowerCase().endsWith(".wav")) {
                    this.sound = SoundStore.get().getWAV(ref);
                    break block10;
                }
                if (ref.toLowerCase().endsWith(".aif")) {
                    this.sound = SoundStore.get().getAIF(ref);
                    break block10;
                }
                if (ref.toLowerCase().endsWith(".xm") || ref.toLowerCase().endsWith(".mod")) {
                    this.sound = SoundStore.get().getMOD(ref);
                    break block10;
                }
                throw new Exception("Only .xm, .mod, .aif, .wav and .ogg are currently supported.");
            }
            catch (Exception e) {
                this.log.warning(e.toString());
                throw new Exception("Failed to load sound: " + ref);
            }
        }
    }

    public void play() {
        this.play(1.0f, 1.0f);
    }

    public void play(float pitch, float volume) {
        this.sound.playAsSoundEffect(pitch, volume * SoundStore.get().getSoundVolume(), false);
    }

    public void playAt(float x, float y, float z) {
        this.playAt(1.0f, 1.0f, x, y, z);
    }

    public void playAt(float pitch, float volume, float x, float y, float z) {
        this.sound.playAsSoundEffect(pitch, volume * SoundStore.get().getSoundVolume(), false, x, y, z);
    }

    public void loop() {
        this.loop(1.0f, 1.0f);
    }

    public void loop(float pitch, float volume) {
        this.sound.playAsSoundEffect(pitch, volume * SoundStore.get().getSoundVolume(), true);
    }

    public boolean playing() {
        return this.sound.isPlaying();
    }

    public void stop() {
        this.sound.stop();
    }
}

