/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.impl.x11;

import com.jogamp.common.util.LongObjectHashMap;
import com.jogamp.common.util.RecursiveToolkitLock;
import com.jogamp.nativewindow.impl.Debug;
import com.jogamp.nativewindow.impl.NWJNILibLoader;
import com.jogamp.nativewindow.impl.x11.X11Lib;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.NativeWindowException;

public class X11Util {
    private static final boolean DEBUG = Debug.debug((String)"X11Util");
    public static final String nullDisplayName;
    private static Object globalLock;
    private static LongObjectHashMap globalNamedDisplayMap;
    private static ThreadLocal currentDisplayMap;

    public static void initSingleton() {
    }

    private X11Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int shutdown(boolean bl, boolean bl2) {
        Object object;
        int n = 0;
        String string = null;
        if (DEBUG || bl2) {
            string = "X11Util.Display: Shutdown (global: " + globalNamedDisplayMap.size() + ")";
            if (DEBUG) {
                object = new Exception(string);
                ((Throwable)object).printStackTrace();
            } else if (bl2) {
                System.err.println(string);
            }
        }
        object = globalLock;
        synchronized (object) {
            globalNamedDisplayMap.clear();
        }
        return n;
    }

    public static Map getCurrentDisplayMap() {
        return (Map)((HashMap)X11Util.getCurrentDisplayMapImpl()).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createThreadLocalDisplay(String string) {
        NamedDisplay namedDisplay = X11Util.getCurrentDisplay(string = X11Util.validateDisplayName(string));
        if (null == namedDisplay) {
            long l = X11Lib.XOpenDisplay(string);
            if (0L == l) {
                throw new NativeWindowException("X11Util.Display: Unable to create a display(" + string + ") connection in Thread " + Thread.currentThread().getName());
            }
            namedDisplay = new NamedDisplay(string, l);
            X11Util.addCurrentDisplay(namedDisplay);
            Object object = globalLock;
            synchronized (object) {
                globalNamedDisplayMap.put(l, (Object)namedDisplay);
            }
            if (DEBUG) {
                object = new Exception("X11Util.Display: Created new TLS " + namedDisplay + " in thread " + Thread.currentThread().getName());
                ((Throwable)object).printStackTrace();
            }
        } else {
            ++namedDisplay.refCount;
            if (DEBUG) {
                Exception exception = new Exception("X11Util.Display: Reused TLS " + namedDisplay + " in thread " + Thread.currentThread().getName());
                exception.printStackTrace();
            }
        }
        return namedDisplay.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long closeThreadLocalDisplay(String string) {
        NamedDisplay namedDisplay = X11Util.getCurrentDisplay(string = X11Util.validateDisplayName(string));
        if (null == namedDisplay) {
            throw new RuntimeException("X11Util.Display: Display(" + string + ") with given name is not mapped to TLS in thread " + Thread.currentThread().getName());
        }
        if (0 == namedDisplay.refCount) {
            throw new RuntimeException("X11Util.Display: " + namedDisplay + " has refCount already 0 in thread " + Thread.currentThread().getName());
        }
        long l = namedDisplay.getHandle();
        --namedDisplay.refCount;
        if (0 == namedDisplay.refCount) {
            Object object;
            if (DEBUG) {
                object = namedDisplay.isUncloseable() ? "passive" : "real";
                Exception exception = new Exception("X11Util.Display: Closing ( " + (String)object + " ) TLS " + namedDisplay + " in thread " + Thread.currentThread().getName());
                exception.printStackTrace();
            }
            X11Util.removeCurrentDisplay(namedDisplay);
            object = globalLock;
            synchronized (object) {
                if (null == globalNamedDisplayMap.remove(l)) {
                    throw new RuntimeException("Internal: " + namedDisplay);
                }
            }
            if (!namedDisplay.isUncloseable()) {
                X11Lib.XCloseDisplay(l);
            }
        } else if (DEBUG) {
            Exception exception = new Exception("X11Util.Display: Keep TLS " + namedDisplay + " in thread " + Thread.currentThread().getName());
            exception.printStackTrace();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long closeThreadLocalDisplay(long l) {
        NamedDisplay namedDisplay;
        Object object = globalLock;
        synchronized (object) {
            namedDisplay = (NamedDisplay)globalNamedDisplayMap.get(l);
        }
        if (null == namedDisplay) {
            throw new RuntimeException("X11Util.Display: Display(0x" + Long.toHexString(l) + ") with given handle is not mapped, in thread " + Thread.currentThread().getName());
        }
        return X11Util.closeThreadLocalDisplay(namedDisplay.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean markThreadLocalDisplayUncloseable(long l) {
        NamedDisplay namedDisplay;
        Object object = globalLock;
        synchronized (object) {
            namedDisplay = (NamedDisplay)globalNamedDisplayMap.get(l);
        }
        if (null != namedDisplay) {
            namedDisplay.unCloseable = true;
            return true;
        }
        return false;
    }

    private static Map getCurrentDisplayMapImpl() {
        HashMap hashMap = (HashMap)currentDisplayMap.get();
        if (null == hashMap) {
            hashMap = new HashMap();
            currentDisplayMap.set(hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NamedDisplay addCurrentDisplay(NamedDisplay namedDisplay) {
        Map map = X11Util.getCurrentDisplayMapImpl();
        NamedDisplay namedDisplay2 = null;
        Map map2 = map;
        synchronized (map2) {
            namedDisplay2 = map.put(namedDisplay.getName(), namedDisplay);
            map.notifyAll();
        }
        return namedDisplay2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NamedDisplay removeCurrentDisplay(NamedDisplay namedDisplay) {
        Map map;
        Map map2 = map = X11Util.getCurrentDisplayMapImpl();
        synchronized (map2) {
            NamedDisplay namedDisplay2 = (NamedDisplay)map.remove(namedDisplay.getName());
            if (namedDisplay2 != namedDisplay) {
                throw new RuntimeException("Wrong mapping req: " + namedDisplay + ", got " + namedDisplay2);
            }
            map.notifyAll();
        }
        return namedDisplay;
    }

    private static NamedDisplay getCurrentDisplay(String string) {
        Map map = X11Util.getCurrentDisplayMapImpl();
        return (NamedDisplay)map.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createDisplay(String string) {
        long l = X11Lib.XOpenDisplay(string = X11Util.validateDisplayName(string));
        if (0L == l) {
            throw new NativeWindowException("X11Util.Display: Unable to create a display(" + string + ") connection. Thread " + Thread.currentThread().getName());
        }
        NamedDisplay namedDisplay = new NamedDisplay(string, l);
        Object object = globalLock;
        synchronized (object) {
            globalNamedDisplayMap.put(l, (Object)namedDisplay);
        }
        if (DEBUG) {
            object = new Exception("X11Util.Display: Created new global " + namedDisplay + ". Thread " + Thread.currentThread().getName());
            ((Throwable)object).printStackTrace();
        }
        return namedDisplay.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDisplay(long l) {
        NamedDisplay namedDisplay;
        Object object = globalLock;
        synchronized (object) {
            namedDisplay = (NamedDisplay)globalNamedDisplayMap.remove(l);
        }
        if (null == namedDisplay) {
            throw new RuntimeException("X11Util.Display: Display(0x" + Long.toHexString(l) + ") with given handle is not mapped. Thread " + Thread.currentThread().getName());
        }
        if (namedDisplay.getHandle() != l) {
            throw new RuntimeException("X11Util.Display: Display(0x" + Long.toHexString(l) + ") Mapping error: " + namedDisplay + ". Thread " + Thread.currentThread().getName());
        }
        if (!namedDisplay.isUncloseable()) {
            X11Lib.XCloseDisplay(namedDisplay.getHandle());
        }
    }

    public static String validateDisplayName(String string) {
        return null == string ? nullDisplayName : string;
    }

    public static String validateDisplayName(String string, long l) {
        if (null == string && 0L != l) {
            string = X11Util.getNameOfDisplay(l);
        }
        return X11Util.validateDisplayName(string);
    }

    public static boolean setSynchronizeDisplay(long l, boolean bl) {
        boolean bl2 = X11Lib.XSynchronize(l, bl);
        return bl2;
    }

    public static String getNameOfDisplay(long l) {
        String string = X11Lib.XDisplayString(l);
        return string;
    }

    public static void XLockDisplay(long l) {
        if (DEBUG) {
            System.out.println("... X11 Display Lock try 0x" + Long.toHexString(l));
        }
        X11Lib.XLockDisplay(l);
        if (DEBUG) {
            System.out.println("+++ X11 Display Lock got 0x" + Long.toHexString(l));
        }
    }

    public static void XUnlockDisplay(long l) {
        if (DEBUG) {
            System.out.println("--- X11 Display Lock rel 0x" + Long.toHexString(l));
        }
        X11Lib.XUnlockDisplay(l);
    }

    private static native void initialize(boolean var0);

    static {
        NWJNILibLoader.loadNativeWindow((String)"x11");
        X11Util.initialize(true);
        long l = X11Lib.XOpenDisplay(null);
        nullDisplayName = X11Lib.XDisplayString(l);
        X11Lib.XCloseDisplay(l);
        if (DEBUG) {
            System.out.println("X11 Display(NULL) <" + nullDisplayName + ">");
        }
        globalLock = new Object();
        globalNamedDisplayMap = new LongObjectHashMap();
        currentDisplayMap = new ThreadLocal();
    }

    public static class NamedDisplay
    extends RecursiveToolkitLock
    implements Cloneable {
        String name;
        long handle;
        int refCount;
        boolean unCloseable;

        protected NamedDisplay(String string, long l) {
            this.name = string;
            this.handle = l;
            this.refCount = 1;
            this.unCloseable = false;
        }

        public final String getName() {
            return this.name;
        }

        public final long getHandle() {
            return this.handle;
        }

        public final int getRefCount() {
            return this.refCount;
        }

        public final boolean isUncloseable() {
            return this.unCloseable;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String toString() {
            return "NamedX11Display[" + this.name + ", 0x" + Long.toHexString(this.handle) + ", refCount " + this.refCount + ", unCloseable " + this.unCloseable + "]";
        }
    }
}

