/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.builder;

import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectOnHoverAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlHoverAttributes;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.loaderv2.types.EffectValueType;
import java.util.logging.Logger;

public class HoverEffectBuilder {
    private static Logger logger = Logger.getLogger(HoverEffectBuilder.class.getName());
    private ControlEffectOnHoverAttributes attributes = new ControlEffectOnHoverAttributes();
    private ControlHoverAttributes hoverAttributes = new ControlHoverAttributes();

    public HoverEffectBuilder(String effectName) {
        this.attributes.setName(effectName);
        this.attributes.setControlHoverAttributes(this.hoverAttributes);
    }

    public HoverEffectBuilder inherit(boolean inherit) {
        this.attributes.setInherit(String.valueOf(inherit));
        return this;
    }

    public HoverEffectBuilder inherit() {
        this.attributes.setInherit("true");
        return this;
    }

    public HoverEffectBuilder post(boolean post) {
        this.attributes.setPost(String.valueOf(post));
        return this;
    }

    public HoverEffectBuilder overlay(boolean overlay) {
        this.attributes.setOverlay(String.valueOf(overlay));
        return this;
    }

    public HoverEffectBuilder alternateEnable(String alternateEnable) {
        this.attributes.setAlternateEnable(alternateEnable);
        return this;
    }

    public HoverEffectBuilder alternateDisable(String alternateDisable) {
        this.attributes.setAlternateDisable(alternateDisable);
        return this;
    }

    public HoverEffectBuilder customKey(String customKey) {
        this.attributes.setCustomKey(customKey);
        return this;
    }

    public HoverEffectBuilder neverStopRendering(boolean neverStopRendering) {
        this.attributes.setNeverStopRendering(String.valueOf(neverStopRendering));
        return this;
    }

    public HoverEffectBuilder effectParameter(String key, String value) {
        this.attributes.setAttribute(key, value);
        return this;
    }

    public HoverEffectBuilder hoverParameter(String key, String value) {
        this.hoverAttributes.set(key, value);
        return this;
    }

    public HoverEffectBuilder hoverFalloffType(Falloff.HoverFalloffType hoverFalloffType) {
        this.hoverAttributes.set("hoverFalloffType", hoverFalloffType.toString());
        return this;
    }

    public HoverEffectBuilder hoverFalloffConstraint(Falloff.HoverFalloffConstraint hoverFalloffConstraint) {
        this.hoverAttributes.set("hoverFalloffConstraint", hoverFalloffConstraint.toString());
        return this;
    }

    public HoverEffectBuilder hoverWidth(String hoverWidth) {
        this.hoverAttributes.set("hoverWidth", hoverWidth);
        return this;
    }

    public HoverEffectBuilder hoverHeight(String hoverHeight) {
        this.hoverAttributes.set("hoverHeight", hoverHeight);
        return this;
    }

    public ControlEffectOnHoverAttributes getAttributes() {
        return this.attributes;
    }

    public HoverEffectBuilder effectValue(String ... values) {
        if (values == null || values.length % 2 != 0) {
            logger.warning("effect values must be given in pairs, example: effectValue(\"color\", \"#f00f\")");
            return this;
        }
        EffectValueType effectValue = new EffectValueType();
        for (int i = 0; i < values.length / 2; ++i) {
            String key = values[i * 2 + 0];
            String value = values[i * 2 + 1];
            effectValue.getAttributes().set(key, value);
        }
        this.attributes.addEffectValues(effectValue);
        return this;
    }
}

