/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import de.lessvoid.nifty.tools.ColorValidator;
import java.util.Random;
import java.util.logging.Logger;

public class Color {
    private Logger log = Logger.getLogger(Color.class.getName());
    private static final int SCALE_SHORT_MODE = 17;
    public static final Color NONE = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    private static final float MAX_INT_VALUE = 255.0f;
    private static final int HEX_BASE = 16;
    private float red = 0.0f;
    private float green = 0.0f;
    private float blue = 0.0f;
    private float alpha = 0.0f;
    private static ColorValidator colorValidator = new ColorValidator();
    private String colorString;

    public Color(String color) {
        this.fromString(color);
    }

    public Color(float newRed, float newGreen, float newBlue, float newAlpha) {
        this.red = newRed;
        this.green = newGreen;
        this.blue = newBlue;
        this.alpha = newAlpha;
        this.colorString = this.fromRGBA(this.red, this.green, this.blue, this.alpha);
    }

    public Color(int color) {
        this.alpha = color >> 24 & 0xFF;
        this.red = color >> 16 & 0xFF;
        this.green = color >> 8 & 0xFF;
        this.blue = color >> 0 & 0xFF;
        this.colorString = this.fromRGBA(this.red, this.green, this.blue, this.alpha);
    }

    public Color(Color newColor, float newAlpha) {
        this.red = newColor.getRed();
        this.green = newColor.getGreen();
        this.blue = newColor.getBlue();
        this.alpha = newAlpha;
        this.colorString = this.fromRGBA(this.red, this.green, this.blue, this.alpha);
    }

    public Color(Color colorParam) {
        this.red = colorParam.getRed();
        this.green = colorParam.getGreen();
        this.blue = colorParam.getBlue();
        this.alpha = colorParam.getAlpha();
        this.colorString = colorParam.getColorString();
    }

    private String fromRGBA(float redValue, float greenValue, float blueValue, float alphaValue) {
        StringBuffer result = new StringBuffer();
        result.append('#');
        result.append(this.toHex(redValue));
        result.append(this.toHex(greenValue));
        result.append(this.toHex(blueValue));
        result.append(this.toHex(alphaValue));
        return result.toString();
    }

    private String toHex(float redValue) {
        return Integer.toHexString((int)(redValue * 15.0f));
    }

    public String getColorString() {
        return this.colorString;
    }

    public void setColorString(String colorString) {
        this.colorString = colorString;
    }

    public String getColorStringWithoutAlpha() {
        return this.colorString.substring(0, this.colorString.length() - 1);
    }

    public void linear(Color start, Color end, float t) {
        this.red = start.getRed() + t * (end.red - start.getRed());
        this.green = start.getGreen() + t * (end.green - start.getGreen());
        this.blue = start.getBlue() + t * (end.blue - start.getBlue());
        this.alpha = start.getAlpha() + t * (end.alpha - start.getAlpha());
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    private float getRFromString(String color) {
        if (this.isShortMode(color)) {
            return (float)(Integer.valueOf(color.substring(1, 2), 16) * 17) / 255.0f;
        }
        return (float)Integer.valueOf(color.substring(1, 3), 16).intValue() / 255.0f;
    }

    private float getGFromString(String color) {
        if (this.isShortMode(color)) {
            return (float)(Integer.valueOf(color.substring(2, 3), 16) * 17) / 255.0f;
        }
        return (float)Integer.valueOf(color.substring(3, 5), 16).intValue() / 255.0f;
    }

    private float getBFromString(String color) {
        if (this.isShortMode(color)) {
            return (float)(Integer.valueOf(color.substring(3, 4), 16) * 17) / 255.0f;
        }
        return (float)Integer.valueOf(color.substring(5, 7), 16).intValue() / 255.0f;
    }

    private float getAFromString(String color) {
        if (this.isShortMode(color)) {
            return (float)(Integer.valueOf(color.substring(4, 5), 16) * 17) / 255.0f;
        }
        return (float)Integer.valueOf(color.substring(7, 9), 16).intValue() / 255.0f;
    }

    private boolean isShortMode(String color) {
        return colorValidator.isShortMode(color) || colorValidator.isShortModeWithoutAlpha(color);
    }

    public void mutiply(Color color, float factor) {
        this.red = color.red * factor;
        this.green = color.green * factor;
        this.blue = color.blue * factor;
        this.alpha = color.alpha * factor;
    }

    public String toString() {
        return "(" + this.red + "," + this.green + "," + this.blue + "," + this.alpha + ")";
    }

    public Color setAlpha(float newColorAlpha) {
        this.alpha = newColorAlpha;
        return this;
    }

    public void setRed(float newRed) {
        this.red = newRed;
    }

    public void setGreen(float newGreen) {
        this.green = newGreen;
    }

    public void setBlue(float newBlue) {
        this.blue = newBlue;
    }

    public static boolean check(String color) {
        return colorValidator.isShortModeWithoutAlpha(color) || colorValidator.isLongModeWithoutAlpha(color) || colorValidator.isValid(color);
    }

    public void fromString(String color) {
        this.colorString = color;
        if (colorValidator.isShortModeWithoutAlpha(color)) {
            this.red = this.getRFromString(color);
            this.green = this.getGFromString(color);
            this.blue = this.getBFromString(color);
            this.alpha = 1.0f;
            this.log.fine("found short mode color [" + color + "] with missing alpha value automatically adjusted with alpha value of [#f]");
        } else if (colorValidator.isLongModeWithoutAlpha(color)) {
            this.red = this.getRFromString(color);
            this.green = this.getGFromString(color);
            this.blue = this.getBFromString(color);
            this.alpha = 1.0f;
            this.log.fine("found long mode color [" + color + "] with missing alpha value automatically adjusted with alpha value of [#ff]");
        } else if (colorValidator.isValid(color)) {
            this.red = this.getRFromString(color);
            this.green = this.getGFromString(color);
            this.blue = this.getBFromString(color);
            this.alpha = this.getAFromString(color);
        } else {
            this.log.fine("error parsing color [" + color + "] automatically adjusted to white [#ffffffff]");
            this.alpha = 1.0f;
            this.blue = 1.0f;
            this.green = 1.0f;
            this.red = 1.0f;
        }
    }

    public void fromStringWithoutAlpha(String color) {
        this.colorString = color + this.toHex(this.alpha);
        if (colorValidator.isShortModeWithoutAlpha(color)) {
            this.red = this.getRFromString(color);
            this.green = this.getGFromString(color);
            this.blue = this.getBFromString(color);
        } else if (colorValidator.isLongModeWithoutAlpha(color)) {
            this.red = this.getRFromString(color);
            this.green = this.getGFromString(color);
            this.blue = this.getBFromString(color);
        } else if (colorValidator.isValid(color)) {
            this.red = this.getRFromString(color);
            this.green = this.getGFromString(color);
            this.blue = this.getBFromString(color);
        } else {
            this.blue = 1.0f;
            this.green = 1.0f;
            this.red = 1.0f;
        }
    }

    public static Color randomColor() {
        Random random = new Random();
        return new Color(random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f);
    }
}

