/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.util.EventObject;

public class PhysicsCollisionEvent
extends EventObject {
    public static final int TYPE_ADDED = 0;
    public static final int TYPE_PROCESSED = 1;
    public static final int TYPE_DESTROYED = 2;
    private int type;
    private PhysicsCollisionObject nodeA;
    private PhysicsCollisionObject nodeB;
    private long manifoldPointObjectId = 0L;

    public PhysicsCollisionEvent(int n, PhysicsCollisionObject physicsCollisionObject, PhysicsCollisionObject physicsCollisionObject2, long l) {
        super(physicsCollisionObject);
        this.type = n;
        this.nodeA = physicsCollisionObject;
        this.nodeB = physicsCollisionObject2;
        this.manifoldPointObjectId = l;
    }

    public void clean() {
        this.source = null;
        this.type = 0;
        this.nodeA = null;
        this.nodeB = null;
        this.manifoldPointObjectId = 0L;
    }

    public void refactor(int n, PhysicsCollisionObject physicsCollisionObject, PhysicsCollisionObject physicsCollisionObject2, long l) {
        this.source = physicsCollisionObject;
        this.type = n;
        this.nodeA = physicsCollisionObject;
        this.nodeB = physicsCollisionObject2;
        this.manifoldPointObjectId = l;
    }

    public int getType() {
        return this.type;
    }

    public Spatial getNodeA() {
        if (this.nodeA.getUserObject() instanceof Spatial) {
            return (Spatial)this.nodeA.getUserObject();
        }
        return null;
    }

    public Spatial getNodeB() {
        if (this.nodeB.getUserObject() instanceof Spatial) {
            return (Spatial)this.nodeB.getUserObject();
        }
        return null;
    }

    public PhysicsCollisionObject getObjectA() {
        return this.nodeA;
    }

    public PhysicsCollisionObject getObjectB() {
        return this.nodeB;
    }

    public float getAppliedImpulse() {
        return this.getAppliedImpulse(this.manifoldPointObjectId);
    }

    private native float getAppliedImpulse(long var1);

    public float getAppliedImpulseLateral1() {
        return this.getAppliedImpulseLateral1(this.manifoldPointObjectId);
    }

    private native float getAppliedImpulseLateral1(long var1);

    public float getAppliedImpulseLateral2() {
        return this.getAppliedImpulseLateral2(this.manifoldPointObjectId);
    }

    private native float getAppliedImpulseLateral2(long var1);

    public float getCombinedFriction() {
        return this.getCombinedFriction(this.manifoldPointObjectId);
    }

    private native float getCombinedFriction(long var1);

    public float getCombinedRestitution() {
        return this.getCombinedRestitution(this.manifoldPointObjectId);
    }

    private native float getCombinedRestitution(long var1);

    public float getDistance1() {
        return this.getDistance1(this.manifoldPointObjectId);
    }

    private native float getDistance1(long var1);

    public int getIndex0() {
        return this.getIndex0(this.manifoldPointObjectId);
    }

    private native int getIndex0(long var1);

    public int getIndex1() {
        return this.getIndex1(this.manifoldPointObjectId);
    }

    private native int getIndex1(long var1);

    public Vector3f getLateralFrictionDir1(Vector3f vector3f) {
        this.getLateralFrictionDir1(this.manifoldPointObjectId, vector3f);
        return vector3f;
    }

    private native void getLateralFrictionDir1(long var1, Vector3f var3);

    public Vector3f getLateralFrictionDir2(Vector3f vector3f) {
        this.getLateralFrictionDir2(this.manifoldPointObjectId, vector3f);
        return vector3f;
    }

    private native void getLateralFrictionDir2(long var1, Vector3f var3);

    public boolean isLateralFrictionInitialized() {
        return this.isLateralFrictionInitialized(this.manifoldPointObjectId);
    }

    private native boolean isLateralFrictionInitialized(long var1);

    public int getLifeTime() {
        return this.getLifeTime(this.manifoldPointObjectId);
    }

    private native int getLifeTime(long var1);

    public Vector3f getLocalPointA(Vector3f vector3f) {
        this.getLocalPointA(this.manifoldPointObjectId, vector3f);
        return vector3f;
    }

    private native void getLocalPointA(long var1, Vector3f var3);

    public Vector3f getLocalPointB(Vector3f vector3f) {
        this.getLocalPointB(this.manifoldPointObjectId, vector3f);
        return vector3f;
    }

    private native void getLocalPointB(long var1, Vector3f var3);

    public Vector3f getNormalWorldOnB(Vector3f vector3f) {
        this.getNormalWorldOnB(this.manifoldPointObjectId, vector3f);
        return vector3f;
    }

    private native void getNormalWorldOnB(long var1, Vector3f var3);

    public int getPartId0() {
        return this.getPartId0(this.manifoldPointObjectId);
    }

    private native int getPartId0(long var1);

    public int getPartId1() {
        return this.getPartId1(this.manifoldPointObjectId);
    }

    private native int getPartId1(long var1);

    public Vector3f getPositionWorldOnA(Vector3f vector3f) {
        this.getPositionWorldOnA(vector3f);
        return vector3f;
    }

    private native void getPositionWorldOnA(long var1, Vector3f var3);

    public Vector3f getPositionWorldOnB(Vector3f vector3f) {
        this.getPositionWorldOnB(this.manifoldPointObjectId, vector3f);
        return vector3f;
    }

    private native void getPositionWorldOnB(long var1, Vector3f var3);
}

