/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.io.IOException;

public class CharacterControl
extends PhysicsCharacter
implements PhysicsControl {
    protected Spatial spatial;
    protected boolean enabled = true;
    protected boolean added = false;
    protected PhysicsSpace space = null;
    protected Vector3f viewDirection = new Vector3f(Vector3f.UNIT_Z);
    protected boolean useViewDirection = true;
    protected boolean applyLocal = false;

    public CharacterControl() {
    }

    public CharacterControl(CollisionShape collisionShape, float f) {
        super(collisionShape, f);
    }

    public boolean isApplyPhysicsLocal() {
        return this.applyLocal;
    }

    public void setApplyPhysicsLocal(boolean bl) {
        this.applyLocal = bl;
    }

    private Vector3f getSpatialTranslation() {
        if (this.applyLocal) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }

    public Control cloneForSpatial(Spatial spatial) {
        CharacterControl characterControl = new CharacterControl(this.collisionShape, this.stepHeight);
        characterControl.setCcdMotionThreshold(this.getCcdMotionThreshold());
        characterControl.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        characterControl.setCollideWithGroups(this.getCollideWithGroups());
        characterControl.setCollisionGroup(this.getCollisionGroup());
        characterControl.setFallSpeed(this.getFallSpeed());
        characterControl.setGravity(this.getGravity());
        characterControl.setJumpSpeed(this.getJumpSpeed());
        characterControl.setMaxSlope(this.getMaxSlope());
        characterControl.setPhysicsLocation(this.getPhysicsLocation());
        characterControl.setUpAxis(this.getUpAxis());
        characterControl.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        characterControl.setSpatial(spatial);
        return characterControl;
    }

    public void setSpatial(Spatial spatial) {
        if (this.getUserObject() == null || this.getUserObject() == this.spatial) {
            this.setUserObject(spatial);
        }
        this.spatial = spatial;
        if (spatial == null) {
            if (this.getUserObject() == spatial) {
                this.setUserObject(null);
            }
            return;
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.space != null) {
            if (bl && !this.added) {
                if (this.spatial != null) {
                    this.warp(this.getSpatialTranslation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!bl && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setViewDirection(Vector3f vector3f) {
        this.viewDirection.set(vector3f);
    }

    public Vector3f getViewDirection() {
        return this.viewDirection;
    }

    public boolean isUseViewDirection() {
        return this.useViewDirection;
    }

    public void setUseViewDirection(boolean bl) {
        this.useViewDirection = bl;
    }

    public void update(float f) {
        if (this.enabled && this.spatial != null) {
            Quaternion quaternion = this.spatial.getLocalRotation();
            Vector3f vector3f = this.spatial.getLocalTranslation();
            if (!this.applyLocal && this.spatial.getParent() != null) {
                this.getPhysicsLocation(vector3f);
                vector3f.subtractLocal(this.spatial.getParent().getWorldTranslation());
                vector3f.divideLocal(this.spatial.getParent().getWorldScale());
                this.tmp_inverseWorldRotation.set(this.spatial.getParent().getWorldRotation()).inverseLocal().multLocal(vector3f);
                this.spatial.setLocalTranslation(vector3f);
                if (this.useViewDirection) {
                    quaternion.lookAt(this.viewDirection, Vector3f.UNIT_Y);
                    this.spatial.setLocalRotation(quaternion);
                }
            } else {
                this.spatial.setLocalTranslation(this.getPhysicsLocation());
                quaternion.lookAt(this.viewDirection, Vector3f.UNIT_Y);
                this.spatial.setLocalRotation(quaternion);
            }
        }
    }

    public void render(RenderManager renderManager, ViewPort viewPort) {
        if (this.enabled && this.space != null && this.space.getDebugManager() != null) {
            if (this.debugShape == null) {
                this.attachDebugShape(this.space.getDebugManager());
            }
            this.debugShape.setLocalTranslation(this.getPhysicsLocation());
            this.debugShape.updateLogicalState(0.0f);
            this.debugShape.updateGeometricState();
            renderManager.renderScene(this.debugShape, viewPort);
        }
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace physicsSpace) {
        if (physicsSpace == null) {
            if (this.space != null) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        } else {
            if (this.space == physicsSpace) {
                return;
            }
            physicsSpace.addCollisionObject(this);
            this.added = true;
        }
        this.space = physicsSpace;
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write(this.enabled, "enabled", true);
        outputCapsule.write(this.applyLocal, "applyLocalPhysics", false);
        outputCapsule.write(this.useViewDirection, "viewDirectionEnabled", true);
        outputCapsule.write((Savable)this.viewDirection, "viewDirection", (Savable)new Vector3f(Vector3f.UNIT_Z));
        outputCapsule.write((Savable)this.spatial, "spatial", null);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.enabled = inputCapsule.readBoolean("enabled", true);
        this.useViewDirection = inputCapsule.readBoolean("viewDirectionEnabled", true);
        this.viewDirection = (Vector3f)inputCapsule.readSavable("viewDirection", (Savable)new Vector3f(Vector3f.UNIT_Z));
        this.applyLocal = inputCapsule.readBoolean("applyLocalPhysics", false);
        this.spatial = (Spatial)inputCapsule.readSavable("spatial", null);
        this.setUserObject(this.spatial);
    }
}

