/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.Arrow;
import java.io.IOException;

public class VehicleControl
extends PhysicsVehicle
implements PhysicsControl {
    protected Spatial spatial;
    protected boolean enabled = true;
    protected PhysicsSpace space = null;
    protected boolean added = false;

    public VehicleControl() {
    }

    public VehicleControl(CollisionShape collisionShape) {
        super(collisionShape);
    }

    public VehicleControl(CollisionShape collisionShape, float f) {
        super(collisionShape, f);
    }

    public boolean isApplyPhysicsLocal() {
        return this.motionState.isApplyPhysicsLocal();
    }

    public void setApplyPhysicsLocal(boolean bl) {
        this.motionState.setApplyPhysicsLocal(bl);
        for (VehicleWheel vehicleWheel : this.wheels) {
            vehicleWheel.setApplyLocal(bl);
        }
    }

    private Vector3f getSpatialTranslation() {
        if (this.motionState.isApplyPhysicsLocal()) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }

    private Quaternion getSpatialRotation() {
        if (this.motionState.isApplyPhysicsLocal()) {
            return this.spatial.getLocalRotation();
        }
        return this.spatial.getWorldRotation();
    }

    public Control cloneForSpatial(Spatial spatial) {
        VehicleControl vehicleControl = new VehicleControl(this.collisionShape, this.mass);
        vehicleControl.setAngularFactor(this.getAngularFactor());
        vehicleControl.setAngularSleepingThreshold(this.getAngularSleepingThreshold());
        vehicleControl.setAngularVelocity(this.getAngularVelocity());
        vehicleControl.setCcdMotionThreshold(this.getCcdMotionThreshold());
        vehicleControl.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        vehicleControl.setCollideWithGroups(this.getCollideWithGroups());
        vehicleControl.setCollisionGroup(this.getCollisionGroup());
        vehicleControl.setDamping(this.getLinearDamping(), this.getAngularDamping());
        vehicleControl.setFriction(this.getFriction());
        vehicleControl.setGravity(this.getGravity());
        vehicleControl.setKinematic(this.isKinematic());
        vehicleControl.setLinearSleepingThreshold(this.getLinearSleepingThreshold());
        vehicleControl.setLinearVelocity(this.getLinearVelocity());
        vehicleControl.setPhysicsLocation(this.getPhysicsLocation());
        vehicleControl.setPhysicsRotation(this.getPhysicsRotationMatrix());
        vehicleControl.setRestitution(this.getRestitution());
        vehicleControl.setFrictionSlip(this.getFrictionSlip());
        vehicleControl.setMaxSuspensionTravelCm(this.getMaxSuspensionTravelCm());
        vehicleControl.setSuspensionStiffness(this.getSuspensionStiffness());
        vehicleControl.setSuspensionCompression(this.tuning.suspensionCompression);
        vehicleControl.setSuspensionDamping(this.tuning.suspensionDamping);
        vehicleControl.setMaxSuspensionForce(this.getMaxSuspensionForce());
        for (VehicleWheel vehicleWheel : this.wheels) {
            Node node;
            Spatial spatial2;
            VehicleWheel vehicleWheel2 = vehicleControl.addWheel(vehicleWheel.getLocation(), vehicleWheel.getDirection(), vehicleWheel.getAxle(), vehicleWheel.getRestLength(), vehicleWheel.getRadius(), vehicleWheel.isFrontWheel());
            vehicleWheel2.setFrictionSlip(vehicleWheel.getFrictionSlip());
            vehicleWheel2.setMaxSuspensionTravelCm(vehicleWheel.getMaxSuspensionTravelCm());
            vehicleWheel2.setSuspensionStiffness(vehicleWheel.getSuspensionStiffness());
            vehicleWheel2.setWheelsDampingCompression(vehicleWheel.getWheelsDampingCompression());
            vehicleWheel2.setWheelsDampingRelaxation(vehicleWheel.getWheelsDampingRelaxation());
            vehicleWheel2.setMaxSuspensionForce(vehicleWheel.getMaxSuspensionForce());
            if (!(spatial instanceof Node) || (spatial2 = (node = (Node)spatial).getChild(vehicleWheel.getWheelSpatial().getName())) == null) continue;
            vehicleWheel2.setWheelSpatial(spatial2);
        }
        vehicleControl.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        vehicleControl.setSpatial(spatial);
        return vehicleControl;
    }

    public void setSpatial(Spatial spatial) {
        if (this.getUserObject() == null || this.getUserObject() == this.spatial) {
            this.setUserObject(spatial);
        }
        this.spatial = spatial;
        if (spatial == null) {
            if (this.getUserObject() == spatial) {
                this.setUserObject(null);
            }
            this.spatial = null;
            this.collisionShape = null;
            return;
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.space != null) {
            if (bl && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!bl && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void update(float f) {
        if (this.enabled && this.spatial != null) {
            if (this.getMotionState().applyTransform(this.spatial)) {
                this.spatial.getWorldTransform();
                this.applyWheelTransforms();
            }
        } else if (this.enabled) {
            this.applyWheelTransforms();
        }
    }

    @Override
    protected Spatial getDebugShape() {
        return super.getDebugShape();
    }

    public void render(RenderManager renderManager, ViewPort viewPort) {
        if (this.enabled && this.space != null && this.space.getDebugManager() != null) {
            if (this.debugShape == null) {
                this.attachDebugShape(this.space.getDebugManager());
            }
            Node node = (Node)this.debugShape;
            this.debugShape.setLocalTranslation(this.spatial.getWorldTranslation());
            this.debugShape.setLocalRotation(this.spatial.getWorldRotation());
            int n = 0;
            for (VehicleWheel vehicleWheel : this.wheels) {
                Vector3f vector3f = vehicleWheel.getLocation().clone();
                Vector3f vector3f2 = vehicleWheel.getDirection().clone();
                Vector3f vector3f3 = vehicleWheel.getAxle().clone();
                float f = vehicleWheel.getRestLength();
                float f2 = vehicleWheel.getRadius();
                Geometry geometry = (Geometry)node.getChild("WheelLocationDebugShape" + n);
                Geometry geometry2 = (Geometry)node.getChild("WheelDirectionDebugShape" + n);
                Geometry geometry3 = (Geometry)node.getChild("WheelAxleDebugShape" + n);
                Geometry geometry4 = (Geometry)node.getChild("WheelRadiusDebugShape" + n);
                Arrow arrow = (Arrow)geometry.getMesh();
                arrow.setArrowExtent(vector3f);
                Arrow arrow2 = (Arrow)geometry3.getMesh();
                arrow2.setArrowExtent(vector3f3.normalizeLocal().multLocal(0.3f));
                Arrow arrow3 = (Arrow)geometry4.getMesh();
                arrow3.setArrowExtent(vector3f2.normalizeLocal().multLocal(f2));
                Arrow arrow4 = (Arrow)geometry2.getMesh();
                arrow4.setArrowExtent(vector3f2.normalizeLocal().multLocal(f));
                geometry2.setLocalTranslation(vector3f);
                geometry3.setLocalTranslation(vector3f.addLocal(vector3f2));
                geometry4.setLocalTranslation(vector3f);
                ++n;
            }
            this.debugShape.updateLogicalState(0.0f);
            this.debugShape.updateGeometricState();
            renderManager.renderScene(this.debugShape, viewPort);
        }
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace physicsSpace) {
        if (physicsSpace == null) {
            if (this.space != null) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        } else {
            if (this.space == physicsSpace) {
                return;
            }
            physicsSpace.addCollisionObject(this);
            this.added = true;
        }
        this.space = physicsSpace;
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write(this.enabled, "enabled", true);
        outputCapsule.write(this.motionState.isApplyPhysicsLocal(), "applyLocalPhysics", false);
        outputCapsule.write((Savable)this.spatial, "spatial", null);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.enabled = inputCapsule.readBoolean("enabled", true);
        this.spatial = (Spatial)inputCapsule.readSavable("spatial", null);
        this.motionState.setApplyPhysicsLocal(inputCapsule.readBoolean("applyLocalPhysics", false));
        this.setUserObject(this.spatial);
    }
}

