/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.PMDIKData;

public class PMDIKList
implements Serializable {
    private int ikDataCount;
    private PMDIKData[] pmdIKData;

    public PMDIKList(DataInputStreamLittleEndian is) throws IOException {
        this.ikDataCount = is.readUnsignedShort();
        this.pmdIKData = new PMDIKData[this.ikDataCount];
        for (int i = 0; i < this.ikDataCount; ++i) {
            this.pmdIKData[i] = new PMDIKData(is);
        }
    }

    public void writeToStream(DataOutput os) throws IOException {
        os.writeShort(this.ikDataCount);
        for (PMDIKData ikData : this.pmdIKData) {
            ikData.writeToStream(os);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ikDataCount = " + this.ikDataCount + "\n");
        sb.append("ikData = {\n");
        for (int i = 0; i < this.ikDataCount; ++i) {
            sb.append("ikDataCount = " + i);
            sb.append(" ikData = ");
            sb.append(this.pmdIKData[i]);
            sb.append("\n");
        }
        sb.append("}\n");
        sb.append("}\n");
        return sb.toString();
    }

    public int getIkDataCount() {
        return this.ikDataCount;
    }

    public void setIkDataCount(int ikDataCount) {
        this.ikDataCount = ikDataCount;
    }

    public PMDIKData[] getPmdIKData() {
        return this.pmdIKData;
    }

    public void setPmdIKData(PMDIKData[] pmdIKData) {
        this.pmdIKData = pmdIKData;
    }
}

