/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import com.jme3.util.BufferUtils;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.PMDUtil;

public class PMDSkinData
implements Serializable {
    private String skinName;
    private int skinVertCount;
    private int skinType;
    private ShortBuffer indexBuf;
    private FloatBuffer skinBuf;

    public PMDSkinData(DataInputStreamLittleEndian is) throws IOException {
        this.skinName = is.readString(20);
        this.skinVertCount = is.readInt();
        this.skinType = is.readByte();
        this.indexBuf = BufferUtils.createShortBuffer((int)this.skinVertCount);
        this.skinBuf = BufferUtils.createFloatBuffer((int)(this.skinVertCount * 3));
        for (int i = 0; i < this.skinVertCount; ++i) {
            this.indexBuf.put((short)is.readInt());
            this.skinBuf.put(is.readFloat());
            this.skinBuf.put(is.readFloat());
            this.skinBuf.put(-is.readFloat());
        }
    }

    public void writeToStream(DataOutput os) throws IOException {
        PMDUtil.writeString(os, this.skinName, 20);
        os.writeInt(this.skinVertCount);
        os.writeByte(this.skinType);
        this.indexBuf.position(0);
        this.skinBuf.position(0);
        for (int i = 0; i < this.skinVertCount; ++i) {
            os.writeInt(this.indexBuf.get() & 0xFFFF);
            os.writeFloat(this.skinBuf.get());
            os.writeFloat(this.skinBuf.get());
            os.writeFloat(-this.skinBuf.get());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{skinName = " + this.skinName + "\nskinVertCount = " + this.skinVertCount + "\nskinType = " + this.skinType + "\nskinVertData = ");
        for (int i = 0; i < this.skinVertCount; ++i) {
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setSkinType(int skinType) {
        this.skinType = skinType;
    }

    public int getSkinVertCount() {
        return this.skinVertCount;
    }

    public void setSkinVertCount(int skinVertCount) {
        this.skinVertCount = skinVertCount;
    }

    public ShortBuffer getIndexBuf() {
        return this.indexBuf;
    }

    public void setIndexBuf(ShortBuffer indexBuf) {
        this.indexBuf = indexBuf;
    }

    public FloatBuffer getSkinBuf() {
        return this.skinBuf;
    }

    public void setSkinBuf(FloatBuffer skinBuf) {
        this.skinBuf = skinBuf;
    }
}

