/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.VMDFile;
import projectkyoto.mmd.file.util2.BufferUtil;

public class VMDMotion
implements Serializable {
    protected VMDFile vmdFile;
    private String boneName;
    private short boneIndex;
    private int frameNo;
    private Point3f location;
    private Quat4f rotation;
    private byte[] interpolation = new byte[64];

    public VMDMotion() {
        this.location = new Point3f();
        this.rotation = new Quat4f();
    }

    public VMDMotion(VMDFile vmdFile, DataInputStreamLittleEndian is) throws IOException {
        this.vmdFile = vmdFile;
        this.readFromStream(is);
    }

    public final void readFromStream(DataInputStreamLittleEndian is) throws IOException {
        this.boneName = is.readString(15);
        this.boneIndex = (short)-1;
        this.boneIndex = (short)this.vmdFile.boneNames.indexOf(this.boneName);
        if (this.boneIndex < 0) {
            this.vmdFile.boneNames.add(this.boneName);
            this.boneIndex = (short)this.vmdFile.boneNames.indexOf(this.boneName);
        }
        this.frameNo = is.readInt();
        this.location = new Point3f();
        this.location.x = is.readFloat();
        this.location.y = is.readFloat();
        this.location.z = -is.readFloat();
        this.rotation = new Quat4f(is.readFloat(), is.readFloat(), -is.readFloat(), -is.readFloat());
        for (int pos = 0; pos < 64; pos += is.read(this.interpolation, pos, 64 - pos)) {
        }
    }

    public VMDMotion readFromBuffer(ByteBuffer bb) {
        this.boneIndex = bb.getShort();
        this.frameNo = bb.getInt();
        BufferUtil.readPoint3f(bb, this.location);
        BufferUtil.readQuat4f(bb, this.rotation);
        bb.get(this.interpolation);
        return this;
    }

    public VMDMotion writeToBuffer(ByteBuffer bb) {
        int startPos = bb.position();
        bb.putShort(this.boneIndex);
        bb.putInt(this.frameNo);
        BufferUtil.writePoint3f(bb, this.location);
        BufferUtil.writeQuat4f(bb, this.rotation);
        bb.put(this.interpolation);
        int endPos = bb.position();
        if (endPos - startPos != 98) {
            throw new RuntimeException("size = " + (endPos - startPos));
        }
        return this;
    }

    public VMDMotion set(VMDMotion m) {
        this.boneIndex = m.boneIndex;
        this.frameNo = m.frameNo;
        this.location.set((Tuple3f)m.location);
        this.rotation.set((Tuple4f)m.rotation);
        System.arraycopy(m.interpolation, 0, this.interpolation, 0, 64);
        this.vmdFile = m.vmdFile;
        return m;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{boneName = " + this.boneName + " frameNo = " + this.frameNo + " location = " + this.location + " rotation = " + this.rotation + " interpolation = {");
        for (int i = 0; i < 64; ++i) {
            sb.append(this.interpolation[i]).append(',');
        }
        sb.append("}}\n");
        return sb.toString();
    }

    public String getBoneName() {
        return this.vmdFile.boneNames.get(this.boneIndex);
    }

    public void setBoneName(String boneName) {
        this.boneName = boneName;
    }

    public int getFrameNo() {
        return this.frameNo;
    }

    public void setFlameNo(int frameNo) {
        this.frameNo = frameNo;
    }

    public byte[] getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(byte[] interpolation) {
        this.interpolation = interpolation;
    }

    public Point3f getLocation() {
        return this.location;
    }

    public void setLocation(Point3f location) {
        this.location = location;
    }

    public Quat4f getRotation() {
        return this.rotation;
    }

    public void setRotation(Quat4f rotation) {
        this.rotation = rotation;
    }
}

