/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.XColorRGB;
import projectkyoto.mmd.file.XColorRGBA;

public class XMaterial
implements Serializable {
    private XColorRGBA faceColor;
    private float power;
    private XColorRGB specularColor;
    private XColorRGB ambientColor;

    public XMaterial() {
    }

    public XMaterial(DataInputStreamLittleEndian is) throws IOException {
        this.faceColor = new XColorRGBA(is);
        this.power = is.readFloat();
        this.specularColor = new XColorRGB(is);
        this.ambientColor = new XColorRGB(is);
    }

    public void writeToStream(DataOutput os) throws IOException {
        this.faceColor.writeToStream(os);
        os.writeFloat(this.power);
        this.specularColor.writeToStream(os);
        this.ambientColor.writeToStream(os);
    }

    public String toString() {
        return "{faceColor = " + this.faceColor + " power = " + this.power + " specularColor = " + this.specularColor + " emissiveColor = " + this.ambientColor + "}";
    }

    public XColorRGB getAmbientColor() {
        return this.ambientColor;
    }

    public void setAmbientColor(XColorRGB ambientColor) {
        this.ambientColor = ambientColor;
    }

    public XColorRGBA getFaceColor() {
        return this.faceColor;
    }

    public void setFaceColor(XColorRGBA faceColor) {
        this.faceColor = faceColor;
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float power) {
        this.power = power;
    }

    public XColorRGB getSpecularColor() {
        return this.specularColor;
    }

    public void setSpecularColor(XColorRGB specularColor) {
        this.specularColor = specularColor;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMaterial other = (XMaterial)obj;
        if (!(this.faceColor == other.faceColor || this.faceColor != null && this.faceColor.equals(other.faceColor))) {
            return false;
        }
        if (Float.floatToIntBits(this.power) != Float.floatToIntBits(other.power)) {
            return false;
        }
        if (!(this.specularColor == other.specularColor || this.specularColor != null && this.specularColor.equals(other.specularColor))) {
            return false;
        }
        return this.ambientColor == other.ambientColor || this.ambientColor != null && this.ambientColor.equals(other.ambientColor);
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + (this.faceColor != null ? this.faceColor.hashCode() : 0);
        return hash;
    }
}

