/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file.util2;

import com.jme3.math.FastMath;
import com.jme3.util.BufferUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import projectkyoto.mmd.file.PMDMaterial;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDVertex;
import projectkyoto.mmd.file.util2.BufferUtil;
import projectkyoto.mmd.file.util2.MeshConverter;

public class MeshData {
    PMDModel model;
    int maxBoneSize;
    PMDMaterial material;
    List<Integer> boneList = new ArrayList<Integer>();
    List<Integer> indexList = new ArrayList<Integer>();
    List<Integer> vertIndexList = new ArrayList<Integer>();
    private PMDVertex tmpVert = new PMDVertex();
    ByteBuffer vfbb;
    ByteBuffer nfbb;
    ByteBuffer tfbb;
    ByteBuffer wfbb;
    ByteBuffer isbb;
    ByteBuffer bisbb;
    ByteBuffer indexBufferb;
    public FloatBuffer vfb;
    public FloatBuffer nfb;
    public FloatBuffer tfb;
    public FloatBuffer wfb;
    public ShortBuffer isb;
    public ShortBuffer bisb;
    public ShortBuffer indexBuffer;
    public int[] indexArray;

    public MeshData(PMDModel model, int maxBoneSize, PMDMaterial material) {
        this.model = model;
        this.maxBoneSize = maxBoneSize;
        this.material = material;
    }

    public boolean addTriangle(MeshConverter mc, int i1, int i2, int i3) {
        int boneListSizeBefore = this.boneList.size();
        this.addBoneList(i1);
        this.addBoneList(i2);
        this.addBoneList(i3);
        if (this.boneList.size() <= this.maxBoneSize) {
            this.addVertex(mc, i1);
            this.addVertex(mc, i2);
            this.addVertex(mc, i3);
            return true;
        }
        for (int i = this.boneList.size(); i > boneListSizeBefore; --i) {
            this.boneList.remove(i - 1);
        }
        return false;
    }

    private void addBoneList(int vertIndex) {
        PMDVertex v = this.model.getVertex(vertIndex, this.tmpVert);
        if (v.getBoneWeight() != 0 && !this.boneList.contains(v.getBoneNum1())) {
            this.boneList.add(v.getBoneNum1());
        }
        if (v.getBoneWeight() != 100 && !this.boneList.contains(v.getBoneNum2())) {
            this.boneList.add(v.getBoneNum2());
        }
    }

    private void addVertex(MeshConverter mc, int vertIndex) {
        int newVertIndex;
        Integer index = mc.meshTmpVertMap.get(vertIndex);
        if (index != null) {
            newVertIndex = index;
        } else {
            newVertIndex = this.vertIndexList.size();
            this.vertIndexList.add(vertIndex);
            mc.meshTmpVertMap.put(vertIndex, newVertIndex);
        }
        this.indexList.add(newVertIndex);
    }

    public void write(DataOutputStream os, byte[] buf) throws IOException {
        os.writeInt(this.material.getMaterialNo());
        BufferUtil.write(this.vfbb, os, buf);
        BufferUtil.write(this.nfbb, os, buf);
        if (this.tfbb != null) {
            os.writeBoolean(true);
            BufferUtil.write(this.tfbb, os, buf);
        } else {
            os.writeBoolean(false);
        }
        BufferUtil.write(this.wfbb, os, buf);
        BufferUtil.write(this.isbb, os, buf);
        BufferUtil.write(this.bisbb, os, buf);
        BufferUtil.write(this.indexBufferb, os, buf);
        os.writeInt(this.indexArray.length);
        for (int i : this.indexArray) {
            os.writeInt(i);
        }
    }

    public void read(DataInputStream is, byte[] buf) throws IOException {
        this.material = this.model.getMaterial()[is.readInt()];
        this.vfbb = BufferUtil.read(is, buf);
        this.vfb = this.vfbb.asFloatBuffer();
        this.nfbb = BufferUtil.read(is, buf);
        this.nfb = this.nfbb.asFloatBuffer();
        if (is.readBoolean()) {
            this.tfbb = BufferUtil.read(is, buf);
            this.tfb = this.tfbb.asFloatBuffer();
        }
        this.wfbb = BufferUtil.read(is, buf);
        this.wfb = this.wfbb.asFloatBuffer();
        this.isbb = BufferUtil.read(is, buf);
        this.isb = this.isbb.asShortBuffer();
        this.bisbb = BufferUtil.read(is, buf);
        this.bisb = this.bisbb.asShortBuffer();
        this.indexBufferb = BufferUtil.read(is, buf);
        this.indexBuffer = this.indexBufferb.asShortBuffer();
        int length = is.readInt();
        this.indexArray = new int[length];
        for (int i = 0; i < length; ++i) {
            this.indexArray[i] = is.readInt();
        }
    }

    void createMesh() {
        boolean textureFlag = true;
        if (this.getMaterial().getTextureFileName().length() == 0) {
            textureFlag = false;
        }
        this.vfbb = BufferUtils.createByteBuffer((int)(4 * this.getVertIndexList().size() * 3));
        this.vfb = this.vfbb.asFloatBuffer();
        this.nfbb = BufferUtils.createByteBuffer((int)(4 * this.getVertIndexList().size() * 3));
        this.nfb = this.nfbb.asFloatBuffer();
        this.tfb = null;
        if (textureFlag) {
            this.tfbb = BufferUtils.createByteBuffer((int)(4 * this.getVertIndexList().size() * 2));
            this.tfb = this.tfbb.asFloatBuffer();
        }
        this.wfbb = BufferUtils.createByteBuffer((int)(4 * this.getVertIndexList().size() * 2));
        this.wfb = this.wfbb.asFloatBuffer();
        this.isbb = BufferUtils.createByteBuffer((int)(2 * this.getIndexList().size()));
        this.isb = this.isbb.asShortBuffer();
        this.bisbb = BufferUtils.createByteBuffer((int)(2 * this.getVertIndexList().size() * 2));
        this.bisb = this.bisbb.asShortBuffer();
        PMDVertex v = new PMDVertex();
        for (Integer vertIndex : this.getVertIndexList()) {
            this.model.getVertex(vertIndex, v);
            this.vfb.put(v.getPos().x).put(v.getPos().y).put(v.getPos().z);
            this.nfb.put(v.getNormal().x).put(v.getNormal().y).put(v.getNormal().z);
            if (textureFlag) {
                float f1 = v.getUv().getU();
                float f2 = v.getUv().getV();
                f1 -= FastMath.floor((float)f1);
                f2 -= FastMath.floor((float)f2);
                f2 = 1.0f - f2;
                this.tfb.put(f1).put(f2);
            }
            float weight = (float)v.getBoneWeight() / 100.0f;
            this.wfb.put(weight).put(1.0f - weight);
            short b1 = (short)this.getBoneList().indexOf(v.getBoneNum1());
            short b2 = (short)this.getBoneList().indexOf(v.getBoneNum2());
            if (b1 < 0) {
                b1 = 0;
            }
            if (b2 < 0) {
                b2 = 0;
            }
            this.bisb.put(b1).put(b2);
        }
        for (Integer index : this.getIndexList()) {
            this.isb.put(index.shortValue());
        }
        this.indexArray = new int[this.getBoneList().size()];
        this.indexBufferb = BufferUtils.createByteBuffer((int)(2 * this.getBoneList().size()));
        this.indexBuffer = this.indexBufferb.asShortBuffer();
        for (int i = 0; i < this.indexArray.length; ++i) {
            this.indexArray[i] = i < this.getBoneList().size() ? (int)this.getBoneList().get(i).shortValue() : 0;
            this.indexBuffer.put((short)this.indexArray[i]);
        }
        this.boneList = null;
        this.vertIndexList = null;
        this.vertIndexList = null;
    }

    List<Integer> getBoneList() {
        return this.boneList;
    }

    public void setBoneList(List<Integer> boneList) {
        this.boneList = boneList;
    }

    public PMDMaterial getMaterial() {
        return this.material;
    }

    public void setMaterial(PMDMaterial material) {
        this.material = material;
    }

    public int getMaxBoneSize() {
        return this.maxBoneSize;
    }

    public void setMaxBoneSize(int maxBoneSize) {
        this.maxBoneSize = maxBoneSize;
    }

    public PMDModel getModel() {
        return this.model;
    }

    public void setModel(PMDModel model) {
        this.model = model;
    }

    List<Integer> getVertIndexList() {
        return this.vertIndexList;
    }

    List<Integer> getIndexList() {
        return this.indexList;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MeshData other = (MeshData)obj;
        return this == obj;
    }
}

