/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file.util2;

import com.jme3.math.FastMath;
import com.jme3.util.BufferUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import projectkyoto.mmd.file.PMDMaterial;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDSkinData;
import projectkyoto.mmd.file.PMDVertex;
import projectkyoto.mmd.file.util2.BufferUtil;
import projectkyoto.mmd.file.util2.MeshConverter;

public class SkinMeshData
implements Serializable {
    PMDModel model;
    List<Integer> boneList = new ArrayList<Integer>();
    List<PMDVertex> vertexList = new ArrayList<PMDVertex>();
    Map<PMDMaterial, List<Integer>> indexMap = new HashMap<PMDMaterial, List<Integer>>();
    public ByteBuffer skinvfbb;
    public ByteBuffer skinnfbb;
    public ByteBuffer skintfbb;
    public ByteBuffer skinbisbb;
    public ByteBuffer wfbb;
    public FloatBuffer skinvfb;
    public FloatBuffer skinvfb2;
    public FloatBuffer skinnfb;
    public FloatBuffer skintfb;
    public ShortBuffer skinbisb;
    public FloatBuffer wfb;
    public int[] skinIndexArray;
    public Map<PMDMaterial, ShortBuffer> indexShortBufferMap = new HashMap<PMDMaterial, ShortBuffer>();

    public SkinMeshData() {
    }

    public SkinMeshData(MeshConverter mc, PMDModel model) {
        this.model = model;
        if (model.getVertexBuffer() != null) {
            for (PMDSkinData sd : model.getSkinData()) {
                if (sd.getSkinType() != 0) continue;
                for (int i = 0; i < sd.getSkinVertCount(); ++i) {
                    int skinVertIndex = sd.getIndexBuf().get(i) & 0xFFFF;
                    try {
                        PMDVertex v = model.getVertex(skinVertIndex);
                        this.vertexList.add(v);
                        mc.skinTmpVertMap.put(skinVertIndex, i);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                break;
            }
        }
    }

    public void addTriangle(MeshConverter mc, PMDMaterial material, int i1, int i2, int i3) {
        this.addBoneList(i1);
        this.addBoneList(i2);
        this.addBoneList(i3);
        List<Integer> indexList = this.indexMap.get(material);
        if (indexList == null) {
            indexList = new ArrayList<Integer>();
            this.indexMap.put(material, indexList);
        }
        this.addVertex(mc, indexList, i1);
        this.addVertex(mc, indexList, i2);
        this.addVertex(mc, indexList, i3);
    }

    private void addBoneList(int vertIndex) {
        PMDVertex v = this.model.getVertex(vertIndex);
        if (!this.boneList.contains(v.getBoneNum1())) {
            this.boneList.add(v.getBoneNum1());
        }
        if (!this.boneList.contains(v.getBoneNum2())) {
            this.boneList.add(v.getBoneNum2());
        }
    }

    private void addVertex(MeshConverter mc, List<Integer> indexList, int vertIndex) {
        PMDVertex v = this.model.getVertex(vertIndex);
        Integer index = mc.skinTmpVertMap.get(vertIndex);
        if (index != null) {
            int newVertIndex = index;
        } else {
            int newVertIndex = this.vertexList.size();
            this.vertexList.add(v);
            mc.skinTmpVertMap.put(vertIndex, newVertIndex);
            index = newVertIndex;
        }
        indexList.add(index);
    }

    public void write(DataOutputStream os, byte[] buf) throws IOException {
        BufferUtil.write(this.skinvfbb, os, buf);
        BufferUtil.write(this.skinnfbb, os, buf);
        if (this.skintfbb != null) {
            os.writeBoolean(true);
            BufferUtil.write(this.skintfbb, os, buf);
        } else {
            os.writeBoolean(false);
        }
        BufferUtil.write(this.wfbb, os, buf);
        BufferUtil.write(this.skinbisbb, os, buf);
        os.writeInt(this.skinIndexArray.length);
        for (int i : this.skinIndexArray) {
            os.writeInt(i);
        }
        os.writeInt(this.indexShortBufferMap.size());
        for (PMDMaterial mat : this.indexShortBufferMap.keySet()) {
            short s;
            int i;
            os.writeInt(mat.getMaterialNo());
            ShortBuffer sb = this.indexShortBufferMap.get(mat);
            os.writeInt(sb.capacity() * 2);
            sb.position(0);
            if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                for (i = 0; i < sb.capacity(); ++i) {
                    s = sb.get();
                    os.writeByte(s);
                    os.writeByte(s >> 8);
                }
                continue;
            }
            for (i = 0; i < sb.capacity(); ++i) {
                s = sb.get();
                os.writeByte(s >> 8);
                os.writeByte(s);
            }
        }
    }

    public void read(DataInputStream is, byte[] buf) throws IOException {
        this.skinvfbb = BufferUtil.read(is, buf);
        this.skinvfb = this.skinvfbb.asFloatBuffer();
        this.skinnfbb = BufferUtil.read(is, buf);
        this.skinnfb = this.skinnfbb.asFloatBuffer();
        if (is.readBoolean()) {
            this.skintfbb = BufferUtil.read(is, buf);
            this.skintfb = this.skintfbb.asFloatBuffer();
        }
        this.wfbb = BufferUtil.read(is, buf);
        this.wfb = this.wfbb.asFloatBuffer();
        this.skinbisbb = BufferUtil.read(is, buf);
        this.skinbisb = this.skinbisbb.asShortBuffer();
        int length = is.readInt();
        this.skinIndexArray = new int[length];
        for (int i = 0; i < length; ++i) {
            this.skinIndexArray[i] = is.readInt();
        }
        int size = is.readInt();
        this.indexShortBufferMap = new HashMap<PMDMaterial, ShortBuffer>();
        for (int i = 0; i < size; ++i) {
            PMDMaterial mat = this.model.getMaterial()[is.readInt()];
            ShortBuffer sb = BufferUtil.read(is, buf).asShortBuffer();
            this.indexShortBufferMap.put(mat, sb);
        }
        this.skinvfb2 = BufferUtils.createFloatBuffer((int)this.skinvfb.capacity());
        this.skinvfb.position(0);
        this.skinvfb2.put(this.skinvfb);
    }

    void createSkinCommonVertData() {
        this.skinvfbb = BufferUtils.createByteBuffer((int)(this.getVertexList().size() * 3 * 4));
        this.skinvfb = this.skinvfbb.asFloatBuffer();
        this.skinvfb2 = BufferUtils.createFloatBuffer((int)(this.getVertexList().size() * 3));
        this.skinnfbb = BufferUtils.createByteBuffer((int)(this.getVertexList().size() * 3 * 4));
        this.skinnfb = this.skinnfbb.asFloatBuffer();
        this.skintfbb = BufferUtils.createByteBuffer((int)(this.getVertexList().size() * 2 * 4));
        this.skintfb = this.skintfbb.asFloatBuffer();
        this.skinbisbb = BufferUtils.createByteBuffer((int)(this.getVertexList().size() * 2 * 2));
        this.skinbisb = this.skinbisbb.asShortBuffer();
        this.wfbb = BufferUtils.createByteBuffer((int)(this.getVertexList().size() * 2 * 4));
        this.wfb = this.wfbb.asFloatBuffer();
        for (PMDVertex v : this.getVertexList()) {
            this.skinvfb.put(v.getPos().x).put(v.getPos().y).put(v.getPos().z);
            this.skinnfb.put(v.getNormal().x).put(v.getNormal().y).put(v.getNormal().z);
            float f1 = v.getUv().getU();
            float f2 = v.getUv().getV();
            f1 -= FastMath.floor((float)f1);
            f2 -= FastMath.floor((float)f2);
            f2 = 1.0f - f2;
            this.skintfb.put(f1).put(f2);
            short b1 = (short)this.getBoneList().indexOf(v.getBoneNum1());
            short b2 = (short)this.getBoneList().indexOf(v.getBoneNum2());
            if (b1 < 0) {
                b1 = 0;
            }
            if (b2 < 0) {
                b2 = 0;
            }
            this.skinbisb.put(b1).put(b2);
            float weight = (float)v.getBoneWeight() / 100.0f;
            this.wfb.put(weight).put(1.0f - weight);
        }
        this.skinvfb.position(0);
        this.skinvfb2.position(0);
        this.skinvfb2.put(this.skinvfb);
        this.skinnfb.position(0);
        this.skinIndexArray = new int[this.getBoneList().size()];
        for (int i = 0; i < this.skinIndexArray.length; ++i) {
            this.skinIndexArray[i] = i < this.getBoneList().size() ? (int)this.getBoneList().get(i).shortValue() : 0;
        }
        for (PMDMaterial key : this.indexMap.keySet()) {
            List<Integer> indexList = this.indexMap.get(key);
            ShortBuffer isb = BufferUtils.createShortBuffer((int)indexList.size());
            for (Integer index : indexList) {
                isb.put(index.shortValue());
            }
            this.indexShortBufferMap.put(key, isb);
        }
        this.indexMap = null;
        this.boneList = null;
        this.vertexList = null;
    }

    List<Integer> getBoneList() {
        return this.boneList;
    }

    public void setBoneList(List<Integer> boneList) {
        this.boneList = boneList;
    }

    public PMDModel getModel() {
        return this.model;
    }

    public void setModel(PMDModel model) {
        this.model = model;
    }

    public List<PMDVertex> getVertexList() {
        return this.vertexList;
    }

    public void setVertexList(List<PMDVertex> vertexList) {
        this.vertexList = vertexList;
    }

    Map<PMDMaterial, List<Integer>> getIndexMap() {
        return this.indexMap;
    }

    public void setIndexMap(Map<PMDMaterial, List<Integer>> indexMap) {
        this.indexMap = indexMap;
    }
}

