/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.BitSet;

public final class BoneAnimation
implements Animation,
Savable,
Cloneable {
    private String name;
    private float length;
    private BoneTrack[] tracks;

    public BoneAnimation(String name, float length) {
        this.name = name;
        this.length = length;
    }

    public BoneAnimation() {
    }

    public String getName() {
        return this.name;
    }

    public float getLength() {
        return this.length;
    }

    public void setTracks(BoneTrack[] tracks) {
        this.tracks = tracks;
    }

    public BoneTrack[] getTracks() {
        return this.tracks;
    }

    public void setTime(float time, float blendAmount, AnimControl control, AnimChannel channel) {
        BitSet affectedBones = channel.getAffectedBones();
        Skeleton skeleton = control.getSkeleton();
        if (this.tracks == null) {
            return;
        }
        for (int i = 0; i < this.tracks.length; ++i) {
            if (affectedBones != null && !affectedBones.get(this.tracks[i].getTargetBoneIndex())) continue;
            this.tracks[i].setTime(time, skeleton, blendAmount);
        }
    }

    public String toString() {
        return "BoneAnim[name=" + this.name + ", length=" + this.length + "]";
    }

    public BoneAnimation clone() {
        BoneAnimation result;
        try {
            result = (BoneAnimation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
        if (result.tracks == null) {
            result.tracks = new BoneTrack[this.tracks.length];
        }
        for (int i = 0; i < this.tracks.length; ++i) {
            int tablesLength = this.tracks[i].getTimes().length;
            float[] times = (float[])this.tracks[i].getTimes().clone();
            Vector3f[] sourceTranslations = this.tracks[i].getTranslations();
            Quaternion[] sourceRotations = this.tracks[i].getRotations();
            Vector3f[] sourceScales = this.tracks[i].getScales();
            Vector3f[] translations = new Vector3f[tablesLength];
            Quaternion[] rotations = new Quaternion[tablesLength];
            Vector3f[] scales = new Vector3f[tablesLength];
            for (int j = 0; j < tablesLength; ++j) {
                translations[j] = sourceTranslations[j].clone();
                rotations[j] = sourceRotations[j].clone();
                scales[j] = sourceScales != null ? sourceScales[j].clone() : new Vector3f(1.0f, 1.0f, 1.0f);
            }
            result.tracks[i] = new BoneTrack(this.tracks[i].getTargetBoneIndex(), times, translations, rotations, scales);
        }
        return result;
    }

    public void write(JmeExporter e) throws IOException {
        OutputCapsule out = e.getCapsule(this);
        out.write(this.name, "name", null);
        out.write(this.length, "length", 0.0f);
        out.write(this.tracks, "tracks", null);
    }

    public void read(JmeImporter i) throws IOException {
        InputCapsule in = i.getCapsule(this);
        this.name = in.readString("name", null);
        this.length = in.readFloat("length", 0.0f);
        Savable[] sav = in.readSavableArray("tracks", null);
        if (sav != null) {
            this.tracks = new BoneTrack[sav.length];
            System.arraycopy(sav, 0, this.tracks, 0, sav.length);
        }
    }
}

